/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token.ciba;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import lombok.Generated;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.ticket.OidcCibaRequest;
import org.apereo.cas.oidc.token.ciba.CibaTokenDeliveryHandler;
import org.apereo.cas.services.OidcBackchannelTokenDeliveryModes;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class CibaPingTokenDeliveryHandler
implements CibaTokenDeliveryHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CibaPingTokenDeliveryHandler.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().singleValueAsArray(true).defaultTypingEnabled(false).build().toObjectMapper();
    private final OidcBackchannelTokenDeliveryModes deliveryMode = OidcBackchannelTokenDeliveryModes.PING;
    private final OidcConfigurationContext configurationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ?> deliver(OidcRegisteredService registeredService, OidcCibaRequest cibaRequest) throws Throwable {
        Map<String, String> map;
        HttpResponse response = null;
        try {
            String clientNotificationValue = (String)cibaRequest.getAuthentication().getSingleValuedAttribute("client_notification_token");
            Map<String, String> payload = Map.of("auth_req_id", cibaRequest.getEncodedId());
            HttpExecutionRequest exec = HttpExecutionRequest.builder().bearerToken(clientNotificationValue).method(HttpMethod.POST).url(registeredService.getBackchannelClientNotificationEndpoint()).entity(MAPPER.writeValueAsString(payload)).httpClient(this.configurationContext.getHttpClient()).headers(CollectionUtils.wrap((String)"Content-Type", (Object)"application/json")).build();
            LOGGER.debug("Sending a POST request to [{}] with payload [{}]", (Object)exec.getUrl(), (Object)exec.getEntity());
            response = HttpUtils.execute((HttpExecutionRequest)exec);
            FunctionUtils.throwIf((!HttpStatus.valueOf((int)response.getCode()).is2xxSuccessful() ? 1 : 0) != 0, () -> new HttpException("Unable to deliver tokens to client application %s".formatted(registeredService.getName())));
            LOGGER.debug("Marking CIBA authentication request [{}] as ready", (Object)cibaRequest.getEncodedId());
            this.configurationContext.getTicketRegistry().updateTicket((Ticket)cibaRequest.markTicketReady());
            map = payload;
        }
        catch (Throwable throwable) {
            HttpUtils.close(response);
            throw throwable;
        }
        HttpUtils.close((HttpResponse)response);
        return map;
    }

    @Generated
    public CibaPingTokenDeliveryHandler(OidcConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    @Override
    @Generated
    public OidcBackchannelTokenDeliveryModes getDeliveryMode() {
        return this.deliveryMode;
    }

    @Generated
    public OidcConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }
}

