/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.attribute.AttributeDefinition;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.claims.OidcAttributeDefinition;
import org.apereo.cas.oidc.claims.OidcAttributeToScopeClaimMapper;
import org.apereo.cas.oidc.claims.OidcIdTokenClaimCollector;
import org.apereo.cas.oidc.claims.OidcScopeFreeAttributeReleasePolicy;
import org.apereo.cas.services.OidcBackchannelTokenDeliveryModes;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceChainingAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceOidcIdTokenExpirationPolicy;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenHashGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncoder;
import org.apereo.cas.ticket.AuthenticationAwareTicket;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.idtoken.BaseIdTokenGeneratorService;
import org.apereo.cas.ticket.idtoken.IdTokenGenerationContext;
import org.apereo.cas.ticket.idtoken.OidcIdToken;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.crypto.EncodableCipher;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class OidcIdTokenGeneratorService
extends BaseIdTokenGeneratorService<OidcConfigurationContext> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcIdTokenGeneratorService.class);

    public OidcIdTokenGeneratorService(ObjectProvider<OidcConfigurationContext> configurationContext) {
        super(configurationContext);
    }

    private static void setClaim(JwtClaims claims, String claimName, Object claimValue) {
        if (claimValue != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)claimValue.toString())) {
            claims.setClaim(claimName, claimValue);
        }
    }

    @Audit(action="OIDC_ID_TOKEN", actionResolverName="OIDC_ID_TOKEN_ACTION_RESOLVER", resourceResolverName="OIDC_ID_TOKEN_RESOURCE_RESOLVER")
    public OidcIdToken generate(IdTokenGenerationContext context) throws Throwable {
        Assert.isAssignable(OidcRegisteredService.class, context.getRegisteredService().getClass(), (String)"Registered service instance is not registered as an OpenID Connect application");
        if (!context.getAccessToken().getScopes().contains(OidcConstants.StandardScopes.OPENID.getScope())) {
            LOGGER.warn("Authentication request does not include the [{}] scope. Including this scope is a MUST for OpenID Connect and CAS will not produce an ID token without this scope.", (Object)OidcConstants.StandardScopes.OPENID.getScope());
            return null;
        }
        JwtClaims claims = this.buildJwtClaims(context);
        String finalIdToken = this.encodeAndFinalizeToken(claims, context);
        return new OidcIdToken(finalIdToken, claims);
    }

    protected JwtClaims buildJwtClaims(IdTokenGenerationContext context) throws Throwable {
        boolean includeClaims;
        OAuth20AccessToken accessToken = context.getAccessToken();
        LOGGER.trace("Attempting to produce claims for the id token [{}]", (Object)accessToken);
        Authentication authentication = accessToken.getAuthentication();
        Principal activePrincipal = this.buildPrincipalForAttributeFilter(accessToken, (RegisteredService)context.getRegisteredService());
        Principal principal = ((OidcConfigurationContext)this.getConfigurationContext()).getProfileScopeToAttributesFilter().filter(accessToken.getService(), activePrincipal, (RegisteredService)context.getRegisteredService(), accessToken);
        LOGGER.debug("Principal to use to build the ID token is [{}]", (Object)principal);
        OidcProperties oidc = ((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties().getAuthn().getOidc();
        JwtClaims claims = new JwtClaims();
        String jwtId = this.getJwtId(accessToken);
        LOGGER.debug("Calculated ID token jti claim to be [{}]", (Object)jwtId);
        claims.setJwtId(jwtId);
        claims.setClaim("sid", (Object)DigestUtils.sha((String)jwtId));
        OidcRegisteredService oidcRegisteredService = (OidcRegisteredService)context.getRegisteredService();
        claims.setIssuer(((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().determineIssuer(Optional.of(oidcRegisteredService)));
        List<Object> audience = context.getRegisteredService().getAudience().isEmpty() ? List.of(accessToken.getClientId()) : new ArrayList(context.getRegisteredService().getAudience());
        claims.setAudience(audience);
        LOGGER.debug("Calculated ID token aud claim to be [{}]", audience);
        this.buildExpirationClaim(claims, oidcRegisteredService);
        claims.setIssuedAtToNow();
        claims.setNotBeforeMinutesInThePast((float)Beans.newDuration((String)oidc.getCore().getSkew()).toMinutes());
        claims.setSubject(principal.getId());
        this.buildAuthenticationContextClassRef(claims, authentication);
        Set<Object> amrValues = this.buildAuthenticationMethods(authentication);
        if (!amrValues.isEmpty()) {
            LOGGER.debug("ID token amr claim calculated as [{}]", amrValues);
            claims.setStringListClaim("amr", amrValues.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        }
        Map attributes = authentication.getAttributes();
        claims.setStringClaim("client_id", context.getRegisteredService().getClientId());
        long authTime = accessToken.isStateless() || accessToken.getTicketGrantingTicket() == null ? authentication.getAuthenticationDate().toEpochSecond() : ((AuthenticationAwareTicket)accessToken.getTicketGrantingTicket()).getAuthentication().getAuthenticationDate().toEpochSecond();
        claims.setClaim("auth_time", (Object)authTime);
        if (attributes.containsKey("state")) {
            OidcIdTokenGeneratorService.setClaim(claims, "state", ((List)attributes.get("state")).getFirst());
        }
        if (attributes.containsKey("nonce")) {
            OidcIdTokenGeneratorService.setClaim(claims, "nonce", ((List)attributes.get("nonce")).getFirst());
        }
        this.generateAccessTokenHash(accessToken, oidcRegisteredService, claims);
        boolean bl = includeClaims = context.getResponseType() != OAuth20ResponseTypes.CODE && context.getGrantType() != OAuth20GrantTypes.AUTHORIZATION_CODE;
        if (includeClaims || this.includeClaimsInIdTokenForcefully(context)) {
            FunctionUtils.doIf((boolean)this.includeClaimsInIdTokenForcefully(context), __ -> LOGGER.warn("Individual claims requested by OpenID scopes are forced to be included in the ID token. This is a violation of the OpenID Connect specification and a workaround via dedicated CAS configuration. Claims should be requested from the userinfo/profile endpoints in exchange for an access token.")).accept(claims);
            this.collectIdTokenClaims(principal, (RegisteredService)context.getRegisteredService(), claims);
        } else {
            LOGGER.debug("Per OpenID Connect specification, individual claims requested by OpenID scopes such as profile, email, address, etc. are only put into the OpenID Connect ID token when the response type is set to id_token.");
        }
        claims.setStringClaim("txn", UUID.randomUUID().toString());
        if (context.getGrantType() == OAuth20GrantTypes.CIBA) {
            this.generateCibaClaims(context, claims);
        }
        return claims;
    }

    private boolean includeClaimsInIdTokenForcefully(IdTokenGenerationContext context) {
        OidcRegisteredService oidcService = (OidcRegisteredService)context.getRegisteredService();
        OidcProperties properties = ((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties().getAuthn().getOidc();
        return properties.getIdToken().isIncludeIdTokenClaims() || oidcService.isIncludeIdTokenClaims();
    }

    private void generateCibaClaims(IdTokenGenerationContext context, JwtClaims claims) throws Throwable {
        OidcBackchannelTokenDeliveryModes deliveryMode = OidcBackchannelTokenDeliveryModes.valueOf((String)((OidcRegisteredService)context.getRegisteredService()).getBackchannelTokenDeliveryMode().toUpperCase(Locale.ENGLISH));
        if (deliveryMode == OidcBackchannelTokenDeliveryModes.PUSH) {
            String requestId = (String)context.getAccessToken().getAuthentication().getSingleValuedAttribute("auth_req_id");
            claims.setStringClaim("urn:openid:params:jwt:claim:auth_req_id", requestId);
            if (context.getRefreshToken() != null) {
                PublicJsonWebKey jsonWebKey = ((OidcConfigurationContext)this.getConfigurationContext()).getIdTokenSigningAndEncryptionService().getJsonWebKeySigningKey(Optional.of(context.getRegisteredService()));
                String alg = ((OidcConfigurationContext)this.getConfigurationContext()).getIdTokenSigningAndEncryptionService().getJsonWebKeySigningAlgorithm(context.getRegisteredService(), (JsonWebKey)jsonWebKey);
                String hash = OAuth20TokenHashGenerator.builder().token(context.getRefreshToken().getId()).algorithm(alg).registeredService((RegisteredService)context.getRegisteredService()).build().generate();
                claims.setClaim("urn:openid:params:jwt:claim:rt_hash", (Object)hash);
            }
        }
    }

    protected void buildExpirationClaim(JwtClaims claims, OidcRegisteredService registeredService) {
        ExpirationPolicy expirationPolicy = ((OidcConfigurationContext)this.getConfigurationContext()).getIdTokenExpirationPolicy().buildTicketExpirationPolicy();
        Long timeoutInSeconds = Optional.ofNullable(registeredService.getIdTokenExpirationPolicy()).map(RegisteredServiceOidcIdTokenExpirationPolicy::getTimeToKill).filter(org.apache.commons.lang3.StringUtils::isNotBlank).map(ttl -> Beans.newDuration((String)ttl).getSeconds()).orElseGet(() -> ((ExpirationPolicy)expirationPolicy).getTimeToLive());
        LOGGER.debug("ID token expiration policy set to expire the ID token in [{}]", (Object)timeoutInSeconds);
        NumericDate expirationDate = NumericDate.now();
        expirationDate.addSeconds(timeoutInSeconds.longValue());
        claims.setExpirationTime(expirationDate);
        LOGGER.debug("Calculated ID token expiration claim to be [{}]", (Object)expirationDate);
    }

    protected void buildAuthenticationContextClassRef(JwtClaims claims, Authentication authentication) {
        MultifactorAuthenticationProperties mfa = ((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties().getAuthn().getMfa();
        OidcProperties oidc = ((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties().getAuthn().getOidc();
        Map attributes = authentication.getAttributes();
        List<String> mappedAcrValues = StringUtils.commaDelimitedListToSet((String)mfa.getCore().getAuthenticationContextAttribute()).stream().map(attribute -> {
            if (attributes.containsKey(attribute)) {
                Set acrValues = CollectionUtils.toCollection(attributes.get(attribute));
                List authnContexts = oidc.getCore().getAuthenticationContextReferenceMappings();
                Map mappings = CollectionUtils.convertDirectedListToMap((Collection)authnContexts);
                String acrMapped = acrValues.stream().map(acrValue -> mappings.entrySet().stream().filter(entry -> ((String)entry.getValue()).equalsIgnoreCase(acrValue.toString())).map(Map.Entry::getKey).findFirst().orElseGet(acrValue::toString)).collect(Collectors.joining(" "));
                LOGGER.debug("ID token acr claim calculated as [{}]", (Object)acrMapped);
                return acrMapped;
            }
            return null;
        }).filter(Objects::nonNull).toList();
        if (!mappedAcrValues.isEmpty()) {
            FunctionUtils.doIf((mappedAcrValues.size() == 1 ? 1 : 0) != 0, __ -> claims.setStringClaim("acr", (String)mappedAcrValues.getFirst()), __ -> claims.setStringListClaim("acr", mappedAcrValues)).accept(mappedAcrValues);
        }
    }

    private Principal buildPrincipalForAttributeFilter(OAuth20AccessToken accessToken, RegisteredService registeredService) throws Throwable {
        Authentication authentication = accessToken.getAuthentication();
        HashMap attributes = new HashMap(authentication.getPrincipal().getAttributes());
        Map authnAttributes = ((OidcConfigurationContext)this.getConfigurationContext()).getAuthenticationAttributeReleasePolicy().getAuthenticationAttributesForRelease(authentication, registeredService);
        attributes.putAll(authnAttributes);
        return ((OidcConfigurationContext)this.getConfigurationContext()).getPrincipalFactory().createPrincipal(authentication.getPrincipal().getId(), attributes);
    }

    protected void collectIdTokenClaims(Principal principal, RegisteredService registeredService, JwtClaims claims) {
        OidcProperties oidc = ((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties().getAuthn().getOidc();
        LOGGER.trace("Comparing principal attributes [{}] with supported claims [{}]", (Object)principal.getAttributes(), (Object)oidc.getDiscovery().getClaims());
        principal.getAttributes().entrySet().stream().filter(entry -> {
            if (this.isClaimSupportedForRelease((String)entry.getKey(), registeredService)) {
                LOGGER.trace("Found supported claim [{}]", entry.getKey());
                return true;
            }
            LOGGER.debug("Claim [{}] is not defined as a supported claim among [{}]. Skipping...", entry.getKey(), (Object)oidc.getDiscovery().getClaims());
            return false;
        }).forEach(entry -> this.handleMappedClaimOrDefault((String)entry.getKey(), registeredService, principal, claims, entry.getValue()));
        if (!claims.hasClaim("preferred_username")) {
            this.handleMappedClaimOrDefault("preferred_username", registeredService, principal, claims, principal.getId());
        }
        ((OidcConfigurationContext)this.getConfigurationContext()).getIdTokenClaimCollectors().forEach(collector -> collector.conclude(claims));
    }

    private boolean isClaimSupportedForRelease(String claimName, RegisteredService registeredService) {
        OidcAttributeToScopeClaimMapper mapper = ((OidcConfigurationContext)this.getConfigurationContext()).getAttributeToScopeClaimMapper();
        String mappedClaim = mapper.toMappedClaimName(claimName, registeredService);
        OidcProperties oidc = ((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties().getAuthn().getOidc();
        List claims = oidc.getDiscovery().getClaims();
        LOGGER.trace("Checking if any of [{}] are specified in the list of discovery claims [{}]", (Object)ImmutableSet.of((Object)claimName, (Object)mappedClaim), (Object)claims);
        return claims.contains(claimName) || claims.contains(mappedClaim) || this.isClaimDefinitionSupportedForRelease(mappedClaim) || this.isClaimReleasedAllowedByScopeFreePolicy(claimName, registeredService);
    }

    protected boolean isClaimReleasedAllowedByScopeFreePolicy(String claimName, RegisteredService registeredService) {
        RegisteredServiceAttributeReleasePolicy registeredServiceAttributeReleasePolicy = registeredService.getAttributeReleasePolicy();
        if (registeredServiceAttributeReleasePolicy instanceof OidcScopeFreeAttributeReleasePolicy) {
            OidcScopeFreeAttributeReleasePolicy policy2 = (OidcScopeFreeAttributeReleasePolicy)registeredServiceAttributeReleasePolicy;
            List allowedAttributes = policy2.getAllowedAttributes();
            LOGGER.trace("Checking if claim [{}] is allowed by the scope-free policy [{}]", (Object)claimName, (Object)allowedAttributes);
            return !policy2.claimsMustBeDefinedViaDiscovery() && allowedAttributes.contains(claimName);
        }
        registeredServiceAttributeReleasePolicy = registeredService.getAttributeReleasePolicy();
        if (registeredServiceAttributeReleasePolicy instanceof RegisteredServiceChainingAttributeReleasePolicy) {
            RegisteredServiceChainingAttributeReleasePolicy chain = (RegisteredServiceChainingAttributeReleasePolicy)registeredServiceAttributeReleasePolicy;
            return chain.getPolicies().stream().filter(OidcScopeFreeAttributeReleasePolicy.class::isInstance).map(OidcScopeFreeAttributeReleasePolicy.class::cast).filter(policy -> !policy.claimsMustBeDefinedViaDiscovery()).anyMatch(policy -> policy.getAllowedAttributes().contains(claimName));
        }
        return false;
    }

    private boolean isClaimDefinitionSupportedForRelease(String claimName) {
        OidcProperties oidc = ((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties().getAuthn().getOidc();
        List claims = oidc.getDiscovery().getClaims();
        String definitionName = ((OidcConfigurationContext)this.getConfigurationContext()).getAttributeDefinitionStore().locateAttributeDefinitionByName(claimName).filter(OidcAttributeDefinition.class::isInstance).map(AttributeDefinition::getKey).orElse(claimName);
        LOGGER.trace("Checking if attribute definition [{}] is specified in the list of discovery claims [{}]", (Object)definitionName, (Object)claims);
        return claims.contains(definitionName);
    }

    protected void handleMappedClaimOrDefault(String claimName, RegisteredService registeredService, Principal principal, JwtClaims claims, Object defaultValue) {
        OidcAttributeToScopeClaimMapper mapper = ((OidcConfigurationContext)this.getConfigurationContext()).getAttributeToScopeClaimMapper();
        List collectionValues = mapper.mapClaim(claimName, registeredService, principal, defaultValue);
        List<OidcIdTokenClaimCollector> collectors = ((OidcConfigurationContext)this.getConfigurationContext()).getIdTokenClaimCollectors();
        collectors.forEach(collector -> collector.collect(claims, claimName, collectionValues));
    }

    protected String getJwtId(OAuth20AccessToken ticket) {
        String jwtId = ticket.getId();
        if (ticket.getTicketGrantingTicket() != null) {
            jwtId = ticket.getTicketGrantingTicket().getId();
        }
        if (ticket instanceof TicketGrantingTicket) {
            TicketGrantingTicket tgt = (TicketGrantingTicket)ticket;
            String oAuthCallbackUrl = ((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties().getServer().getPrefix() + "/oauth2.0/callbackAuthorize.*";
            LinkedHashMap streamServices = new LinkedHashMap();
            Map services = tgt.getServices();
            streamServices.putAll(services);
            streamServices.putAll(tgt.getProxyGrantingTickets());
            jwtId = streamServices.entrySet().stream().filter(e -> {
                RegisteredService service = ((OidcConfigurationContext)this.getConfigurationContext()).getServicesManager().findServiceBy((Service)e.getValue());
                return service != null && service.getServiceId().equals(oAuthCallbackUrl);
            }).findFirst().map(Map.Entry::getKey).orElseGet(() -> ((OAuth20AccessToken)ticket).getId());
        }
        return DigestUtils.sha512((String)jwtId);
    }

    protected void generateAccessTokenHash(OAuth20AccessToken accessToken, OidcRegisteredService registeredService, JwtClaims claims) throws Throwable {
        String oidcIssuer = ((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().determineIssuer(Optional.of(registeredService));
        EncodableCipher cipher = OAuth20JwtAccessTokenEncoder.toEncodableCipher((OAuth20ConfigurationContext)this.getConfigurationContext(), (RegisteredService)registeredService, (OAuth20AccessToken)accessToken, (String)oidcIssuer);
        String encodedAccessToken = (String)cipher.encode((Object)accessToken.getId());
        PublicJsonWebKey jsonWebKey = ((OidcConfigurationContext)this.getConfigurationContext()).getIdTokenSigningAndEncryptionService().getJsonWebKeySigningKey(Optional.of(registeredService));
        String alg = ((OidcConfigurationContext)this.getConfigurationContext()).getIdTokenSigningAndEncryptionService().getJsonWebKeySigningAlgorithm((OAuthRegisteredService)registeredService, (JsonWebKey)jsonWebKey);
        String hash = OAuth20TokenHashGenerator.builder().token(encodedAccessToken).algorithm(alg).registeredService((RegisteredService)registeredService).build().generate();
        claims.setClaim("at_hash", (Object)hash);
    }

    protected Set<Object> buildAuthenticationMethods(Authentication authentication) {
        HashMap allAttributes = new HashMap(authentication.getAttributes());
        allAttributes.putAll(authentication.getPrincipal().getAttributes());
        return Stream.of("successfulAuthenticationHandlers", "authenticationMethod").filter(allAttributes::containsKey).map(name -> CollectionUtils.toCollection(allAttributes.get(name))).findFirst().orElseGet(Set::of);
    }
}

