/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.ticket;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcCibaProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcPushedAuthorizationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.oidc.ticket.OidcCibaRequest;
import org.apereo.cas.oidc.ticket.OidcDefaultCibaRequest;
import org.apereo.cas.oidc.ticket.OidcDefaultPushedAuthorizationRequest;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequest;
import org.apereo.cas.ticket.BaseTicketCatalogConfigurer;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcTicketCatalogConfigurer
extends BaseTicketCatalogConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcTicketCatalogConfigurer.class);

    public void configureTicketCatalog(TicketCatalog plan, CasConfigurationProperties casProperties) throws Throwable {
        LOGGER.trace("Registering OpenID Connect protocol ticket definitions...");
        this.buildAndRegisterCibaRequestDefinition(plan, this.buildTicketDefinition(plan, "CIBA", OidcCibaRequest.class, OidcDefaultCibaRequest.class, Integer.MIN_VALUE), casProperties);
        this.buildAndRegisterPushedAuthorizationRequestDefinition(plan, this.buildTicketDefinition(plan, "OPAR", OidcPushedAuthorizationRequest.class, OidcDefaultPushedAuthorizationRequest.class, Integer.MIN_VALUE), casProperties);
    }

    protected void buildAndRegisterCibaRequestDefinition(TicketCatalog plan, TicketDefinition metadata, CasConfigurationProperties casProperties) {
        OidcCibaProperties ciba = casProperties.getAuthn().getOidc().getCiba();
        metadata.getProperties().setStorageName(ciba.getStorageName());
        long timeout = Beans.newDuration((String)ciba.getMaxTimeToLiveInSeconds()).getSeconds();
        metadata.getProperties().setStorageTimeout(timeout);
        metadata.getProperties().setExcludeFromCascade(casProperties.getTicket().isTrackDescendantTickets());
        this.registerTicketDefinition(plan, metadata);
    }

    protected void buildAndRegisterPushedAuthorizationRequestDefinition(TicketCatalog plan, TicketDefinition metadata, CasConfigurationProperties casProperties) {
        OidcPushedAuthorizationProperties par = casProperties.getAuthn().getOidc().getPar();
        metadata.getProperties().setStorageName(par.getStorageName());
        long timeout = Beans.newDuration((String)par.getMaxTimeToLiveInSeconds()).getSeconds();
        metadata.getProperties().setStorageTimeout(timeout);
        metadata.getProperties().setExcludeFromCascade(casProperties.getTicket().isTrackDescendantTickets());
        this.registerTicketDefinition(plan, metadata);
    }
}

