/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.ticket;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.Duration;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcPushedAuthorizationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequest;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.expiration.MultiTimeUseOrTimeoutExpirationPolicy;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public record OidcPushedAuthorizationRequestExpirationPolicyBuilder(CasConfigurationProperties casProperties) implements ExpirationPolicyBuilder<OidcPushedAuthorizationRequest>
{
    private static final long serialVersionUID = -372536596516253646L;

    public ExpirationPolicy buildTicketExpirationPolicy() {
        return this.toTicketExpirationPolicy();
    }

    public ExpirationPolicy toTicketExpirationPolicy() {
        OidcPushedAuthorizationProperties par = this.casProperties.getAuthn().getOidc().getPar();
        Duration exp = Beans.newDuration((String)par.getMaxTimeToLiveInSeconds());
        return new OidcPushedAuthorizationRequestExpirationPolicy(par.getNumberOfUses(), exp.getSeconds());
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
    public static class OidcPushedAuthorizationRequestExpirationPolicy
    extends MultiTimeUseOrTimeoutExpirationPolicy {
        private static final long serialVersionUID = -8814501080268311070L;

        @JsonCreator
        public OidcPushedAuthorizationRequestExpirationPolicy(@JsonProperty(value="numberOfUses") long numberOfUses, @JsonProperty(value="timeToLive") long timeToKillInSeconds) {
            super(numberOfUses, timeToKillInSeconds);
        }

        @Generated
        public String toString() {
            return "OidcPushedAuthorizationRequestExpirationPolicyBuilder.OidcPushedAuthorizationRequestExpirationPolicy(super=" + super.toString() + ")";
        }
    }
}

