/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.profile;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.claims.BaseOidcScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcScopeFreeAttributeReleasePolicy;
import org.apereo.cas.oidc.scopes.OidcAttributeReleasePolicyFactory;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.support.oauth.profile.DefaultOAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.ticket.AuthenticationAwareTicket;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class OidcProfileScopeToAttributesFilter
extends DefaultOAuth20ProfileScopeToAttributesFilter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcProfileScopeToAttributesFilter.class);
    private final PrincipalFactory principalFactory;
    private final CasConfigurationProperties casProperties;
    private final OidcAttributeReleasePolicyFactory oidcAttributeReleasePolicyFactory;
    private final ConfigurableApplicationContext applicationContext;

    public Principal filter(Service service, Principal givenPrincipal, RegisteredService registeredService, Set<String> scopes, OAuth20AccessToken accessToken) throws Throwable {
        Principal principal = super.filter(service, givenPrincipal, registeredService, scopes, accessToken);
        if (registeredService instanceof OidcRegisteredService) {
            OidcRegisteredService oidcService = (OidcRegisteredService)registeredService;
            return this.filterClaimsForOidcService(service, givenPrincipal, accessToken, principal, scopes, oidcService);
        }
        return principal;
    }

    protected Principal filterClaimsForOidcService(Service service, Principal givenPrincipal, OAuth20AccessToken accessToken, Principal filteredPrincipal, Set<String> scopes, OidcRegisteredService oidcService) throws Throwable {
        if (!scopes.contains(OidcConstants.StandardScopes.OPENID.getScope())) {
            LOGGER.warn("Access token scopes [{}] cannot identify an OpenID Connect request with [{}] scope(s). This is a REQUIRED scope for OpenID Connect that MUST be present in the request. Given its absence, CAS will not process any attribute claims and will return the authenticated principal as is.", (Object)OidcConstants.StandardScopes.OPENID.getScope(), scopes.isEmpty() ? "empty" : scopes);
            return this.principalFactory.createPrincipal(givenPrincipal.getId());
        }
        scopes.retainAll(this.casProperties.getAuthn().getOidc().getDiscovery().getScopes());
        LOGGER.debug("Collection of scopes filtered based on discovery settings are [{}]", scopes);
        Map<String, List<Object>> attributes = this.getAttributesAllowedForService(scopes, filteredPrincipal, service, oidcService, accessToken);
        LOGGER.debug("Collection of claims filtered by scopes [{}] are [{}]", scopes, attributes);
        this.filterAttributesByAccessTokenRequestedClaims(oidcService, accessToken, filteredPrincipal, attributes);
        LOGGER.debug("Final collection of claims are [{}]", attributes);
        return this.principalFactory.createPrincipal(givenPrincipal.getId(), attributes);
    }

    protected void filterAttributesByAccessTokenRequestedClaims(OidcRegisteredService oidcService, OAuth20AccessToken accessToken, Principal principal, Map<String, List<Object>> attributes) {
        Ticket ticket;
        Set userInfo = OAuth20Utils.parseUserInfoRequestClaims((OAuth20Token)accessToken);
        if (userInfo.isEmpty()) {
            LOGGER.trace("No userinfo requested claims are available");
        } else if (accessToken != null && (ticket = accessToken.getTicketGrantingTicket()) instanceof AuthenticationAwareTicket) {
            AuthenticationAwareTicket aat = (AuthenticationAwareTicket)ticket;
            Map principalAttributes = aat.getAuthentication().getPrincipal().getAttributes();
            LOGGER.debug("Requested user-info claims [{}] are compared against principal attributes [{}]", (Object)userInfo, (Object)principalAttributes);
            userInfo.stream().filter(principalAttributes::containsKey).forEach(key -> attributes.put((String)key, (List)principalAttributes.get(key)));
        }
    }

    protected Map<String, List<Object>> filterAttributesByScope(Collection<String> scopes, Principal principal, Service service, OidcRegisteredService registeredService, OAuth20AccessToken accessToken) {
        if (scopes.isEmpty()) {
            LOGGER.info("No defined scopes are available to instruct attribute release policies for [{}]. CAS will NOT authorize the collection of resolved claims for release to [{}]", (Object)registeredService.getServiceId(), (Object)service.getId());
            return new HashMap<String, List<Object>>();
        }
        Map<String, BaseOidcScopeAttributeReleasePolicy> effectiveAttributeReleasePolicies = this.oidcAttributeReleasePolicyFactory.resolvePolicies(registeredService);
        LinkedHashMap<String, List<Object>> attributes = new LinkedHashMap<String, List<Object>>();
        scopes.stream().distinct().filter(effectiveAttributeReleasePolicies::containsKey).map(scope -> {
            BaseOidcScopeAttributeReleasePolicy policy = (BaseOidcScopeAttributeReleasePolicy)effectiveAttributeReleasePolicies.get(scope);
            return this.getAttributesFromPolicy(principal, service, registeredService, policy);
        }).forEach(attributes::putAll);
        effectiveAttributeReleasePolicies.values().stream().filter(OidcScopeFreeAttributeReleasePolicy.class::isInstance).forEach(policy -> {
            Map<String, List<Object>> policyAttr = this.getAttributesFromPolicy(principal, service, registeredService, (BaseOidcScopeAttributeReleasePolicy)policy);
            attributes.putAll(policyAttr);
        });
        LOGGER.debug("Final collection of attributes based on scopes are [{}]", attributes);
        return attributes;
    }

    protected Map<String, List<Object>> getAttributesFromPolicy(Principal principal, Service service, OidcRegisteredService registeredService, BaseOidcScopeAttributeReleasePolicy policy) {
        return (Map)FunctionUtils.doUnchecked(() -> {
            RegisteredServiceAttributeReleasePolicyContext releasePolicyContext = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)registeredService).service(service).principal(principal).applicationContext((ApplicationContext)this.applicationContext).build();
            Map policyAttr = policy.getAttributes(releasePolicyContext);
            LOGGER.debug("Calculated attributes [{}] via attribute release policy [{}]", (Object)policyAttr, (Object)policy.getName());
            return policyAttr;
        });
    }

    protected Map<String, List<Object>> getAttributesAllowedForService(Collection<String> scopes, Principal principal, Service service, OidcRegisteredService oidcService, OAuth20AccessToken accessToken) throws Throwable {
        boolean scopeFree;
        Set serviceScopes = oidcService.getScopes();
        LOGGER.trace("Scopes assigned to service definition [{}] are [{}]", (Object)oidcService.getName(), (Object)serviceScopes);
        boolean bl = scopeFree = serviceScopes.isEmpty() || serviceScopes.size() == 1 && serviceScopes.contains(OidcConstants.StandardScopes.OPENID.getScope());
        if (!scopeFree) {
            scopes.retainAll(serviceScopes);
            LOGGER.trace("Service definition [{}] will filter claims based on scopes [{}]", (Object)oidcService.getName(), scopes);
            return this.filterAttributesByScope(scopes, principal, service, oidcService, accessToken);
        }
        LOGGER.trace("Service definition [{}] invokes the assigned claims release policy without using scopes", (Object)oidcService.getName());
        RegisteredServiceAttributeReleasePolicyContext releasePolicyContext = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)oidcService).service(service).principal(principal).applicationContext((ApplicationContext)this.applicationContext).attributeReleasePolicyPredicate(policy -> !(policy instanceof OidcRegisteredServiceAttributeReleasePolicy) || scopes.contains(((OidcRegisteredServiceAttributeReleasePolicy)policy).getScopeType())).build();
        return oidcService.getAttributeReleasePolicy().getAttributes(releasePolicyContext);
    }

    @Generated
    public OidcProfileScopeToAttributesFilter(PrincipalFactory principalFactory, CasConfigurationProperties casProperties, OidcAttributeReleasePolicyFactory oidcAttributeReleasePolicyFactory, ConfigurableApplicationContext applicationContext) {
        this.principalFactory = principalFactory;
        this.casProperties = casProperties;
        this.oidcAttributeReleasePolicyFactory = oidcAttributeReleasePolicyFactory;
        this.applicationContext = applicationContext;
    }
}

