/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks.rotation;

import java.util.Arrays;
import lombok.Generated;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;

public interface OidcJsonWebKeystoreRotationService {
    public static final String PARAMETER_STATE = "state";

    public JsonWebKeySet rotate() throws Throwable;

    public JsonWebKeySet revoke() throws Throwable;

    public static enum JsonWebKeyLifecycleStates {
        CURRENT(0L),
        FUTURE(1L),
        PREVIOUS(2L);

        private final long state;

        public static JsonWebKeyLifecycleStates getJsonWebKeyState(JsonWebKey key) {
            Long state = (Long)key.getOtherParameterValue(OidcJsonWebKeystoreRotationService.PARAMETER_STATE, Long.class);
            return Arrays.stream(JsonWebKeyLifecycleStates.values()).filter(s -> state != null && s.getState() == state.longValue()).findFirst().orElse(CURRENT);
        }

        public static void setJsonWebKeyState(JsonWebKey key, JsonWebKeyLifecycleStates state) {
            key.setOtherParameter(OidcJsonWebKeystoreRotationService.PARAMETER_STATE, (Object)state.getState());
        }

        public boolean isCurrent() {
            return this.getState() == CURRENT.getState();
        }

        public boolean isPrevious() {
            return this.getState() == PREVIOUS.getState();
        }

        public boolean isFuture() {
            return this.getState() == FUTURE.getState();
        }

        @Generated
        private JsonWebKeyLifecycleStates(long state) {
            this.state = state;
        }

        @Generated
        public long getState() {
            return this.state;
        }
    }
}

