/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks.rotation;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyUsage;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.rotation.OidcJsonWebKeystoreRotationService;
import org.apereo.cas.util.function.FunctionUtils;
import org.jooq.lambda.Unchecked;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class OidcDefaultJsonWebKeystoreRotationService
implements OidcJsonWebKeystoreRotationService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcDefaultJsonWebKeystoreRotationService.class);
    private final OidcProperties oidcProperties;
    private final OidcJsonWebKeystoreGeneratorService generatorService;

    @Override
    public JsonWebKeySet rotate() throws Throwable {
        return this.whenKeystoreResourceExists().map(Unchecked.function(resource -> {
            LOGGER.trace("Rotating keys found in [{}]", resource);
            String jwksJson = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
            JsonWebKeySet jsonWebKeySet = new JsonWebKeySet(jwksJson);
            jsonWebKeySet.getJsonWebKeys().forEach(key -> {
                LOGGER.debug("Processing key [{}] to determine rotation eligibility", (Object)key.getKeyId());
                OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates state = OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.getJsonWebKeyState(key);
                if (state == OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.CURRENT) {
                    OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.setJsonWebKeyState(key, OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.PREVIOUS);
                    LOGGER.trace("Rotating state for current key [{}] to previous", (Object)key.getKeyId());
                }
                if (state == OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.FUTURE) {
                    OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.setJsonWebKeyState(key, OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.CURRENT);
                    LOGGER.trace("Rotating state for future key [{}] to current", (Object)key.getKeyId());
                }
            });
            this.generateFutureKeys(jsonWebKeySet);
            this.generateCurrentKeys(jsonWebKeySet);
            return this.generatorService.store(jsonWebKeySet);
        })).orElse(null);
    }

    private void generateCurrentKeys(JsonWebKeySet jsonWebKeySet) {
        boolean foundCurrent = jsonWebKeySet.getJsonWebKeys().stream().anyMatch(key -> OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.getJsonWebKeyState(key).isCurrent());
        if (!foundCurrent) {
            JsonWebKey currentKeySigning = OidcJsonWebKeystoreGeneratorService.generateJsonWebKey(this.oidcProperties, OidcJsonWebKeyUsage.SIGNING);
            OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.setJsonWebKeyState(currentKeySigning, OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.CURRENT);
            LOGGER.trace("Generated current signing key with id [{}]", (Object)currentKeySigning.getKeyId());
            jsonWebKeySet.addJsonWebKey(currentKeySigning);
            JsonWebKey currentKeyEncryption = OidcJsonWebKeystoreGeneratorService.generateJsonWebKey(this.oidcProperties, OidcJsonWebKeyUsage.ENCRYPTION);
            OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.setJsonWebKeyState(currentKeyEncryption, OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.CURRENT);
            LOGGER.trace("Generated current encryption key with id [{}]", (Object)currentKeyEncryption.getKeyId());
            jsonWebKeySet.addJsonWebKey(currentKeyEncryption);
        }
    }

    private void generateFutureKeys(JsonWebKeySet jsonWebKeySet) {
        JsonWebKey futureKeySigning = OidcJsonWebKeystoreGeneratorService.generateJsonWebKey(this.oidcProperties, OidcJsonWebKeyUsage.SIGNING);
        OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.setJsonWebKeyState(futureKeySigning, OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.FUTURE);
        LOGGER.trace("Generated future signing key with id [{}]", (Object)futureKeySigning.getKeyId());
        jsonWebKeySet.addJsonWebKey(futureKeySigning);
        JsonWebKey futureKeyEncryption = OidcJsonWebKeystoreGeneratorService.generateJsonWebKey(this.oidcProperties, OidcJsonWebKeyUsage.ENCRYPTION);
        OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.setJsonWebKeyState(futureKeyEncryption, OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.FUTURE);
        LOGGER.trace("Generated future encryption key with id [{}]", (Object)futureKeyEncryption.getKeyId());
        jsonWebKeySet.addJsonWebKey(futureKeyEncryption);
    }

    @Override
    public JsonWebKeySet revoke() {
        return this.whenKeystoreResourceExists().map(Unchecked.function(resource -> {
            LOGGER.trace("Revoking previous keys found in [{}]", resource);
            String jwksJson = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
            JsonWebKeySet jsonWebKeySet = new JsonWebKeySet(jwksJson);
            jsonWebKeySet.getJsonWebKeys().removeIf(key -> {
                LOGGER.debug("Processing key [{}] to determine revocation eligibility", (Object)key.getKeyId());
                OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates state = OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.getJsonWebKeyState(key);
                return state == OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.PREVIOUS;
            });
            return this.generatorService.store(jsonWebKeySet);
        })).orElse(null);
    }

    private Optional<Resource> whenKeystoreResourceExists() {
        return (Optional)FunctionUtils.doUnchecked(this.generatorService::find);
    }

    @Generated
    public OidcDefaultJsonWebKeystoreRotationService(OidcProperties oidcProperties, OidcJsonWebKeystoreGeneratorService generatorService) {
        this.oidcProperties = oidcProperties;
        this.generatorService = generatorService;
    }
}

