/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.transport.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.channel.CoalescingBufferQueue;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.util.ReferenceCountUtil;
import java.net.SocketAddress;
import java.util.List;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslHandler
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    private final Logger logger = LoggerFactory.getLogger(SaslHandler.class);
    private final SaslClient saslClient;
    private CoalescingBufferQueue queue;

    public SaslHandler(SaslClient sc) {
        this.saslClient = sc;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.queue = new CoalescingBufferQueue(ctx.channel());
    }

    public void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        this.dispose();
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        this.logger.trace("decoding {} bytes from {} on {}", new Object[]{in.readableBytes(), in, ctx});
        if (in.readableBytes() <= 4) {
            return;
        }
        int readerIdx = in.readerIndex();
        int writerIdx = in.writerIndex();
        int len = in.readInt();
        if (in.readableBytes() < len) {
            in.setIndex(readerIdx, writerIdx);
            this.logger.trace("could not read enough bytes from {} to decode message on {}", (Object)in, (Object)ctx);
            return;
        }
        byte[] wrappedBytes = new byte[len];
        in.readBytes(wrappedBytes);
        byte[] unwrapped = this.saslClient.unwrap(wrappedBytes, 0, wrappedBytes.length);
        ctx.fireChannelRead((Object)Unpooled.wrappedBuffer((byte[])unwrapped));
        this.logger.trace("fired channel read for unwrapped message of length {}", (Object)unwrapped.length);
    }

    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.bind(localAddress, promise);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.connect(remoteAddress, localAddress, promise);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.dispose();
        ctx.close(promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.dispose();
        ctx.close(promise);
    }

    private void dispose() {
        this.logger.trace("disposing {} for client {} with queue {}", new Object[]{this, this.saslClient, this.queue});
        try {
            this.saslClient.dispose();
        }
        catch (SaslException e) {
            this.logger.warn("Error disposing of SASL client", (Throwable)e);
        }
        if (this.queue != null && !this.queue.isEmpty()) {
            this.queue.releaseAndFailAll((Throwable)new ChannelException("SASL client closed"));
        }
        this.queue = null;
    }

    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.deregister(promise);
    }

    public void read(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        this.logger.trace("write {} message of {} with queue {}", new Object[]{ctx, msg, this.queue});
        if (!(msg instanceof ByteBuf)) {
            UnsupportedMessageTypeException exception = new UnsupportedMessageTypeException(msg, new Class[]{ByteBuf.class});
            ReferenceCountUtil.safeRelease((Object)msg);
            promise.setFailure((Throwable)exception);
        } else if (this.queue == null) {
            ReferenceCountUtil.safeRelease((Object)msg);
            promise.setFailure((Throwable)new IllegalStateException("Queue is null, handler has been removed"));
        } else {
            this.queue.add((ByteBuf)msg, promise);
            this.logger.trace("added message {} to queue {}", msg, (Object)this.queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void flush(ChannelHandlerContext ctx) throws Exception {
        this.logger.trace("flushing {} with queue {}", (Object)ctx, (Object)this.queue);
        if (ctx.isRemoved() || this.queue.isEmpty()) {
            return;
        }
        ByteBuf buf = null;
        try {
            ChannelPromise promise = ctx.newPromise();
            int readableBytes = this.queue.readableBytes();
            buf = this.queue.remove(readableBytes, promise);
            byte[] bytes = new byte[readableBytes];
            buf.readBytes(bytes);
            byte[] wrappedBytes = this.saslClient.wrap(bytes, 0, bytes.length);
            ByteBuf wrappedBuf = Unpooled.buffer((int)(wrappedBytes.length + 4));
            wrappedBuf.writeInt(wrappedBytes.length).writeBytes(wrappedBytes);
            ctx.writeAndFlush((Object)wrappedBuf, promise);
            this.logger.trace("write and flush of {} for wrapped message of length {}", (Object)ctx, (Object)wrappedBytes.length);
            if (buf == null) return;
        }
        catch (Throwable throwable) {
            if (buf == null) throw throwable;
            ReferenceCountUtil.safeRelease(buf);
            throw throwable;
        }
        ReferenceCountUtil.safeRelease((Object)buf);
    }
}

