/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.pool;

import java.time.Duration;
import java.time.Instant;
import org.ldaptive.pool.AbstractPruneStrategy;
import org.ldaptive.pool.PooledConnectionProxy;

public class IdlePruneStrategy
extends AbstractPruneStrategy {
    private static final int DEFAULT_STATISTICS_SIZE = 1;
    private static final Duration DEFAULT_IDLE_TIME = Duration.ofMinutes(10L);
    private Duration idleTime;

    public IdlePruneStrategy() {
        this(DEFAULT_PRUNE_PERIOD, DEFAULT_IDLE_TIME);
    }

    public IdlePruneStrategy(Duration idle) {
        this.setPrunePeriod(idle.dividedBy(2L));
        this.setIdleTime(idle);
    }

    public IdlePruneStrategy(Duration period, Duration idle) {
        this.setPrunePeriod(period);
        this.setIdleTime(idle);
    }

    @Override
    public Boolean apply(PooledConnectionProxy conn) {
        Instant timeAvailable = conn.getPooledConnectionStatistics().getLastAvailableStat();
        this.logger.trace("evaluating timestamp {} for connection {}", (Object)timeAvailable, (Object)conn);
        return timeAvailable == null || timeAvailable.plus(this.idleTime).isBefore(Instant.now());
    }

    @Override
    public int getStatisticsSize() {
        return 1;
    }

    public Duration getIdleTime() {
        return this.idleTime;
    }

    public void setIdleTime(Duration time) {
        if (time == null || time.isNegative()) {
            throw new IllegalArgumentException("Idle time cannot be null or negative");
        }
        this.idleTime = time;
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::prunePeriod=" + this.getPrunePeriod() + ", idleTime=" + this.idleTime + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractPruneStrategy.AbstractBuilder<Builder, IdlePruneStrategy> {
        protected Builder() {
            super(new IdlePruneStrategy());
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder idle(Duration time) {
            ((IdlePruneStrategy)this.object).setIdleTime(time);
            return this.self();
        }
    }
}

