/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ldaptive.LdapUtils;
import org.ldaptive.asn1.ConstructedDEREncoder;
import org.ldaptive.asn1.ContextDERTag;
import org.ldaptive.asn1.DEREncoder;
import org.ldaptive.asn1.NullType;
import org.ldaptive.filter.Filter;
import org.ldaptive.filter.FilterSet;

public class OrFilter
implements FilterSet {
    private static final int HASH_CODE_SEED = 10091;
    private final List<Filter> filterComponents = new ArrayList<Filter>();

    public OrFilter() {
    }

    public OrFilter(Filter ... components) {
        this.filterComponents.addAll(Arrays.asList(components));
    }

    @Override
    public Filter.Type getType() {
        return Filter.Type.OR;
    }

    @Override
    public void add(Filter component) {
        this.filterComponents.add(component);
    }

    public List<Filter> getComponents() {
        return Collections.unmodifiableList(this.filterComponents);
    }

    @Override
    public DEREncoder getEncoder() {
        if (this.filterComponents.size() == 0) {
            return new NullType(new ContextDERTag(Filter.Type.OR.ordinal(), true));
        }
        return new ConstructedDEREncoder(new ContextDERTag(Filter.Type.OR.ordinal(), true), (DEREncoder[])this.filterComponents.stream().map(Filter::getEncoder).toArray(DEREncoder[]::new));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OrFilter) {
            OrFilter v = (OrFilter)o;
            return LdapUtils.areEqual(this.filterComponents, v.filterComponents);
        }
        return false;
    }

    public int hashCode() {
        return LdapUtils.computeHashCode(10091, this.filterComponents);
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + "::filterComponents=" + this.filterComponents;
    }
}

