/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import org.ldaptive.ConnectionFactory;
import org.ldaptive.ConnectionFactoryManager;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.handler.ExceptionHandler;
import org.ldaptive.handler.IntermediateResponseHandler;
import org.ldaptive.handler.LdapEntryHandler;
import org.ldaptive.handler.ReferralHandler;
import org.ldaptive.handler.RequestHandler;
import org.ldaptive.handler.ResponseControlHandler;
import org.ldaptive.handler.ResultHandler;
import org.ldaptive.handler.ResultPredicate;
import org.ldaptive.handler.SearchReferenceHandler;
import org.ldaptive.handler.SearchResultHandler;
import org.ldaptive.handler.UnsolicitedNotificationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSearchOperationFactory
implements ConnectionFactoryManager {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConnectionFactory factory;
    private RequestHandler<SearchRequest>[] requestHandlers;
    private ResultHandler[] resultHandlers;
    private ResponseControlHandler[] controlHandlers;
    private ReferralHandler[] referralHandlers;
    private IntermediateResponseHandler[] intermediateResponseHandlers;
    private ExceptionHandler exceptionHandler;
    private ResultPredicate throwCondition;
    private UnsolicitedNotificationHandler[] unsolicitedNotificationHandlers;
    private LdapEntryHandler[] entryHandlers;
    private SearchReferenceHandler[] referenceHandlers;
    private SearchResultHandler[] searchResultHandlers;

    @Override
    public ConnectionFactory getConnectionFactory() {
        return this.factory;
    }

    @Override
    public void setConnectionFactory(ConnectionFactory cf) {
        this.factory = cf;
    }

    public RequestHandler<SearchRequest>[] getRequestHandlers() {
        return this.requestHandlers;
    }

    public void setRequestHandlers(RequestHandler<SearchRequest> ... handlers) {
        this.requestHandlers = handlers;
    }

    public ResultHandler[] getResultHandlers() {
        return this.resultHandlers;
    }

    public void setResultHandlers(ResultHandler ... handlers) {
        this.resultHandlers = handlers;
    }

    public ResponseControlHandler[] getControlHandlers() {
        return this.controlHandlers;
    }

    public void setControlHandlers(ResponseControlHandler ... handlers) {
        this.controlHandlers = handlers;
    }

    public ReferralHandler[] getReferralHandlers() {
        return this.referralHandlers;
    }

    public void setReferralHandlers(ReferralHandler ... handlers) {
        this.referralHandlers = handlers;
    }

    public IntermediateResponseHandler[] getIntermediateResponseHandlers() {
        return this.intermediateResponseHandlers;
    }

    public void setIntermediateResponseHandlers(IntermediateResponseHandler ... handlers) {
        this.intermediateResponseHandlers = handlers;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler handler) {
        this.exceptionHandler = handler;
    }

    public ResultPredicate getThrowCondition() {
        return this.throwCondition;
    }

    public void setThrowCondition(ResultPredicate function) {
        this.throwCondition = function;
    }

    public UnsolicitedNotificationHandler[] getUnsolicitedNotificationHandlers() {
        return this.unsolicitedNotificationHandlers;
    }

    public void setUnsolicitedNotificationHandlers(UnsolicitedNotificationHandler ... handlers) {
        this.unsolicitedNotificationHandlers = handlers;
    }

    public LdapEntryHandler[] getEntryHandlers() {
        return this.entryHandlers;
    }

    public void setEntryHandlers(LdapEntryHandler ... handlers) {
        this.entryHandlers = handlers;
    }

    public SearchReferenceHandler[] getReferenceHandlers() {
        return this.referenceHandlers;
    }

    public void setReferenceHandlers(SearchReferenceHandler ... handlers) {
        this.referenceHandlers = handlers;
    }

    public SearchResultHandler[] getSearchResultHandlers() {
        return this.searchResultHandlers;
    }

    public void setSearchResultHandlers(SearchResultHandler ... handlers) {
        this.searchResultHandlers = handlers;
    }

    protected SearchOperation createSearchOperation() {
        return this.createSearchOperation(this.factory);
    }

    protected SearchOperation createSearchOperation(ConnectionFactory cf) {
        SearchOperation op = new SearchOperation(cf);
        if (this.requestHandlers != null) {
            op.setRequestHandlers(this.requestHandlers);
        }
        if (this.resultHandlers != null) {
            op.setResultHandlers(this.resultHandlers);
        }
        if (this.controlHandlers != null) {
            op.setControlHandlers(this.controlHandlers);
        }
        if (this.referralHandlers != null) {
            op.setReferralHandlers(this.referralHandlers);
        }
        if (this.intermediateResponseHandlers != null) {
            op.setIntermediateResponseHandlers(this.intermediateResponseHandlers);
        }
        if (this.exceptionHandler != null) {
            op.setExceptionHandler(this.exceptionHandler);
        }
        if (this.throwCondition != null) {
            op.setThrowCondition(this.throwCondition);
        }
        if (this.unsolicitedNotificationHandlers != null) {
            op.setUnsolicitedNotificationHandlers(this.unsolicitedNotificationHandlers);
        }
        if (this.entryHandlers != null) {
            op.setEntryHandlers(this.entryHandlers);
        }
        if (this.referenceHandlers != null) {
            op.setReferenceHandlers(this.referenceHandlers);
        }
        if (this.searchResultHandlers != null) {
            op.setSearchResultHandlers(this.searchResultHandlers);
        }
        return op;
    }
}

