/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.script;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.script.ScriptExecutor;

public abstract class ScriptExecutorFactory {
    private static Map<String, Class<?>> factoryCache;

    private static synchronized Map<String, Class<?>> getFactoryCache() {
        if (factoryCache == null) {
            factoryCache = CollectionUtil.newCaseInsensitiveMap();
            List<String> factories = ScriptExecutorFactory.getRegisteredFactories();
            factories.forEach(factory -> {
                try {
                    Class<?> clazz = Class.forName(factory);
                    ScriptExecutorFactory instance = (ScriptExecutorFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    String language = instance.getLanguageName();
                    if (!factoryCache.containsKey(language)) {
                        factoryCache.put(language, clazz);
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        return factoryCache;
    }

    private static List<String> getRegisteredFactories() {
        ArrayList<String> result = new ArrayList<String>();
        String path = "META-INF/services/" + ScriptExecutorFactory.class.getName();
        try {
            Enumeration<URL> configFiles = ScriptExecutorFactory.class.getClassLoader().getResources(path);
            while (configFiles.hasMoreElements()) {
                URL configFile = configFiles.nextElement();
                ScriptExecutorFactory.addFactories(configFile, result);
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void addFactories(URL configFile, List<String> result) throws IOException {
        try (InputStream input = configFile.openStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            String line = reader.readLine();
            while (line != null) {
                int comment = line.indexOf(35);
                if (comment >= 0) {
                    line = line.substring(0, comment);
                }
                if (StringUtil.isNotBlank(line = line.trim())) {
                    result.add(line);
                }
                line = reader.readLine();
            }
        }
    }

    public static Set<String> getSupportedLanguages() {
        return Collections.unmodifiableSet(ScriptExecutorFactory.getFactoryCache().keySet());
    }

    public static ScriptExecutorFactory newInstance(String language) {
        if (StringUtil.isBlank(language)) {
            throw new IllegalArgumentException("Language must be specified");
        }
        Class<?> clazz = ScriptExecutorFactory.getFactoryCache().get(language);
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Language not supported: %s", language));
        }
        try {
            return (ScriptExecutorFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public abstract ScriptExecutor newScriptExecutor(ClassLoader var1, String var2, boolean var3);

    public abstract String getLanguageName();
}

