/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import java.util.Objects;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.authentication.principal.attribute.PersonAttributes;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.persondir.cache.CachingPersonAttributeDaoImpl;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@Endpoint(id="personDirectory", enableByDefault=false)
public class CasPersonDirectoryEndpoint
extends BaseCasRestActuatorEndpoint {
    private final ObjectProvider<PersonAttributeDao> cachingAttributeRepository;

    public CasPersonDirectoryEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, ObjectProvider<PersonAttributeDao> cachingAttributeRepository) {
        super(casProperties, applicationContext);
        this.cachingAttributeRepository = cachingAttributeRepository;
    }

    @GetMapping(value={"/cache/{username}"})
    @Operation(summary="Display cached attributes in the attribute repository for user. If attributes are found in the cache, they are returned. Otherwise, attribute repositories will be contacted to fetch and cache person attributes again", parameters={@Parameter(name="username", required=true, in=ParameterIn.PATH, description="The username to look up")})
    public PersonAttributes showCachedAttributesFor(@PathVariable(value="username") String username) {
        CachingPersonAttributeDaoImpl cachingRepository = this.getCachingPersonAttributeDao();
        return cachingRepository.getPerson(username);
    }

    @DeleteMapping(value={"/cache/{username}"})
    @Operation(summary="Remove cached attributes in the attribute repository for user", parameters={@Parameter(name="username", required=true, in=ParameterIn.PATH, description="The username to look up")})
    public void removeCachedAttributesFor(@PathVariable(value="username") String username) {
        CachingPersonAttributeDaoImpl cachingRepository = this.getCachingPersonAttributeDao();
        cachingRepository.removeUserAttributes(username);
    }

    private CachingPersonAttributeDaoImpl getCachingPersonAttributeDao() {
        CachingPersonAttributeDaoImpl cachingRepository = (CachingPersonAttributeDaoImpl)((Object)this.cachingAttributeRepository.getObject());
        Objects.requireNonNull(cachingRepository, "Unable to locate caching attribute repository from application context");
        return cachingRepository;
    }
}

