/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.persondir.cache;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDaoFilter;
import org.apereo.cas.persondir.cache.CacheKeyGenerator;
import org.apereo.cas.persondir.cache.HashCodeCacheKey;
import org.apereo.cas.persondir.cache.HashCodeCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class AttributeBasedCacheKeyGenerator
implements CacheKeyGenerator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AttributeBasedCacheKeyGenerator.class);
    private static final Map<String, Object> POSSIBLE_USER_ATTRIBUTE_NAMES_SEED_MAP = Map.of("getPossibleUserAttributeNames_seedMap", new Serializable(){
        private static final long serialVersionUID = 1L;
    });
    private static final Map<String, Object> AVAILABLE_QUERY_ATTRIBUTES_SEED_MAP = Map.of("getAvailableQueryAttributes_seedMap", new Serializable(){
        private static final long serialVersionUID = 1L;
    });
    private Set<String> cacheKeyAttributes;
    private String defaultAttributeName = "username";
    private boolean useAllAttributes;
    private boolean ignoreEmptyAttributes;

    @Override
    public Serializable generateKey(MethodInvocation methodInvocation) {
        CacheableMethod cacheableMethod = this.resolveCacheableMethod(methodInvocation);
        Object[] methodArguments = methodInvocation.getArguments();
        Map<String, Object> seed = this.getSeed(methodArguments, cacheableMethod);
        Integer keyHashCode = this.getKeyHash(seed);
        if (keyHashCode == null) {
            LOGGER.debug("No cache key generated for MethodInvocation=[{}]", (Object)methodInvocation);
            return null;
        }
        HashCodeCalculator hashCodeCalculator = new HashCodeCalculator();
        hashCodeCalculator.append(keyHashCode);
        long checkSum = hashCodeCalculator.getCheckSum();
        int hashCode = hashCodeCalculator.getHashCode();
        HashCodeCacheKey hashCodeCacheKey = new HashCodeCacheKey(checkSum, hashCode);
        LOGGER.debug("Generated cache key [{}] for method invocation [{}]", (Object)hashCodeCacheKey, (Object)methodInvocation);
        return cacheableMethod.getName() + "|" + String.valueOf(hashCodeCacheKey);
    }

    protected Map<String, Object> getSeed(Object[] methodArguments, CacheableMethod cacheableMethod) {
        return switch (cacheableMethod.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1, 2 -> (Map<String, String>)methodArguments[0];
            case 0 -> {
                String uid = (String)methodArguments[0];
                yield Map.of(this.defaultAttributeName, uid);
            }
            case 3 -> POSSIBLE_USER_ATTRIBUTE_NAMES_SEED_MAP;
            case 4 -> AVAILABLE_QUERY_ATTRIBUTES_SEED_MAP;
        };
    }

    protected Integer getKeyHash(Map<String, Object> seed) {
        Set<String> cacheAttributes = this.determineCacheAttributes(seed);
        HashMap<String, Object> cacheKey = new HashMap<String, Object>(cacheAttributes.size());
        for (String attr : cacheAttributes) {
            if (!seed.containsKey(attr)) continue;
            Object value = seed.get(attr);
            if (!this.ignoreEmptyAttributes) {
                AttributeBasedCacheKeyGenerator.putAttributeInCache(cacheKey, attr, value);
                continue;
            }
            if (value instanceof Collection) {
                Collection c = (Collection)value;
                if (CollectionUtils.isEmpty((Collection)c)) continue;
                AttributeBasedCacheKeyGenerator.putAttributeInCache(cacheKey, attr, value);
                continue;
            }
            if (value instanceof CharSequence) {
                CharSequence cs = (CharSequence)value;
                if (!StringUtils.isNotEmpty((CharSequence)cs)) continue;
                AttributeBasedCacheKeyGenerator.putAttributeInCache(cacheKey, attr, value);
                continue;
            }
            if (value == null) continue;
            AttributeBasedCacheKeyGenerator.putAttributeInCache(cacheKey, attr, value);
        }
        LOGGER.debug("Generated cache Map [{}] from seed Map [{}]", cacheKey, seed);
        if (cacheKey.isEmpty()) {
            return null;
        }
        return cacheKey.hashCode();
    }

    private Set<String> determineCacheAttributes(Map<String, Object> seed) {
        if (this.useAllAttributes) {
            return seed.keySet();
        }
        if (this.cacheKeyAttributes != null) {
            return this.cacheKeyAttributes;
        }
        return Set.of(this.defaultAttributeName);
    }

    protected static void putAttributeInCache(Map<String, Object> cacheKey, String attr, Object value) {
        String hexed = new DigestUtils("SHA-512").digestAsHex(value.toString());
        cacheKey.put(hexed, value);
    }

    protected CacheableMethod resolveCacheableMethod(MethodInvocation methodInvocation) {
        Method targetMethod = methodInvocation.getMethod();
        Class<?> targetClass = targetMethod.getDeclaringClass();
        for (CacheableMethod method : CacheableMethod.values()) {
            Method cacheableMethod = null;
            try {
                cacheableMethod = targetClass.getMethod(method.getName(), method.getArgs());
            }
            catch (SecurityException e) {
                LOGGER.warn("Security exception while attempting to if the target class [{}] implements the cacheable method [{}]", new Object[]{targetClass, cacheableMethod, e});
            }
            catch (NoSuchMethodException e) {
                LOGGER.warn("Target class [{}] does not implement possible cacheable method [{}].", targetClass, (Object)cacheableMethod);
            }
            if (!targetMethod.equals(cacheableMethod)) continue;
            return method;
        }
        throw new IllegalArgumentException("Do not know how to generate a cache entry for " + String.valueOf(targetMethod) + " on class " + String.valueOf(targetClass));
    }

    @Generated
    public Set<String> getCacheKeyAttributes() {
        return this.cacheKeyAttributes;
    }

    @Generated
    public void setCacheKeyAttributes(Set<String> cacheKeyAttributes) {
        this.cacheKeyAttributes = cacheKeyAttributes;
    }

    @Generated
    public String getDefaultAttributeName() {
        return this.defaultAttributeName;
    }

    @Override
    @Generated
    public void setDefaultAttributeName(String defaultAttributeName) {
        this.defaultAttributeName = defaultAttributeName;
    }

    @Generated
    public boolean isUseAllAttributes() {
        return this.useAllAttributes;
    }

    @Generated
    public void setUseAllAttributes(boolean useAllAttributes) {
        this.useAllAttributes = useAllAttributes;
    }

    @Generated
    public boolean isIgnoreEmptyAttributes() {
        return this.ignoreEmptyAttributes;
    }

    @Generated
    public void setIgnoreEmptyAttributes(boolean ignoreEmptyAttributes) {
        this.ignoreEmptyAttributes = ignoreEmptyAttributes;
    }

    public static enum CacheableMethod {
        PERSON_STR("getPerson", new Class[]{String.class}),
        PEOPLE_MAP("getPeople", new Class[]{Map.class, PersonAttributeDaoFilter.class}),
        PEOPLE_MULTIVALUED_MAP("getPeopleWithMultivaluedAttributes", new Class[]{Map.class}),
        POSSIBLE_USER_ATTRIBUTE_NAMES("getPossibleUserAttributeNames", new Class[]{PersonAttributeDaoFilter.class}),
        AVAILABLE_QUERY_ATTRIBUTES("getAvailableQueryAttributes", new Class[]{PersonAttributeDaoFilter.class});

        private final String name;
        private final Class<?>[] args;

        @Generated
        private CacheableMethod(String name, Class<?>[] args) {
            this.name = name;
            this.args = args;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Class<?>[] getArgs() {
            return this.args;
        }
    }
}

