/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.persondir;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.persondir.MappablePersonAttributeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.Resource;

public class JsonPersonAttributeDao
extends MappablePersonAttributeDao
implements Closeable,
DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonPersonAttributeDao.class);
    private final Resource personAttributesConfigFile;
    private Closeable resourceWatcherService;
    private final ObjectMapper jacksonObjectMapper = new ObjectMapper().findAndRegisterModules();
    private final Object synchronizationMonitor = new Object();

    public void init() throws IOException {
        this.unmarshalAndSetBackingMap();
    }

    @Override
    public void close() throws IOException {
        if (this.resourceWatcherService != null) {
            this.resourceWatcherService.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unmarshalAndSetBackingMap() throws IOException {
        LOGGER.info("Un-marshaling person attributes from the config file [{}]", (Object)this.personAttributesConfigFile);
        Map backingMap = (Map)this.jacksonObjectMapper.readValue(this.personAttributesConfigFile.getInputStream(), Map.class);
        LOGGER.debug("Person attributes have been successfully read into the map ");
        Object object = this.synchronizationMonitor;
        synchronized (object) {
            this.setBackingMap(backingMap);
        }
    }

    public void destroy() throws Exception {
        this.close();
    }

    @Generated
    public JsonPersonAttributeDao(Resource personAttributesConfigFile) {
        this.personAttributesConfigFile = personAttributesConfigFile;
    }

    @Generated
    public void setResourceWatcherService(Closeable resourceWatcherService) {
        this.resourceWatcherService = resourceWatcherService;
    }
}

