/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.persondir;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryCustomizer;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlan;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.Ordered;

public class DefaultPersonDirectoryAttributeRepositoryPlan
implements PersonDirectoryAttributeRepositoryPlan,
DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPersonDirectoryAttributeRepositoryPlan.class);
    private final List<PersonAttributeDao> attributeRepositories = new ArrayList<PersonAttributeDao>(0);
    private final List<PersonDirectoryAttributeRepositoryCustomizer> attributeRepositoryCustomizers;

    @Override
    public void registerAttributeRepository(PersonAttributeDao repository) {
        if (BeanSupplier.isNotProxy((Object)repository)) {
            if (LOGGER.isTraceEnabled()) {
                String name = AopUtils.isAopProxy((Object)repository) ? AopUtils.getTargetClass((Object)repository).getSimpleName() : repository.getClass().getSimpleName();
                LOGGER.trace("Registering attribute repository [{}] into the person directory plan", (Object)name);
            }
            this.attributeRepositoryCustomizers.stream().sorted(Comparator.comparing(Ordered::getOrder)).filter(cust -> cust.supports(repository)).forEach(cust -> cust.customize(repository));
            this.attributeRepositories.add(repository);
        }
    }

    public void destroy() {
        LOGGER.trace("Closing attribute repositories, if any");
        this.findAttributeRepositories(AutoCloseable.class::isInstance).map(AutoCloseable.class::cast).forEach(Unchecked.consumer(AutoCloseable::close));
    }

    @Override
    @Generated
    public List<PersonAttributeDao> getAttributeRepositories() {
        return this.attributeRepositories;
    }

    @Generated
    public List<PersonDirectoryAttributeRepositoryCustomizer> getAttributeRepositoryCustomizers() {
        return this.attributeRepositoryCustomizers;
    }

    @Generated
    public DefaultPersonDirectoryAttributeRepositoryPlan(List<PersonDirectoryAttributeRepositoryCustomizer> attributeRepositoryCustomizers) {
        this.attributeRepositoryCustomizers = attributeRepositoryCustomizers;
    }
}

