/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.client.lib.WebClientBuilder;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ConnIdBundle;
import org.apache.syncope.common.lib.to.ConnIdObjectClass;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.syncope.common.rest.api.service.ConnectorService;
import org.apache.syncope.common.rest.api.service.JAXRSService;
import org.springframework.beans.BeanUtils;

public class ConnectorRestClient
extends BaseRestClient {
    private static final long serialVersionUID = -6870366819966266617L;

    protected static List<ConnConfProperty> filterBlank(List<ConnConfProperty> properties) {
        return properties.stream().filter(obj -> obj != null && !obj.toString().isBlank()).toList();
    }

    public List<ConnInstanceTO> getAllConnectors() {
        List connectors = List.of();
        try {
            connectors = ((ConnectorService)this.getService(ConnectorService.class)).list(SyncopeConsoleSession.get().getLocale().toString());
        }
        catch (Exception e) {
            LOG.error("While reading connectors", (Throwable)e);
        }
        return connectors;
    }

    public ConnInstanceTO create(ConnInstanceTO connectorTO) {
        List<ConnConfProperty> filteredConf = ConnectorRestClient.filterBlank(connectorTO.getConf());
        connectorTO.getConf().clear();
        connectorTO.getConf().addAll(filteredConf);
        ConnectorService service = (ConnectorService)this.getService(ConnectorService.class);
        Response response = service.create(connectorTO);
        return (ConnInstanceTO)this.getObject((JAXRSService)service, response.getLocation(), ConnInstanceTO.class);
    }

    public List<String> getObjectClasses(String connectorKey) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            ConnectorService service = (ConnectorService)this.getService(ConnectorService.class);
            ConnInstanceTO connInstance = service.read(connectorKey, SyncopeConsoleSession.get().getLocale().getLanguage());
            if (connInstance != null) {
                result.addAll(service.buildObjectClassInfo(connInstance, true).stream().map(ConnIdObjectClass::getType).collect(Collectors.toList()));
            }
        }
        catch (Exception e) {
            LOG.error("While reading object classes for connector {}", (Object)connectorKey, (Object)e);
        }
        return result;
    }

    public List<String> getExtAttrNames(String adminRealm, String objectClass, String connectorKey, Optional<List<ConnConfProperty>> conf) {
        ConnInstanceTO connInstanceTO = new ConnInstanceTO();
        connInstanceTO.setAdminRealm(adminRealm);
        connInstanceTO.setKey(connectorKey);
        conf.ifPresent(c -> connInstanceTO.getConf().addAll(c));
        Optional<ConnIdObjectClass> connIdObjectClass = this.buildObjectClassInfo(connInstanceTO, false).stream().filter(object -> object.getType().equalsIgnoreCase(objectClass)).findAny();
        return connIdObjectClass.map(connIdObjectClassTO -> connIdObjectClassTO.getAttributes().stream().map(SchemaTO::getKey).collect(Collectors.toList())).orElseGet(List::of);
    }

    public ConnInstanceTO read(String key) {
        return ((ConnectorService)this.getService(ConnectorService.class)).read(key, SyncopeConsoleSession.get().getLocale().toString());
    }

    public void update(ConnInstanceTO connectorTO) {
        List<ConnConfProperty> filteredConf = ConnectorRestClient.filterBlank(connectorTO.getConf());
        connectorTO.getConf().clear();
        connectorTO.getConf().addAll(filteredConf);
        ((ConnectorService)this.getService(ConnectorService.class)).update(connectorTO);
    }

    public ConnInstanceTO delete(String key) {
        ConnInstanceTO connectorTO = ((ConnectorService)this.getService(ConnectorService.class)).read(key, SyncopeConsoleSession.get().getLocale().toString());
        ((ConnectorService)this.getService(ConnectorService.class)).delete(key);
        return connectorTO;
    }

    public List<ConnIdBundle> getAllBundles() {
        List bundles = List.of();
        try {
            bundles = ((ConnectorService)this.getService(ConnectorService.class)).getBundles(SyncopeConsoleSession.get().getLocale().toString());
        }
        catch (SyncopeClientException e) {
            LOG.error("While getting connector bundles", (Throwable)e);
        }
        return bundles;
    }

    public boolean check(String coreAddress, String domain, String jwt, String key) throws IOException {
        WebClient client = WebClientBuilder.build((String)coreAddress).path((Object)"connectors").accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(MediaType.APPLICATION_JSON_TYPE).header("X-Syncope-Domain", new Object[]{domain}).authorization((Object)("Bearer " + jwt));
        Response response = client.path((Object)key).get();
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            response = client.back(false).path((Object)"check").post((Object)IOUtils.toString((InputStream)((InputStream)response.getEntity()), (Charset)StandardCharsets.UTF_8));
            return response.getStatus() == Response.Status.NO_CONTENT.getStatusCode();
        }
        return false;
    }

    public Pair<Boolean, String> check(ConnInstanceTO connectorTO) {
        ConnInstanceTO toBeChecked = new ConnInstanceTO();
        BeanUtils.copyProperties((Object)connectorTO, (Object)toBeChecked);
        toBeChecked.getConf().addAll(ConnectorRestClient.filterBlank(connectorTO.getConf()));
        boolean check = false;
        String errorMessage = null;
        try {
            ((ConnectorService)this.getService(ConnectorService.class)).check(toBeChecked);
            check = true;
        }
        catch (Exception e) {
            LOG.error("While checking {}", (Object)toBeChecked, (Object)e);
            errorMessage = e.getMessage();
        }
        return Pair.of((Object)check, (Object)errorMessage);
    }

    public List<ConnIdObjectClass> buildObjectClassInfo(ConnInstanceTO connInstanceTO, boolean includeSpecial) {
        List result = List.of();
        try {
            result = ((ConnectorService)this.getService(ConnectorService.class)).buildObjectClassInfo(connInstanceTO, includeSpecial);
        }
        catch (Exception e) {
            LOG.error("While getting supported object classes", (Throwable)e);
        }
        return result;
    }

    public void reload() {
        ((ConnectorService)this.getService(ConnectorService.class)).reload();
    }
}

