/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.attribute;

import java.sql.Array;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apereo.cas.authentication.attribute.CaseCanonicalizationMode;
import org.apereo.cas.authentication.principal.attribute.PersonAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePersonAttributes
implements PersonAttributes {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SimplePersonAttributes.class);
    private static final long serialVersionUID = 2576711533477055700L;
    private final Map<String, List<Object>> attributes;
    private final String name;

    public SimplePersonAttributes(String name, Map<String, List<Object>> attributes) {
        this.attributes = this.buildImmutableAttributeMap(attributes);
        this.name = name;
    }

    public SimplePersonAttributes(Map<String, List<Object>> attributes) {
        this.attributes = this.buildImmutableAttributeMap(attributes);
        this.name = attributes.containsKey("username") ? attributes.get("username").getFirst().toString() : UUID.randomUUID().toString();
    }

    public SimplePersonAttributes() {
        this(Map.of());
    }

    public SimplePersonAttributes(String name) {
        this(name, Map.of());
    }

    public static SimplePersonAttributes fromAttribute(String attribute, Map<String, List<Object>> attributes) {
        if (attributes.containsKey(attribute)) {
            return new SimplePersonAttributes(attributes.get(attribute).getFirst().toString(), attributes);
        }
        return new SimplePersonAttributes(attributes);
    }

    public SimplePersonAttributes canonicalize(CaseCanonicalizationMode mode) {
        String newName = mode.canonicalize(this.getName());
        return new SimplePersonAttributes(newName, this.getAttributes());
    }

    protected Map<String, List<Object>> buildImmutableAttributeMap(Map<String, List<Object>> attributes) {
        TreeMap<String, List<Object>> valueBuilder = new TreeMap<String, List<Object>>(String.CASE_INSENSITIVE_ORDER);
        Pattern arrayPattern = Pattern.compile("\\{(.*)\\}");
        for (Map.Entry<String, List<Object>> attrEntry : attributes.entrySet()) {
            Object result;
            String key = attrEntry.getKey();
            List<Object> value = attrEntry.getValue().stream().filter(Objects::nonNull).toList();
            if (!value.isEmpty() && (result = value.getFirst()) instanceof Array) {
                LOGGER.trace("Column [{}] is classified as a SQL array", (Object)key);
                String values = result.toString();
                LOGGER.trace("Converting SQL array values [{}] using pattern [{}]", (Object)values, (Object)arrayPattern.pattern());
                Matcher matcher = arrayPattern.matcher(values);
                if (matcher.matches()) {
                    String[] groups = matcher.group(1).split(",");
                    value = List.of((Object[])groups);
                    LOGGER.trace("Converted SQL array values [{}]", (Object)values);
                }
            }
            LOGGER.trace("Collecting attribute [{}] with value(s) [{}]", (Object)key, value);
            valueBuilder.put(key, value);
        }
        return valueBuilder;
    }

    public Object getAttributeValue(String name) {
        List<Object> values = this.attributes.get(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.getFirst();
    }

    public List<Object> getAttributeValues(String name) {
        return this.attributes.get(name);
    }

    @Generated
    public Map<String, List<Object>> getAttributes() {
        return this.attributes;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimplePersonAttributes)) {
            return false;
        }
        SimplePersonAttributes other = (SimplePersonAttributes)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SimplePersonAttributes;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SimplePersonAttributes(attributes=" + String.valueOf(this.attributes) + ", name=" + this.name + ")";
    }
}

