/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.attribute;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.authentication.principal.attribute.PersonAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;

public abstract class BasePersonAttributeDao
implements PersonAttributeDao {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BasePersonAttributeDao.class);
    private int order;
    private String[] id = new String[]{this.getClass().getSimpleName()};
    private boolean enabled = true;
    private Map<String, Object> tags = new LinkedCaseInsensitiveMap();

    public int compareTo(PersonAttributeDao o) {
        return Integer.compare(this.order, o.getOrder());
    }

    public void setId(String ... id) {
        this.id = id;
    }

    public BasePersonAttributeDao putTag(String name, Object value) {
        this.tags.put(name, value);
        return this;
    }

    protected PersonAttributes getSinglePerson(Set<PersonAttributes> people) {
        try {
            return (PersonAttributes)DataAccessUtils.singleResult(people);
        }
        catch (IncorrectResultSizeDataAccessException e) {
            LOGGER.warn("Unexpected multiple people returned from person attribute DAO: [{}] : [{}]", (Object)((Object)((Object)e)).getClass().getName(), (Object)e.getMessage());
            people.forEach(p -> LOGGER.debug("Person: [{}]", p));
            throw e;
        }
    }

    protected Map<String, List<Object>> toMultivaluedMap(Map<String, Object> seed) {
        LinkedCaseInsensitiveMap multiSeed = new LinkedCaseInsensitiveMap(seed.size());
        for (Map.Entry<String, Object> seedEntry : seed.entrySet()) {
            String seedName = seedEntry.getKey();
            Object seedValue = seedEntry.getValue();
            if (seedValue instanceof List) {
                multiSeed.put(seedName, (Object)((List)seedValue));
                continue;
            }
            multiSeed.put(seedName, Collections.singletonList(seedValue));
        }
        return multiSeed;
    }

    public static Map<String, Set<String>> parseAttributeToAttributeMapping(Map<String, ? extends Object> mapping) {
        LinkedCaseInsensitiveMap mappedAttributesBuilder = new LinkedCaseInsensitiveMap();
        block5: for (Map.Entry<String, ? extends Object> mappingEntry : mapping.entrySet()) {
            Object mappedAttribute;
            String sourceAttrName = mappingEntry.getKey();
            Object object = mappedAttribute = mappingEntry.getValue();
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Collection.class}, (Object)object, n)) {
                case -1: {
                    mappedAttributesBuilder.put(sourceAttrName, null);
                    continue block5;
                }
                case 0: {
                    String value = (String)object;
                    HashSet<String> mappedSet = new HashSet<String>();
                    mappedSet.add(mappedAttribute.toString());
                    mappedAttributesBuilder.put(sourceAttrName, mappedSet);
                    continue block5;
                }
                case 1: {
                    Collection sourceSet = (Collection)object;
                    LinkedHashSet<String> mappedSet = new LinkedHashSet<String>();
                    for (Object sourceObj : sourceSet) {
                        if (sourceObj != null) {
                            mappedSet.add(sourceObj.toString());
                            continue;
                        }
                        mappedSet.add(null);
                    }
                    mappedAttributesBuilder.put(sourceAttrName, mappedSet);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Invalid mapped type. key=" + sourceAttrName + ", value type=" + mappedAttribute.getClass().getName());
        }
        return new HashMap<String, Set<String>>((Map<String, Set<String>>)mappedAttributesBuilder);
    }

    protected <T> Collection<T> flattenCollection(Collection<? extends Object> source) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object object : source) {
            if (object instanceof Collection) {
                Collection<T> flatCollection = this.flattenCollection((Collection)object);
                result.addAll(flatCollection);
                continue;
            }
            result.add(object);
        }
        return result;
    }

    protected Pattern compilePattern(String queryString) {
        String quotedQueryPart;
        String queryPart;
        StringBuilder queryBuilder = new StringBuilder();
        Matcher queryMatcher = PersonAttributeDao.WILDCARD_PATTERN.matcher(queryString);
        if (!queryMatcher.find()) {
            return Pattern.compile(Pattern.quote(queryString));
        }
        int start = queryMatcher.start();
        int previousEnd = -1;
        if (start > 0) {
            queryPart = queryString.substring(0, start);
            quotedQueryPart = Pattern.quote(queryPart);
            queryBuilder.append(quotedQueryPart);
        }
        queryBuilder.append(".*");
        do {
            start = queryMatcher.start();
            if (previousEnd != -1) {
                queryPart = queryString.substring(previousEnd, start);
                quotedQueryPart = Pattern.quote(queryPart);
                queryBuilder.append(quotedQueryPart);
                queryBuilder.append(".*");
            }
            previousEnd = queryMatcher.end();
        } while (queryMatcher.find());
        if (previousEnd < queryString.length()) {
            queryPart = queryString.substring(previousEnd);
            quotedQueryPart = Pattern.quote(queryPart);
            queryBuilder.append(quotedQueryPart);
        }
        return Pattern.compile(queryBuilder.toString());
    }

    @Generated
    public String toString() {
        return "BasePersonAttributeDao(order=" + this.order + ", id=" + Arrays.deepToString(this.id) + ", enabled=" + this.enabled + ", tags=" + String.valueOf(this.tags) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasePersonAttributeDao)) {
            return false;
        }
        BasePersonAttributeDao other = (BasePersonAttributeDao)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.order != other.order) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (!Arrays.deepEquals(this.id, other.id)) {
            return false;
        }
        Map<String, Object> this$tags = this.tags;
        Map<String, Object> other$tags = other.tags;
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BasePersonAttributeDao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.order;
        result = result * 59 + (this.enabled ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.id);
        Map<String, Object> $tags = this.tags;
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public String[] getId() {
        return this.id;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public Map<String, Object> getTags() {
        return this.tags;
    }

    @Generated
    public void setTags(Map<String, Object> tags) {
        this.tags = tags;
    }
}

