/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Objects;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.MultifactorAuthenticationContextValidator;
import org.apereo.cas.authentication.MultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.MultifactorAuthenticationTriggerSelectionStrategy;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.consent.ConsentActivationStrategy;
import org.apereo.cas.consent.ConsentableAttributeBuilder;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.web.consent.SamlIdPConsentSingleSignOnParticipationStrategy;
import org.apereo.cas.support.saml.web.consent.SamlIdPConsentableAttributeBuilder;
import org.apereo.cas.support.saml.web.flow.SamlIdPMetadataUIAction;
import org.apereo.cas.support.saml.web.flow.SamlIdPWebflowConfigurer;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.apereo.cas.support.saml.web.idp.web.SamlIdPMultifactorAuthenticationTrigger;
import org.apereo.cas.support.saml.web.idp.web.SamlIdPSingleSignOnParticipationStrategy;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategyConfigurer;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.flow.resolver.impl.mfa.DefaultMultifactorAuthenticationProviderWebflowEventResolver;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.SAMLIdentityProvider})
@Configuration(value="SamlIdPWebflowConfiguration", proxyBeanMethods=false)
class SamlIdPWebflowConfiguration {
    SamlIdPWebflowConfiguration() {
    }

    @Configuration(value="SamlIdPConsentSingleSignOnWebflowConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnBean(name={"consentEngine"})
    static class SamlIdPConsentSingleSignOnWebflowConfiguration {
        SamlIdPConsentSingleSignOnWebflowConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"samlIdPConsentSingleSignOnParticipationStrategyConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleSignOnParticipationStrategyConfigurer samlIdPConsentSingleSignOnParticipationStrategyConfigurer(@Qualifier(value="defaultMultifactorTriggerSelectionStrategy") MultifactorAuthenticationTriggerSelectionStrategy multifactorTriggerSelectionStrategy, @Qualifier(value="authenticationContextValidator") MultifactorAuthenticationContextValidator authenticationContextValidator, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="consentActivationStrategy") ConsentActivationStrategy consentActivationStrategy) {
            SamlIdPConsentSingleSignOnParticipationStrategy ssoStrategy = new SamlIdPConsentSingleSignOnParticipationStrategy(servicesManager, ticketRegistrySupport, authenticationServiceSelectionPlan, consentActivationStrategy, authenticationContextValidator, multifactorTriggerSelectionStrategy);
            return chain -> chain.addStrategy((SingleSignOnParticipationStrategy)ssoStrategy);
        }
    }

    @Configuration(value="SamlIdPConsentWebflowConfiguration", proxyBeanMethods=false)
    @ConditionalOnBean(name={"consentEngine"})
    static class SamlIdPConsentWebflowConfiguration {
        SamlIdPConsentWebflowConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"samlIdPConsentableAttributeBuilder"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ConsentableAttributeBuilder samlIdPConsentableAttributeBuilder(@Qualifier(value="attributeDefinitionStore") AttributeDefinitionStore attributeDefinitionStore) {
            return new SamlIdPConsentableAttributeBuilder(attributeDefinitionStore);
        }
    }

    @Configuration(value="SamlIdPWebflowEventsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPWebflowEventsConfiguration {
        SamlIdPWebflowEventsConfiguration() {
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"samlIdPAuthenticationContextWebflowEventResolver"})
        @Lazy(value=false)
        public CasWebflowEventResolver samlIdPAuthenticationContextWebflowEventResolver(@Qualifier(value="samlIdPMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger samlIdPMultifactorAuthenticationTrigger, @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver") CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            DefaultMultifactorAuthenticationProviderWebflowEventResolver r = new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, samlIdPMultifactorAuthenticationTrigger);
            Objects.requireNonNull(initialAuthenticationAttemptWebflowEventResolver).addDelegate((CasWebflowEventResolver)r);
            return r;
        }
    }

    @Configuration(value="SamlIdPWebflowMultifactorAuthenticationConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPWebflowMultifactorAuthenticationConfiguration {
        SamlIdPWebflowMultifactorAuthenticationConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"samlIdPMultifactorAuthenticationTrigger"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrigger samlIdPMultifactorAuthenticationTrigger(@Qualifier(value="samlProfileHandlerConfigurationContext") ObjectProvider<SamlProfileHandlerConfigurationContext> samlProfileHandlerConfigurationContext) {
            return new SamlIdPMultifactorAuthenticationTrigger(samlProfileHandlerConfigurationContext);
        }
    }

    @Configuration(value="SamlIdPWebflowSingleSignOnPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPWebflowSingleSignOnPlanConfiguration {
        SamlIdPWebflowSingleSignOnPlanConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"samlIdPSingleSignOnParticipationStrategyConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleSignOnParticipationStrategyConfigurer samlIdPSingleSignOnParticipationStrategyConfigurer(@Qualifier(value="samlIdPSingleSignOnParticipationStrategy") SingleSignOnParticipationStrategy samlIdPSingleSignOnParticipationStrategy) {
            return chain -> chain.addStrategy(samlIdPSingleSignOnParticipationStrategy);
        }
    }

    @Configuration(value="SamlIdPWebflowSingleSignOnConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPWebflowSingleSignOnConfiguration {
        SamlIdPWebflowSingleSignOnConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"samlIdPSingleSignOnParticipationStrategy"})
        public SingleSignOnParticipationStrategy samlIdPSingleSignOnParticipationStrategy(@Qualifier(value="defaultMultifactorTriggerSelectionStrategy") MultifactorAuthenticationTriggerSelectionStrategy multifactorTriggerSelectionStrategy, @Qualifier(value="authenticationContextValidator") MultifactorAuthenticationContextValidator authenticationContextValidator, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan selectionStrategies) {
            return new SamlIdPSingleSignOnParticipationStrategy(servicesManager, ticketRegistrySupport, selectionStrategies, authenticationContextValidator, multifactorTriggerSelectionStrategy);
        }
    }

    @Configuration(value="SamlIdPWebflowActionsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPWebflowActionsConfiguration {
        SamlIdPWebflowActionsConfiguration() {
        }

        @ConditionalOnMissingBean(name={"samlIdPMetadataUIParserAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action samlIdPMetadataUIParserAction(@Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan selectionStrategies, @Qualifier(value="defaultSamlRegisteredServiceCachingMetadataResolver") SamlRegisteredServiceCachingMetadataResolver defaultSamlRegisteredServiceCachingMetadataResolver) {
            return new SamlIdPMetadataUIAction(servicesManager, defaultSamlRegisteredServiceCachingMetadataResolver, selectionStrategies);
        }
    }

    @Configuration(value="SamlIdPWebflowCoreConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SamlIdPWebflowCoreConfiguration {
        SamlIdPWebflowCoreConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"samlIdPCasWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer samlIdPCasWebflowExecutionPlanConfigurer(@Qualifier(value="samlIdPWebConfigurer") CasWebflowConfigurer samlIdPWebConfigurer) {
            return plan -> plan.registerWebflowConfigurer(samlIdPWebConfigurer);
        }

        @ConditionalOnMissingBean(name={"samlIdPWebConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer samlIdPWebConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return new SamlIdPWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        }
    }
}

