/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.task;

import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskDecorator;
import org.springframework.core.task.TaskExecutor;
import org.springframework.core.task.support.ExecutorServiceAdapter;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.scheduling.concurrent.ExecutorConfigurationSupport;

public class VirtualThreadPoolTaskExecutor
extends ExecutorConfigurationSupport
implements AsyncTaskExecutor,
SchedulingTaskExecutor {
    private static final long serialVersionUID = 4747270938984213408L;
    private int poolSize = -1;
    private TaskDecorator taskDecorator;
    private SimpleAsyncTaskExecutor executor;

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setTaskDecorator(TaskDecorator taskDecorator) {
        this.taskDecorator = taskDecorator;
    }

    protected ExecutorService initializeExecutor(ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        this.executor = new SimpleAsyncTaskExecutor(this.getThreadNamePrefix());
        this.executor.setVirtualThreads(true);
        this.executor.setConcurrencyLimit(this.poolSize);
        Optional.ofNullable(this.taskDecorator).ifPresent(arg_0 -> ((SimpleAsyncTaskExecutor)this.executor).setTaskDecorator(arg_0));
        return new ExecutorServiceAdapter((TaskExecutor)this.executor);
    }

    public void execute(Runnable task) {
        this.executor.execute(task);
    }

    public Future<?> submit(Runnable task) {
        return this.executor.submit(task);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(task);
    }

    public void shutdown() {
    }
}

