/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.auth.login.AccountNotFoundException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.EntitlementsHolder;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.DelegationDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.Delegation;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.utils.RealmUtils;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.ConnectorManager;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.spring.security.Encryptor;
import org.apache.syncope.core.spring.security.JWTAuthentication;
import org.apache.syncope.core.spring.security.JWTSSOProvider;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.apache.syncope.core.spring.security.SyncopeAuthenticationDetails;
import org.apache.syncope.core.spring.security.SyncopeGrantedAuthority;
import org.identityconnectors.framework.common.objects.Uid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.transaction.annotation.Transactional;

public class AuthDataAccessor {
    protected static final Logger LOG = LoggerFactory.getLogger(AuthDataAccessor.class);
    protected static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    protected static final Set<SyncopeGrantedAuthority> ANONYMOUS_AUTHORITIES = Set.of(new SyncopeGrantedAuthority("ANONYMOUS"));
    protected static final Set<SyncopeGrantedAuthority> MUST_CHANGE_PASSWORD_AUTHORITIES = Set.of(new SyncopeGrantedAuthority("MUST_CHANGE_PASSWORD"));
    protected final SecurityProperties securityProperties;
    protected final RealmSearchDAO realmSearchDAO;
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;
    protected final AnySearchDAO anySearchDAO;
    protected final AccessTokenDAO accessTokenDAO;
    protected final ConfParamOps confParamOps;
    protected final RoleDAO roleDAO;
    protected final DelegationDAO delegationDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final ConnectorManager connectorManager;
    protected final AuditManager auditManager;
    protected final MappingManager mappingManager;
    private final List<JWTSSOProvider> jwtSSOProviders;

    public AuthDataAccessor(SecurityProperties securityProperties, RealmSearchDAO realmSearchDAO, UserDAO userDAO, GroupDAO groupDAO, AnySearchDAO anySearchDAO, AccessTokenDAO accessTokenDAO, ConfParamOps confParamOps, RoleDAO roleDAO, DelegationDAO delegationDAO, ExternalResourceDAO resourceDAO, ConnectorManager connectorManager, AuditManager auditManager, MappingManager mappingManager, List<JWTSSOProvider> jwtSSOProviders) {
        this.securityProperties = securityProperties;
        this.realmSearchDAO = realmSearchDAO;
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.anySearchDAO = anySearchDAO;
        this.accessTokenDAO = accessTokenDAO;
        this.confParamOps = confParamOps;
        this.roleDAO = roleDAO;
        this.delegationDAO = delegationDAO;
        this.resourceDAO = resourceDAO;
        this.connectorManager = connectorManager;
        this.auditManager = auditManager;
        this.mappingManager = mappingManager;
        this.jwtSSOProviders = jwtSSOProviders;
    }

    public JWTSSOProvider getJWTSSOProvider(String issuer) {
        if (issuer == null) {
            throw new AuthenticationCredentialsNotFoundException("A null issuer is not permitted");
        }
        return this.jwtSSOProviders.stream().filter(provider -> issuer.equals(provider.getIssuer())).findFirst().orElseThrow(() -> new AuthenticationCredentialsNotFoundException("Could not find any registered JWTSSOProvider for issuer " + issuer));
    }

    protected String getDelegationKey(SyncopeAuthenticationDetails details, String delegatedKey) {
        String delegatingKey;
        if (details.getDelegatedBy() == null) {
            return null;
        }
        String string = delegatingKey = SyncopeConstants.UUID_PATTERN.matcher(details.getDelegatedBy()).matches() ? details.getDelegatedBy() : (String)this.userDAO.findKey(details.getDelegatedBy()).orElse(null);
        if (delegatingKey == null) {
            throw new SessionAuthenticationException("Delegating user " + details.getDelegatedBy() + " cannot be found");
        }
        LOG.debug("Delegation request: delegating:{}, delegated:{}", (Object)delegatingKey, (Object)delegatedKey);
        return (String)this.delegationDAO.findValidFor(delegatingKey, delegatedKey, OffsetDateTime.now()).orElseThrow(() -> new SessionAuthenticationException("Delegation by " + delegatingKey + " was requested but none found"));
    }

    @Transactional(noRollbackFor={DisabledException.class})
    public Triple<User, Boolean, String> authenticate(String domain, Authentication authentication) {
        User user = null;
        String[] authAttrValues = (String[])this.confParamOps.get(domain, "authentication.attributes", (Object)new String[]{"username"}, String[].class);
        for (int i = 0; user == null && i < authAttrValues.length; ++i) {
            if ("username".equals(authAttrValues[i])) {
                user = this.userDAO.findByUsername(authentication.getName()).orElse(null);
                continue;
            }
            AttrCond attrCond = new AttrCond(AttrCond.Type.EQ);
            attrCond.setSchema(authAttrValues[i]);
            attrCond.setExpression(authentication.getName());
            try {
                List users = this.anySearchDAO.search(SearchCond.getLeaf((AbstractSearchCond)attrCond), AnyTypeKind.USER);
                if (users.size() == 1) {
                    user = (User)users.get(0);
                    continue;
                }
                LOG.warn("Search condition {} does not uniquely match a user", (Object)attrCond);
                continue;
            }
            catch (IllegalArgumentException e) {
                LOG.error("While searching user for authentication via {}", (Object)attrCond, (Object)e);
            }
        }
        Boolean authenticated = null;
        String delegationKey = null;
        if (user != null) {
            authenticated = false;
            if (user.isSuspended() != null && user.isSuspended().booleanValue()) {
                throw new DisabledException("User " + user.getUsername() + " is suspended");
            }
            Object[] authStatuses = (String[])this.confParamOps.get(domain, "authentication.statuses", (Object)new String[0], String[].class);
            if (!ArrayUtils.contains((Object[])authStatuses, (Object)user.getStatus())) {
                throw new DisabledException("User " + user.getUsername() + " not allowed to authenticate");
            }
            boolean userModified = false;
            authenticated = this.authenticate(user, authentication.getCredentials().toString());
            if (authenticated.booleanValue()) {
                delegationKey = this.getDelegationKey((SyncopeAuthenticationDetails)SyncopeAuthenticationDetails.class.cast(authentication.getDetails()), user.getKey());
                if (((Boolean)this.confParamOps.get(domain, "log.lastlogindate", (Object)true, Boolean.class)).booleanValue()) {
                    user.setLastLoginDate(OffsetDateTime.now());
                    userModified = true;
                }
                if (user.getFailedLogins() != 0) {
                    user.setFailedLogins(Integer.valueOf(0));
                    userModified = true;
                }
            } else {
                user.setFailedLogins(Integer.valueOf(user.getFailedLogins() + 1));
                userModified = true;
            }
            if (userModified) {
                this.userDAO.save((Entity)user);
            }
        }
        return Triple.of(user, (Object)authenticated, delegationKey);
    }

    protected boolean authenticate(User user, String password) {
        boolean authenticated = ENCRYPTOR.verify(password, user.getCipherAlgorithm(), user.getPassword());
        LOG.debug("{} authenticated on internal storage: {}", (Object)user.getUsername(), (Object)authenticated);
        Iterator<ExternalResource> itor = this.getPassthroughResources(user).iterator();
        while (itor.hasNext() && !authenticated) {
            ExternalResource resource = itor.next();
            String connObjectKey = null;
            try {
                Provision provision = (Provision)resource.getProvisionByAnyType(AnyTypeKind.USER.name()).orElseThrow(() -> new AccountNotFoundException("Unable to locate provision for user type " + AnyTypeKind.USER.name()));
                connObjectKey = (String)this.mappingManager.getConnObjectKeyValue((Any)user, resource, provision).orElseThrow(() -> new AccountNotFoundException("Unable to locate conn object key value for " + AnyTypeKind.USER.name()));
                Uid uid = this.connectorManager.getConnector(resource).authenticate(connObjectKey, password, null);
                if (uid != null) {
                    authenticated = true;
                }
            }
            catch (Exception e) {
                LOG.debug("Could not authenticate {} on {}", new Object[]{user.getUsername(), resource.getKey(), e});
            }
            LOG.debug("{} authenticated on {} as {}: {}", new Object[]{user.getUsername(), resource.getKey(), connObjectKey, authenticated});
        }
        return authenticated;
    }

    protected Set<ExternalResource> getPassthroughResources(User user) {
        HashSet<ExternalResource> result = new HashSet<ExternalResource>();
        this.userDAO.findAllResources(user).stream().filter(r -> r.getAccountPolicy() != null).forEach(resource -> {
            if (result.isEmpty()) {
                result.addAll(this.resourceDAO.findByPolicy((Policy)resource.getAccountPolicy()));
            } else {
                result.retainAll(this.resourceDAO.findByPolicy((Policy)resource.getAccountPolicy()));
            }
        });
        this.realmSearchDAO.findAncestors(user.getRealm()).stream().filter(r -> r.getAccountPolicy() != null).forEach(realm -> {
            if (result.isEmpty()) {
                result.addAll(this.resourceDAO.findByPolicy((Policy)realm.getAccountPolicy()));
            } else {
                result.retainAll(this.resourceDAO.findByPolicy((Policy)realm.getAccountPolicy()));
            }
        });
        return result;
    }

    protected Set<SyncopeGrantedAuthority> getAdminAuthorities() {
        return EntitlementsHolder.getInstance().getValues().stream().map(entitlement -> new SyncopeGrantedAuthority((String)entitlement, "/")).collect(Collectors.toSet());
    }

    protected Set<SyncopeGrantedAuthority> buildAuthorities(Map<String, Set<String>> entForRealms) {
        HashSet<SyncopeGrantedAuthority> authorities = new HashSet<SyncopeGrantedAuthority>();
        entForRealms.forEach((entitlement, realms) -> {
            Pair normalized = RealmUtils.normalize((Collection)realms);
            SyncopeGrantedAuthority authority = new SyncopeGrantedAuthority((String)entitlement);
            authority.addRealms((Collection)normalized.getLeft());
            authority.addRealms((Collection)normalized.getRight());
            authorities.add(authority);
        });
        return authorities;
    }

    protected Set<SyncopeGrantedAuthority> getUserAuthorities(User user) {
        if (user.isMustChangePassword()) {
            return MUST_CHANGE_PASSWORD_AUTHORITIES;
        }
        HashMap<String, Set<String>> entForRealms = new HashMap<String, Set<String>>();
        this.userDAO.findAllRoles(user).stream().filter(role -> !"GROUP_OWNER".equals(role.getKey())).forEach(role -> role.getEntitlements().forEach(entitlement -> {
            Set realms = Optional.ofNullable((Set)entForRealms.get(entitlement)).orElseGet(() -> {
                HashSet r = new HashSet();
                entForRealms.put((String)entitlement, r);
                return r;
            });
            realms.addAll(role.getRealms().stream().map(Realm::getFullPath).collect(Collectors.toSet()));
            if (!entitlement.endsWith("_CREATE") && !entitlement.endsWith("_DELETE")) {
                realms.addAll(role.getDynRealms().stream().map(Entity::getKey).toList());
            }
        }));
        this.groupDAO.findOwnedByUser(user.getKey()).forEach(group -> this.roleDAO.findById("GROUP_OWNER").ifPresentOrElse(groupOwnerRole -> groupOwnerRole.getEntitlements().forEach(entitlement -> {
            Set realms = Optional.ofNullable((Set)entForRealms.get(entitlement)).orElseGet(() -> {
                HashSet r = new HashSet();
                entForRealms.put((String)entitlement, r);
                return r;
            });
            realms.add(RealmUtils.getGroupOwnerRealm((String)group.getRealm().getFullPath(), (String)group.getKey()));
        }), () -> LOG.warn("Role {} was not found", (Object)"GROUP_OWNER")));
        return this.buildAuthorities(entForRealms);
    }

    protected Set<SyncopeGrantedAuthority> getDelegatedAuthorities(Delegation delegation) {
        HashMap<String, Set<String>> entForRealms = new HashMap<String, Set<String>>();
        delegation.getRoles().stream().filter(role -> !"GROUP_OWNER".equals(role.getKey())).forEach(role -> role.getEntitlements().forEach(entitlement -> {
            Set realms = Optional.ofNullable((Set)entForRealms.get(entitlement)).orElseGet(() -> {
                HashSet r = new HashSet();
                entForRealms.put((String)entitlement, r);
                return r;
            });
            realms.addAll(role.getRealms().stream().map(Realm::getFullPath).collect(Collectors.toSet()));
            if (!entitlement.endsWith("_CREATE") && !entitlement.endsWith("_DELETE")) {
                realms.addAll(role.getDynRealms().stream().map(Entity::getKey).toList());
            }
        }));
        return this.buildAuthorities(entForRealms);
    }

    @Transactional
    public Set<SyncopeGrantedAuthority> getAuthorities(String username, String delegationKey) {
        Set<SyncopeGrantedAuthority> authorities;
        if (this.securityProperties.getAnonymousUser().equals(username)) {
            authorities = ANONYMOUS_AUTHORITIES;
        } else if (this.securityProperties.getAdminUser().equals(username)) {
            authorities = this.getAdminAuthorities();
        } else if (delegationKey != null) {
            Delegation delegation = (Delegation)this.delegationDAO.findById(delegationKey).orElseThrow(() -> new UsernameNotFoundException("Could not find delegation " + delegationKey));
            authorities = delegation.getRoles().isEmpty() ? this.getUserAuthorities(delegation.getDelegating()) : this.getDelegatedAuthorities(delegation);
        } else {
            User user = (User)this.userDAO.findByUsername(username).orElseThrow(() -> new UsernameNotFoundException("Could not find any user with username " + username));
            authorities = this.getUserAuthorities(user);
        }
        return authorities;
    }

    @Transactional
    public Pair<String, Set<SyncopeGrantedAuthority>> authenticate(JWTAuthentication authentication) {
        Set<SyncopeGrantedAuthority> authorities;
        String username;
        if (this.securityProperties.getAdminUser().equals(authentication.getClaims().getSubject())) {
            this.accessTokenDAO.findById(authentication.getClaims().getJWTID()).orElseThrow(() -> new AuthenticationCredentialsNotFoundException("Could not find an Access Token for JWT " + authentication.getClaims().getJWTID()));
            username = this.securityProperties.getAdminUser();
            authorities = this.getAdminAuthorities();
        } else {
            JWTSSOProvider jwtSSOProvider = this.getJWTSSOProvider(authentication.getClaims().getIssuer());
            Pair<User, Set<SyncopeGrantedAuthority>> resolved = jwtSSOProvider.resolve(authentication.getClaims());
            if (resolved == null || resolved.getLeft() == null) {
                throw new AuthenticationCredentialsNotFoundException("Could not find User " + authentication.getClaims().getSubject() + " for JWT " + authentication.getClaims().getJWTID());
            }
            User user = (User)resolved.getLeft();
            String delegationKey = this.getDelegationKey(authentication.getDetails(), user.getKey());
            username = user.getUsername();
            authorities = resolved.getRight() == null ? Set.of() : (delegationKey == null ? (Set<SyncopeGrantedAuthority>)resolved.getRight() : this.getAuthorities(username, delegationKey));
            LOG.debug("JWT {} issued by {} resolved to User {} with authorities {}", new Object[]{authentication.getClaims().getJWTID(), authentication.getClaims().getIssuer(), username + Optional.ofNullable(delegationKey).map(d -> " [under delegation " + delegationKey + "]").orElse(""), authorities});
            if (BooleanUtils.isTrue((Boolean)user.isSuspended())) {
                throw new DisabledException("User " + username + " is suspended");
            }
            List<String> authStatuses = List.of((String[])this.confParamOps.get(authentication.getDetails().getDomain(), "authentication.statuses", (Object)new String[0], String[].class));
            if (!authStatuses.contains(user.getStatus())) {
                throw new DisabledException("User " + username + " not allowed to authenticate");
            }
            if (BooleanUtils.isTrue((Boolean)user.isMustChangePassword())) {
                LOG.debug("User {} must change password, resetting authorities", (Object)username);
                authorities = MUST_CHANGE_PASSWORD_AUTHORITIES;
            }
        }
        return Pair.of((Object)username, authorities);
    }

    @Transactional
    public void removeExpired(String tokenKey) {
        this.accessTokenDAO.deleteById(tokenKey);
    }

    @Transactional(readOnly=true)
    public void audit(String domain, String username, String delegationKey, OpEvent.Outcome outcome, Object output, Object ... input) {
        this.auditManager.audit(domain, username + Optional.ofNullable(delegationKey).map(d -> " [under delegation " + delegationKey + "]").orElse(""), OpEvent.CategoryType.LOGIC, "AUTHENTICATION", null, "login", outcome, null, output, input);
    }
}

