/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.types.EntitlementsHolder;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.apache.syncope.core.spring.security.SyncopeAuthenticationDetails;
import org.apache.syncope.core.spring.security.SyncopeGrantedAuthority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;

public final class AuthContextUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AuthContextUtils.class);
    private static final String PLACEHOLDER_PWD = "PLACEHOLDER_PWD";
    private static final String UNAUTHENTICATED = "unauthenticated";

    public static String getUsername() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication == null ? UNAUTHENTICATED : authentication.getName();
    }

    public static void updateUsername(String newUsername) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        UsernamePasswordAuthenticationToken newAuth = new UsernamePasswordAuthenticationToken((Object)new User(newUsername, PLACEHOLDER_PWD, auth.getAuthorities()), auth.getCredentials(), auth.getAuthorities());
        newAuth.setDetails(auth.getDetails());
        SecurityContextHolder.getContext().setAuthentication((Authentication)newAuth);
    }

    public static Optional<String> getDelegatedBy() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        return auth != null && auth.getDetails() instanceof SyncopeAuthenticationDetails ? Optional.ofNullable(((SyncopeAuthenticationDetails)SyncopeAuthenticationDetails.class.cast(auth.getDetails())).getDelegatedBy()) : Optional.empty();
    }

    public static String getWho() {
        return AuthContextUtils.getUsername() + AuthContextUtils.getDelegatedBy().map(d -> {
            String delegatedBy = AuthContextUtils.callAsAdmin(AuthContextUtils.getDomain(), () -> ((UserDAO)ApplicationContextProvider.getApplicationContext().getBean(UserDAO.class)).findUsername(d)).orElse(d);
            return " [delegated by " + delegatedBy + "]";
        }).orElse("");
    }

    public static Set<SyncopeGrantedAuthority> getAuthorities() {
        return Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication()).map(authentication -> authentication.getAuthorities().stream().filter(SyncopeGrantedAuthority.class::isInstance).map(SyncopeGrantedAuthority.class::cast).collect(Collectors.toSet())).orElse(Set.of());
    }

    public static Map<String, Set<String>> getAuthorizations() {
        return Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication()).map(authentication -> authentication.getAuthorities().stream().filter(SyncopeGrantedAuthority.class::isInstance).map(SyncopeGrantedAuthority.class::cast).collect(Collectors.toMap(SyncopeGrantedAuthority::getAuthority, SyncopeGrantedAuthority::getRealms))).orElse(Map.of());
    }

    public static String getDomain() {
        String domainKey;
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String string = domainKey = auth != null && auth.getDetails() instanceof SyncopeAuthenticationDetails ? ((SyncopeAuthenticationDetails)SyncopeAuthenticationDetails.class.cast(auth.getDetails())).getDomain() : null;
        if (StringUtils.isBlank(domainKey)) {
            domainKey = "Master";
        }
        return domainKey;
    }

    private static <T> T call(Authentication authentication, Callable<T> callable) {
        Authentication original = SecurityContextHolder.getContext().getAuthentication();
        SecurityContextHolder.getContext().setAuthentication(authentication);
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            LOG.debug("Error during execution under authentication {}", (Object)authentication, (Object)e);
            if (e instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)e;
                throw runtimeException;
            }
            throw new RuntimeException(e);
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(original);
        }
    }

    public static <T> T callAs(String domain, String username, Collection<String> entitlements, Callable<T> callable) {
        List authorities = entitlements.stream().map(entitlement -> new SyncopeGrantedAuthority((String)entitlement, "/")).collect(Collectors.toList());
        UsernamePasswordAuthenticationToken asAuth = new UsernamePasswordAuthenticationToken((Object)new User(username, PLACEHOLDER_PWD, authorities), (Object)PLACEHOLDER_PWD, authorities);
        asAuth.setDetails((Object)new SyncopeAuthenticationDetails(domain, AuthContextUtils.getDelegatedBy().orElse(null)));
        return AuthContextUtils.call((Authentication)asAuth, callable);
    }

    public static <T> T callAsAdmin(String domain, Callable<T> callable) {
        SecurityProperties properties = (SecurityProperties)ApplicationContextProvider.getBeanFactory().getBean(SecurityProperties.class);
        return AuthContextUtils.callAs(domain, properties.getAdminUser(), EntitlementsHolder.getInstance().getValues(), callable);
    }

    public static void runAsAdmin(String domain, Runnable runnable) {
        AuthContextUtils.callAsAdmin(domain, () -> {
            runnable.run();
            return null;
        });
    }

    private AuthContextUtils() {
    }
}

