/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.policy;

import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.policy.HaveIBeenPwnedPasswordRuleConf;
import org.apache.syncope.common.lib.policy.PasswordRuleConf;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.rules.PasswordRule;
import org.apache.syncope.core.provisioning.api.rules.PasswordRuleConfClass;
import org.apache.syncope.core.spring.policy.PasswordPolicyException;
import org.apache.syncope.core.spring.security.Encryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@PasswordRuleConfClass(value=HaveIBeenPwnedPasswordRuleConf.class)
public class HaveIBeenPwnedPasswordRule
implements PasswordRule {
    protected static final Logger LOG = LoggerFactory.getLogger(HaveIBeenPwnedPasswordRule.class);
    private static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    private HaveIBeenPwnedPasswordRuleConf conf;

    public HaveIBeenPwnedPasswordRuleConf getConf() {
        return this.conf;
    }

    public void setConf(PasswordRuleConf conf) {
        if (!(conf instanceof HaveIBeenPwnedPasswordRuleConf)) {
            throw new IllegalArgumentException(HaveIBeenPwnedPasswordRuleConf.class.getName() + " expected, got " + conf.getClass().getName());
        }
        this.conf = (HaveIBeenPwnedPasswordRuleConf)conf;
    }

    protected void enforce(String clearPassword) {
        try {
            String sha1 = ENCRYPTOR.encode(clearPassword, CipherAlgorithm.SHA1);
            HttpHeaders headers = new HttpHeaders();
            headers.set("User-Agent", "Apache Syncope");
            ResponseEntity response = new RestTemplate().exchange(URI.create("https://api.pwnedpasswords.com/range/" + sha1.substring(0, 5)), HttpMethod.GET, new HttpEntity(null, (MultiValueMap)headers), String.class);
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)response.getBody())) && Stream.of(((String)response.getBody()).split("\\n")).anyMatch(line -> sha1.equals(sha1.substring(0, 5) + StringUtils.substringBefore((String)line, (String)":")))) {
                throw new PasswordPolicyException("Password pwned");
            }
        }
        catch (GeneralSecurityException e) {
            LOG.error("Could not encode the password value as SHA1", (Throwable)e);
        }
        catch (HttpStatusCodeException e) {
            LOG.error("Error while contacting the PwnedPasswords service", (Throwable)e);
        }
    }

    public void enforce(String username, String clearPassword) {
        Optional.ofNullable(clearPassword).ifPresent(this::enforce);
    }

    @Transactional(readOnly=true)
    public void enforce(User user, String clearPassword) {
        Optional.ofNullable(clearPassword).ifPresent(this::enforce);
    }

    @Transactional(readOnly=true)
    public void enforce(LinkedAccount account) {
        if (account.getPassword() != null) {
            String clearPassword = null;
            if (account.canDecodeSecrets()) {
                try {
                    clearPassword = ENCRYPTOR.decode(account.getPassword(), account.getCipherAlgorithm());
                }
                catch (Exception e) {
                    LOG.error("Could not decode password for {}", (Object)account, (Object)e);
                }
            }
            if (clearPassword != null) {
                this.enforce(clearPassword);
            }
        }
    }
}

