/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.implementation;

import groovy.lang.GroovyClassLoader;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.command.CommandArgs;
import org.apache.syncope.common.lib.policy.AccountRuleConf;
import org.apache.syncope.common.lib.policy.InboundCorrelationRuleConf;
import org.apache.syncope.common.lib.policy.PasswordRuleConf;
import org.apache.syncope.common.lib.policy.PushCorrelationRuleConf;
import org.apache.syncope.common.lib.report.ReportConf;
import org.apache.syncope.common.lib.types.ImplementationEngine;
import org.apache.syncope.common.lib.types.ImplementationTypesHolder;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.provisioning.api.ImplementationLookup;
import org.apache.syncope.core.provisioning.api.job.report.ReportJobDelegate;
import org.apache.syncope.core.provisioning.api.rules.AccountRule;
import org.apache.syncope.core.provisioning.api.rules.InboundCorrelationRule;
import org.apache.syncope.core.provisioning.api.rules.PasswordRule;
import org.apache.syncope.core.provisioning.api.rules.PushCorrelationRule;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.implementation.InstanceScope;
import org.apache.syncope.core.spring.implementation.SyncopeImplementation;

public final class ImplementationManager {
    private static final GroovyClassLoader GROOVY_CLASSLOADER = new GroovyClassLoader();
    private static final Map<String, Class<?>> CLASS_CACHE = Collections.synchronizedMap(new HashMap());

    public static Optional<ReportJobDelegate> buildReportJobDelegate(Implementation impl, Supplier<ReportJobDelegate> cacheGetter, Consumer<ReportJobDelegate> cachePutter) throws ClassNotFoundException {
        switch (impl.getEngine()) {
            case GROOVY: {
                return Optional.of(ImplementationManager.build(impl, cacheGetter, cachePutter));
            }
        }
        ReportConf conf = (ReportConf)POJOHelper.deserialize((String)impl.getBody(), ReportConf.class);
        Class clazz = ((ImplementationLookup)ApplicationContextProvider.getApplicationContext().getBean(ImplementationLookup.class)).getReportClass(conf.getClass());
        if (clazz == null) {
            return Optional.empty();
        }
        ReportJobDelegate report = ImplementationManager.build(clazz, true, cacheGetter, cachePutter);
        report.setConf(conf);
        return Optional.of(report);
    }

    public static Optional<AccountRule> buildAccountRule(Implementation impl, Supplier<AccountRule> cacheGetter, Consumer<AccountRule> cachePutter) throws ClassNotFoundException {
        switch (impl.getEngine()) {
            case GROOVY: {
                return Optional.of(ImplementationManager.build(impl, cacheGetter, cachePutter));
            }
        }
        AccountRuleConf conf = (AccountRuleConf)POJOHelper.deserialize((String)impl.getBody(), AccountRuleConf.class);
        Class clazz = ((ImplementationLookup)ApplicationContextProvider.getApplicationContext().getBean(ImplementationLookup.class)).getAccountRuleClass(conf.getClass());
        if (clazz == null) {
            return Optional.empty();
        }
        AccountRule rule = ImplementationManager.build(clazz, true, cacheGetter, cachePutter);
        rule.setConf(conf);
        return Optional.of(rule);
    }

    public static Optional<PasswordRule> buildPasswordRule(Implementation impl, Supplier<PasswordRule> cacheGetter, Consumer<PasswordRule> cachePutter) throws ClassNotFoundException {
        switch (impl.getEngine()) {
            case GROOVY: {
                return Optional.of(ImplementationManager.build(impl, cacheGetter, cachePutter));
            }
        }
        PasswordRuleConf conf = (PasswordRuleConf)POJOHelper.deserialize((String)impl.getBody(), PasswordRuleConf.class);
        Class clazz = ((ImplementationLookup)ApplicationContextProvider.getApplicationContext().getBean(ImplementationLookup.class)).getPasswordRuleClass(conf.getClass());
        if (clazz == null) {
            return Optional.empty();
        }
        PasswordRule rule = ImplementationManager.build(clazz, true, cacheGetter, cachePutter);
        rule.setConf(conf);
        return Optional.of(rule);
    }

    public static Optional<InboundCorrelationRule> buildInboundCorrelationRule(Implementation impl, Supplier<InboundCorrelationRule> cacheGetter, Consumer<InboundCorrelationRule> cachePutter) throws ClassNotFoundException {
        switch (impl.getEngine()) {
            case GROOVY: {
                return Optional.of(ImplementationManager.build(impl, cacheGetter, cachePutter));
            }
        }
        InboundCorrelationRuleConf conf = (InboundCorrelationRuleConf)POJOHelper.deserialize((String)impl.getBody(), InboundCorrelationRuleConf.class);
        Class clazz = ((ImplementationLookup)ApplicationContextProvider.getApplicationContext().getBean(ImplementationLookup.class)).getInboundCorrelationRuleClass(conf.getClass());
        if (clazz == null) {
            return Optional.empty();
        }
        InboundCorrelationRule rule = ImplementationManager.build(clazz, true, cacheGetter, cachePutter);
        rule.setConf(conf);
        return Optional.of(rule);
    }

    public static Optional<PushCorrelationRule> buildPushCorrelationRule(Implementation impl, Supplier<PushCorrelationRule> cacheGetter, Consumer<PushCorrelationRule> cachePutter) throws ClassNotFoundException {
        switch (impl.getEngine()) {
            case GROOVY: {
                return Optional.of(ImplementationManager.build(impl, cacheGetter, cachePutter));
            }
        }
        PushCorrelationRuleConf conf = (PushCorrelationRuleConf)POJOHelper.deserialize((String)impl.getBody(), PushCorrelationRuleConf.class);
        Class clazz = ((ImplementationLookup)ApplicationContextProvider.getApplicationContext().getBean(ImplementationLookup.class)).getPushCorrelationRuleClass(conf.getClass());
        if (clazz == null) {
            return Optional.empty();
        }
        PushCorrelationRule rule = ImplementationManager.build(clazz, true, cacheGetter, cachePutter);
        rule.setConf(conf);
        return Optional.of(rule);
    }

    private static Class<? extends CommandArgs> findCommandArgsClass(Type type) {
        if (type.getTypeName().startsWith((String)ImplementationTypesHolder.getInstance().getValues().get("COMMAND") + "<")) {
            return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        if (type instanceof Class) {
            Class aClass = (Class)type;
            for (Type i : aClass.getGenericInterfaces()) {
                Class<? extends CommandArgs> r = ImplementationManager.findCommandArgsClass(i);
                if (r == null) continue;
                return r;
            }
        }
        return null;
    }

    public static CommandArgs emptyArgs(Implementation impl) throws Exception {
        if (!"COMMAND".equals(impl.getType())) {
            throw new IllegalArgumentException("This method can be only called on implementations");
        }
        Class commandClass = (Class)ImplementationManager.getClass(impl).getLeft();
        Class<? extends CommandArgs> commandArgsClass = ImplementationManager.findCommandArgsClass(commandClass);
        if (commandArgsClass != null && (commandArgsClass.getEnclosingClass() == null || Modifier.isStatic(commandArgsClass.getModifiers()))) {
            return commandArgsClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        throw new IllegalArgumentException(CommandArgs.class.getName() + " shall be either declared as independent or nested static");
    }

    private static <T> Pair<Class<T>, Boolean> getClass(Implementation impl) throws ClassNotFoundException {
        if (CLASS_CACHE.containsKey(impl.getKey())) {
            return Pair.of(CLASS_CACHE.get(impl.getKey()), (Object)true);
        }
        Class clazz = switch (impl.getEngine()) {
            case ImplementationEngine.GROOVY -> GROOVY_CLASSLOADER.parseClass(impl.getBody());
            default -> Class.forName(impl.getBody());
        };
        CLASS_CACHE.put(impl.getKey(), clazz);
        return Pair.of((Object)clazz, (Object)false);
    }

    public static <T> T build(Implementation impl) throws ClassNotFoundException {
        return (T)ApplicationContextProvider.getBeanFactory().createBean((Class)ImplementationManager.getClass(impl).getLeft());
    }

    private static <T> T build(Class<T> clazz, boolean classCached, Supplier<T> cacheGetter, Consumer<T> cachePutter) {
        boolean perContext = Optional.ofNullable(clazz.getAnnotation(SyncopeImplementation.class)).map(ann -> ann.scope() == InstanceScope.PER_CONTEXT).orElse(true);
        Object instance = null;
        if (perContext && classCached) {
            instance = cacheGetter.get();
        }
        if (instance == null) {
            instance = ApplicationContextProvider.getBeanFactory().createBean(clazz);
            if (perContext) {
                cachePutter.accept(instance);
            }
        }
        return (T)instance;
    }

    public static <T> T build(Implementation impl, Supplier<T> cacheGetter, Consumer<T> cachePutter) throws ClassNotFoundException {
        Pair<Class<T>, Boolean> clazz = ImplementationManager.getClass(impl);
        return ImplementationManager.build((Class)clazz.getLeft(), (Boolean)clazz.getRight(), cacheGetter, cachePutter);
    }

    public static Class<?> purge(String implementation) {
        return CLASS_CACHE.remove(implementation);
    }

    private ImplementationManager() {
    }
}

