/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.authentication.principal;

import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.NotImplementedException;
import org.apereo.cas.authentication.principal.AbstractServiceFactory;
import org.apereo.cas.support.saml.authentication.principal.SamlService;
import org.apereo.cas.support.saml.util.AbstractSamlObjectBuilder;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.util.StringUtils;

public class SamlServiceFactory
extends AbstractServiceFactory<SamlService> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlServiceFactory.class);
    private static final Namespace NAMESPACE_ENVELOPE = Namespace.getNamespace((String)"http://schemas.xmlsoap.org/soap/envelope/");
    private static final Namespace NAMESPACE_SAML1 = Namespace.getNamespace((String)"urn:oasis:names:tc:SAML:1.0:protocol");

    public SamlService createService(HttpServletRequest request) {
        String service = request.getParameter("TARGET");
        String requestBody = request.getRequestURI().contains("/samlValidate") && request.getMethod().equalsIgnoreCase(HttpMethod.POST.name()) ? SamlServiceFactory.getRequestBody(request) : null;
        LOGGER.trace("Request Body: [{}]", requestBody);
        if (!StringUtils.hasText((String)service) && !StringUtils.hasText((String)requestBody)) {
            LOGGER.trace("Request does not specify a [{}] or request body is empty", (Object)"TARGET");
            return null;
        }
        String id = SamlServiceFactory.cleanupUrl((String)service);
        if (StringUtils.hasText((String)requestBody)) {
            request.setAttribute("SAMLRequest", (Object)requestBody);
        }
        Element requestChild = SamlServiceFactory.getRequestDocumentElement(requestBody);
        String artifactId = SamlServiceFactory.getArtifactIdFromRequest(requestChild);
        String requestId = SamlServiceFactory.getRequestIdFromRequest(requestChild);
        LOGGER.trace("Extracted ArtifactId: [{}]. Extracted Request Id: [{}]", (Object)artifactId, (Object)requestId);
        SamlService samlService = new SamlService(id, service, artifactId, requestId);
        samlService.setSource("TARGET");
        return samlService;
    }

    public SamlService createService(String id) {
        throw new NotImplementedException("This operation is not supported. ");
    }

    private static String getRequestBody(HttpServletRequest request) {
        String body = SamlServiceFactory.readRequestBodyIfAny(request);
        if (!StringUtils.hasText((String)body)) {
            LOGGER.trace("Looking at the request attribute [{}] to locate SAML request body", (Object)"SAMLRequest");
            return (String)request.getAttribute("SAMLRequest");
        }
        return body;
    }

    private static String readRequestBodyIfAny(HttpServletRequest request) {
        String string;
        block8: {
            BufferedReader reader = request.getReader();
            try {
                string = reader.lines().collect(Collectors.joining(" "));
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.trace("Could not obtain the saml request body from the http request", (Throwable)e);
                    return null;
                }
            }
            reader.close();
        }
        return string;
    }

    private static Element getRequestDocumentElement(String requestBody) {
        if (StringUtils.hasText((String)requestBody)) {
            Document document = AbstractSamlObjectBuilder.constructDocumentFromXml(requestBody);
            if (document == null) {
                LOGGER.trace("XML document could not extracted from request body [{}]", (Object)requestBody);
                return null;
            }
            Element root = document.getRootElement();
            Element body = root.getChild("Body", NAMESPACE_ENVELOPE);
            if (body == null) {
                LOGGER.trace("XML document root has no child body element");
                return null;
            }
            return body.getChild("Request", NAMESPACE_SAML1);
        }
        return null;
    }

    private static String getRequestIdFromRequest(Element requestChild) {
        if (requestChild == null) {
            LOGGER.trace("Element responsible for RequestID is undefined");
            return null;
        }
        Attribute requestIdAttribute = requestChild.getAttribute("RequestID");
        if (requestIdAttribute == null) {
            LOGGER.trace("XML element has no attribute for RequestID");
            return null;
        }
        return requestIdAttribute.getValue().trim();
    }

    private static String getArtifactIdFromRequest(Element requestChild) {
        if (requestChild == null) {
            LOGGER.trace("Element responsible for AssertionArtifact is undefined");
            return null;
        }
        Element artifactElement = requestChild.getChild("AssertionArtifact", NAMESPACE_SAML1);
        if (artifactElement == null) {
            LOGGER.trace("Element [{}] does not contain a child element for AssertionArtifact", (Object)requestChild.getName());
            return null;
        }
        return artifactElement.getValue().trim();
    }

    @Generated
    public SamlServiceFactory() {
    }
}

