/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.AbstractCentralAuthenticationService;
import org.apereo.cas.CentralAuthenticationServiceContext;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.exceptions.MixedPrincipalException;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.merger.AttributeMerger;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesCoreProperties;
import org.apereo.cas.services.CasModelRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.UnauthorizedProxyingException;
import org.apereo.cas.services.UnauthorizedSsoServiceException;
import org.apereo.cas.support.events.ticket.CasProxyGrantingTicketCreatedEvent;
import org.apereo.cas.support.events.ticket.CasProxyTicketGrantedEvent;
import org.apereo.cas.support.events.ticket.CasServiceTicketGrantedEvent;
import org.apereo.cas.support.events.ticket.CasServiceTicketValidatedEvent;
import org.apereo.cas.support.events.ticket.CasTicketGrantingTicketCreatedEvent;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.RenewableServiceTicket;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.ServiceTicketFactory;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketGrantingTicketFactory;
import org.apereo.cas.ticket.UnrecognizableServiceForServiceTicketValidationException;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicketFactory;
import org.apereo.cas.ticket.proxy.ProxyTicket;
import org.apereo.cas.ticket.proxy.ProxyTicketFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.validation.DefaultAssertionBuilder;
import org.apereo.inspektr.audit.annotation.Audit;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.jooq.lambda.Unchecked;
import org.jooq.lambda.fi.util.function.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public class DefaultCentralAuthenticationService
extends AbstractCentralAuthenticationService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCentralAuthenticationService.class);
    private static final long serialVersionUID = -8943828074939533986L;

    public DefaultCentralAuthenticationService(CentralAuthenticationServiceContext context) {
        super(context);
    }

    @Audit(action="TICKET_GRANTING_TICKET", actionResolverName="CREATE_TICKET_GRANTING_TICKET_RESOLVER", resourceResolverName="CREATE_TICKET_GRANTING_TICKET_RESOURCE_RESOLVER")
    public Ticket createTicketGrantingTicket(AuthenticationResult authenticationResult) throws Throwable {
        Authentication authentication = authenticationResult.getAuthentication();
        Service service = authenticationResult.getService();
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        if (service != null) {
            service = this.resolveServiceFromAuthenticationRequest(service);
            LOGGER.debug("Resolved service [{}] from the authentication request", (Object)service);
            RegisteredService registeredService = this.configurationContext.getServicesManager().findServiceBy(service);
            this.enforceRegisteredServiceAccess(authentication, service, registeredService);
        }
        TicketGrantingTicketFactory factory = (TicketGrantingTicketFactory)this.configurationContext.getTicketFactory().get(TicketGrantingTicket.class);
        TicketGrantingTicket ticketGrantingTicket = factory.create(authentication, service, TicketGrantingTicket.class);
        Ticket addedTicket = this.configurationContext.getTicketRegistry().addTicket((Ticket)ticketGrantingTicket);
        this.doPublishEvent((ApplicationEvent)new CasTicketGrantingTicketCreatedEvent((Object)this, ticketGrantingTicket, clientInfo));
        return addedTicket;
    }

    @Audit(action="SERVICE_TICKET", actionResolverName="GRANT_SERVICE_TICKET_RESOLVER", resourceResolverName="GRANT_SERVICE_TICKET_RESOURCE_RESOLVER")
    public Ticket grantServiceTicket(final String ticketGrantingTicketId, final Service service, final AuthenticationResult authenticationResult) throws Throwable {
        final boolean credentialProvided = authenticationResult != null && authenticationResult.isCredentialProvided();
        final ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        return (Ticket)this.configurationContext.getLockRepository().execute((Object)ticketGrantingTicketId, Unchecked.supplier((CheckedSupplier)new CheckedSupplier<Ticket>(){

            public Ticket get() throws Throwable {
                TicketGrantingTicket ticketGrantingTicket = (TicketGrantingTicket)DefaultCentralAuthenticationService.this.configurationContext.getTicketRegistry().getTicket(ticketGrantingTicketId, TicketGrantingTicket.class);
                Service selectedService = DefaultCentralAuthenticationService.this.resolveServiceFromAuthenticationRequest(service);
                RegisteredService registeredService = DefaultCentralAuthenticationService.this.configurationContext.getServicesManager().findServiceBy(selectedService);
                Authentication currentAuthentication = DefaultCentralAuthenticationService.evaluatePossibilityOfMixedPrincipals(authenticationResult, ticketGrantingTicket);
                RegisteredServiceAccessStrategyUtils.ensureServiceSsoAccessIsAllowed((RegisteredService)registeredService, (Service)selectedService, (TicketGrantingTicket)ticketGrantingTicket, (boolean)credentialProvided);
                DefaultCentralAuthenticationService.this.evaluateProxiedServiceIfNeeded(selectedService, ticketGrantingTicket, registeredService);
                DefaultCentralAuthenticationService.this.getAuthenticationSatisfiedByPolicy(currentAuthentication, selectedService, registeredService);
                Authentication latestAuthentication = ticketGrantingTicket.getRoot().getAuthentication();
                Principal principal = latestAuthentication.getPrincipal();
                RegisteredServiceAttributeReleasePolicyContext releasePolicyContext = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService(registeredService).service(service).principal(principal).applicationContext((ApplicationContext)DefaultCentralAuthenticationService.this.configurationContext.getApplicationContext()).build();
                AttributeMerger merger = CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)PrincipalAttributesCoreProperties.MergingStrategyTypes.MULTIVALUED);
                Map policyAttributes = registeredService.getAttributeReleasePolicy().getAttributes(releasePolicyContext);
                Map accessAttributes = CoreAuthenticationUtils.mergeAttributes((Map)principal.getAttributes(), (Map)latestAuthentication.getAttributes(), (AttributeMerger)merger);
                accessAttributes = CoreAuthenticationUtils.mergeAttributes((Map)accessAttributes, (Map)policyAttributes, (AttributeMerger)merger);
                Principal accessPrincipal = DefaultCentralAuthenticationService.this.configurationContext.getPrincipalFactory().createPrincipal(principal.getId(), accessAttributes);
                DefaultCentralAuthenticationService.this.enforceRegisteredServiceAccess(selectedService, registeredService, accessPrincipal);
                ServiceTicketFactory factory = (ServiceTicketFactory)DefaultCentralAuthenticationService.this.configurationContext.getTicketFactory().get(ServiceTicket.class);
                ServiceTicket serviceTicket = (ServiceTicket)factory.create(ticketGrantingTicket, selectedService, credentialProvided, ServiceTicket.class);
                if (!ticketGrantingTicket.isStateless()) {
                    DefaultCentralAuthenticationService.this.configurationContext.getTicketRegistry().updateTicket((Ticket)ticketGrantingTicket);
                }
                Ticket addedServiceTicket = DefaultCentralAuthenticationService.this.configurationContext.getTicketRegistry().addTicket((Ticket)serviceTicket);
                LOGGER.info("Granted service ticket [{}] for service [{}] and principal [{}]", new Object[]{serviceTicket.getId(), DigestUtils.abbreviate((String)selectedService.getId()), principal.getId()});
                DefaultCentralAuthenticationService.this.doPublishEvent((ApplicationEvent)new CasServiceTicketGrantedEvent((Object)this, ticketGrantingTicket, serviceTicket, clientInfo));
                return addedServiceTicket;
            }
        })).orElseThrow(() -> new InvalidTicketException(ticketGrantingTicketId));
    }

    @Audit(action="PROXY_TICKET", actionResolverName="GRANT_PROXY_TICKET_RESOLVER", resourceResolverName="GRANT_PROXY_TICKET_RESOURCE_RESOLVER")
    public Ticket grantProxyTicket(String proxyGrantingTicketId, Service service) throws AbstractTicketException {
        ProxyGrantingTicket proxyGrantingTicket = (ProxyGrantingTicket)this.configurationContext.getTicketRegistry().getTicket(proxyGrantingTicketId, ProxyGrantingTicket.class);
        RegisteredService registeredService = this.configurationContext.getServicesManager().findServiceBy(service);
        try {
            this.enforceRegisteredServiceAccess(service, (TicketGrantingTicket)proxyGrantingTicket, registeredService);
            RegisteredServiceAccessStrategyUtils.ensureServiceSsoAccessIsAllowed((RegisteredService)registeredService, (Service)service, (TicketGrantingTicket)proxyGrantingTicket);
        }
        catch (Throwable e) {
            LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
            throw new UnauthorizedSsoServiceException();
        }
        this.evaluateProxiedServiceIfNeeded(service, (TicketGrantingTicket)proxyGrantingTicket, registeredService);
        this.getAuthenticationSatisfiedByPolicy(proxyGrantingTicket.getRoot().getAuthentication(), service, registeredService);
        Authentication authentication = proxyGrantingTicket.getRoot().getAuthentication();
        return (Ticket)this.configurationContext.getLockRepository().execute((Object)proxyGrantingTicket.getId(), () -> (Ticket)FunctionUtils.doUnchecked(() -> {
            Principal principal = authentication.getPrincipal();
            ProxyTicketFactory factory = (ProxyTicketFactory)this.configurationContext.getTicketFactory().get(ProxyTicket.class);
            ProxyTicket proxyTicket = (ProxyTicket)factory.create(proxyGrantingTicket, service, ProxyTicket.class);
            ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
            if (!proxyGrantingTicket.isStateless()) {
                this.configurationContext.getTicketRegistry().updateTicket((Ticket)proxyGrantingTicket);
            }
            Ticket addedProxyTicket = this.configurationContext.getTicketRegistry().addTicket((Ticket)proxyTicket);
            LOGGER.info("Granted proxy ticket [{}] for service [{}] for user [{}]", new Object[]{addedProxyTicket.getId(), service.getId(), principal.getId()});
            this.doPublishEvent((ApplicationEvent)new CasProxyTicketGrantedEvent((Object)this, proxyGrantingTicket, addedProxyTicket, clientInfo));
            return addedProxyTicket;
        })).orElseThrow(UnauthorizedProxyingException::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Audit(action="SERVICE_TICKET_VALIDATE", actionResolverName="VALIDATE_SERVICE_TICKET_RESOLVER", resourceResolverName="VALIDATE_SERVICE_TICKET_RESOURCE_RESOLVER")
    public Assertion validateServiceTicket(String serviceTicketId, Service service) throws Throwable {
        if (!this.isTicketAuthenticityVerified(serviceTicketId)) {
            LOGGER.info("Service ticket [{}] is not a valid ticket issued by CAS.", (Object)serviceTicketId);
            throw new InvalidTicketException(serviceTicketId);
        }
        ServiceTicket serviceTicket = (ServiceTicket)this.configurationContext.getTicketRegistry().getTicket(serviceTicketId, ServiceTicket.class);
        if (serviceTicket == null) {
            LOGGER.warn("Service ticket [{}] does not exist.", (Object)serviceTicketId);
            throw new InvalidTicketException(serviceTicketId);
        }
        if (!(serviceTicket.getTicketGrantingTicket() instanceof TicketGrantingTicket) && !serviceTicket.isStateless()) {
            LOGGER.warn("Service ticket [{}] is not assigned a valid ticket granting ticket", (Object)serviceTicketId);
            throw new InvalidTicketException(serviceTicketId);
        }
        try {
            Service selectedService = this.resolveServiceFromAuthenticationRequest(serviceTicket.getService());
            Service resolvedService = this.resolveServiceFromAuthenticationRequest(service);
            LOGGER.debug("Resolved service [{}] from the authentication request with service [{}] linked to service ticket [{}]", new Object[]{resolvedService, selectedService, serviceTicket.getId()});
            this.configurationContext.getLockRepository().execute((Object)serviceTicket.getId(), Unchecked.supplier(() -> {
                if (serviceTicket.isExpired()) {
                    LOGGER.info("Service ticket [{}] has expired.", (Object)serviceTicketId);
                    throw new InvalidTicketException(serviceTicketId);
                }
                if (!this.configurationContext.getServiceMatchingStrategy().matches(selectedService, resolvedService)) {
                    LOGGER.error("Service ticket [{}] with service [{}] does not match supplied service [{}]", new Object[]{serviceTicketId, serviceTicket.getService().getId(), resolvedService.getId()});
                    throw new UnrecognizableServiceForServiceTicketValidationException(selectedService);
                }
                serviceTicket.update();
                if (!serviceTicket.isStateless()) {
                    this.configurationContext.getTicketRegistry().updateTicket((Ticket)serviceTicket);
                }
                return serviceTicket;
            }));
            RegisteredService registeredService = this.configurationContext.getServicesManager().findServiceBy(selectedService);
            LOGGER.trace("Located registered service definition [{}] from [{}] to handle validation request", (Object)registeredService, (Object)selectedService);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)selectedService, (RegisteredService)registeredService);
            TicketGrantingTicket ticketGrantingTicket = (TicketGrantingTicket)serviceTicket.getTicketGrantingTicket();
            Authentication authentication = serviceTicket.isStateless() ? serviceTicket.getAuthentication() : ticketGrantingTicket.getRoot().getAuthentication();
            authentication = this.getAuthenticationSatisfiedByPolicy(authentication, selectedService, registeredService);
            Principal principal = serviceTicket.isStateless() ? this.rebuildStatelessTicketPrincipal(serviceTicket) : authentication.getPrincipal();
            RegisteredServiceAttributeReleasePolicy attributePolicy = Objects.requireNonNull(registeredService.getAttributeReleasePolicy());
            LOGGER.debug("Attribute policy [{}] is associated with service [{}]", (Object)attributePolicy, (Object)registeredService);
            RegisteredServiceAttributeReleasePolicyContext context = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService(registeredService).service(selectedService).principal(principal).applicationContext((ApplicationContext)this.configurationContext.getApplicationContext()).build();
            Map attributesToRelease = attributePolicy.getAttributes(context);
            LOGGER.debug("Calculated attributes for release per the release policy are [{}]", attributesToRelease.keySet());
            AuthenticationBuilder builder = DefaultAuthenticationBuilder.of((ApplicationContext)this.configurationContext.getApplicationContext(), (Principal)principal, (PrincipalFactory)this.configurationContext.getPrincipalFactory(), (Map)attributesToRelease, (Service)selectedService, (RegisteredService)registeredService, (Authentication)authentication);
            LOGGER.debug("Principal determined for release to [{}] is [{}]", (Object)registeredService.getServiceId(), (Object)builder.getPrincipal().getId());
            builder.addAttribute("isFromNewLogin", CollectionUtils.wrap((Object)((RenewableServiceTicket)serviceTicket).isFromNewLogin()));
            builder.addAttribute("longTermAuthenticationRequestTokenUsed", CollectionUtils.wrap((Object)CoreAuthenticationUtils.isRememberMeAuthentication((Authentication)authentication)));
            Authentication finalAuthentication = builder.build();
            RegisteredServiceAttributeReleasePolicyContext releasePolicyContext = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService(registeredService).service(service).applicationContext((ApplicationContext)this.configurationContext.getApplicationContext()).principal(principal).build();
            Map policyAttributes = registeredService.getAttributeReleasePolicy().getAttributes(releasePolicyContext);
            AttributeMerger merger = CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)PrincipalAttributesCoreProperties.MergingStrategyTypes.MULTIVALUED);
            Map accessAttributes = CoreAuthenticationUtils.mergeAttributes((Map)principal.getAttributes(), (Map)authentication.getAttributes(), (AttributeMerger)merger);
            accessAttributes = CoreAuthenticationUtils.mergeAttributes((Map)accessAttributes, (Map)finalAuthentication.getPrincipal().getAttributes(), (AttributeMerger)merger);
            accessAttributes = CoreAuthenticationUtils.mergeAttributes((Map)accessAttributes, (Map)finalAuthentication.getAttributes(), (AttributeMerger)merger);
            accessAttributes = CoreAuthenticationUtils.mergeAttributes((Map)accessAttributes, (Map)policyAttributes, (AttributeMerger)merger);
            Principal accessPrincipal = this.configurationContext.getPrincipalFactory().createPrincipal(principal.getId(), accessAttributes);
            this.enforceRegisteredServiceAccess(selectedService, registeredService, accessPrincipal);
            Map assertionContext = serviceTicket.isStateless() ? CollectionUtils.wrap((String)Principal.class.getName(), (Object)authentication.getPrincipal().getId()) : CollectionUtils.wrap((String)TicketGrantingTicket.class.getName(), (Object)ticketGrantingTicket.getRoot().getId());
            Assertion assertion = DefaultAssertionBuilder.builder().primaryAuthentication(finalAuthentication).originalAuthentication(authentication).service(selectedService).registeredService(registeredService).authentications(serviceTicket.isStateless() ? List.of(serviceTicket.getAuthentication()) : ticketGrantingTicket.getChainedAuthentications()).newLogin(((RenewableServiceTicket)serviceTicket).isFromNewLogin()).stateless(serviceTicket.isStateless()).context(assertionContext).build().assemble();
            ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
            this.doPublishEvent((ApplicationEvent)new CasServiceTicketValidatedEvent((Object)this, serviceTicket, assertion, clientInfo));
            Assertion assertion2 = assertion;
            return assertion2;
        }
        finally {
            if (!serviceTicket.isStateless()) {
                if (serviceTicket.isExpired()) {
                    this.configurationContext.getTicketRegistry().deleteTicket(serviceTicketId);
                } else {
                    this.configurationContext.getTicketRegistry().updateTicket((Ticket)serviceTicket);
                }
            }
        }
    }

    @Audit(action="PROXY_GRANTING_TICKET", actionResolverName="CREATE_PROXY_GRANTING_TICKET_RESOLVER", resourceResolverName="CREATE_PROXY_GRANTING_TICKET_RESOURCE_RESOLVER")
    public Ticket createProxyGrantingTicket(String serviceTicketId, AuthenticationResult authenticationResult) throws Throwable {
        ServiceTicket serviceTicket = (ServiceTicket)this.configurationContext.getTicketRegistry().getTicket(serviceTicketId, ServiceTicket.class);
        if (serviceTicket == null || serviceTicket.isExpired()) {
            LOGGER.debug("ServiceTicket [{}] has expired or cannot be found in the ticket registry", (Object)serviceTicketId);
            throw new InvalidTicketException(serviceTicketId);
        }
        CasModelRegisteredService registeredService = (CasModelRegisteredService)this.configurationContext.getServicesManager().findServiceBy(serviceTicket.getService());
        AuditableContext ctx = AuditableContext.builder().serviceTicket(serviceTicket).authenticationResult(authenticationResult).registeredService((RegisteredService)registeredService).build();
        this.enforceRegisteredServiceAccess(ctx);
        if (!registeredService.getProxyPolicy().isAllowedToProxy()) {
            LOGGER.warn("Service [{}] attempted to proxy, but is not allowed.", (Object)serviceTicket.getService().getId());
            throw new UnauthorizedProxyingException();
        }
        return (Ticket)this.configurationContext.getLockRepository().execute((Object)serviceTicket.getId(), Unchecked.supplier(() -> {
            Authentication authentication = authenticationResult.getAuthentication();
            ProxyGrantingTicketFactory factory = (ProxyGrantingTicketFactory)this.configurationContext.getTicketFactory().get(ProxyGrantingTicket.class);
            ProxyGrantingTicket proxyGrantingTicket = factory.create(serviceTicket, authentication, ProxyGrantingTicket.class);
            Ticket addedTicket = this.configurationContext.getTicketRegistry().addTicket((Ticket)proxyGrantingTicket);
            LOGGER.debug("Generated proxy granting ticket [{}] based off of [{}]", (Object)proxyGrantingTicket, (Object)serviceTicketId);
            if (!serviceTicket.isStateless()) {
                this.configurationContext.getTicketRegistry().updateTicket(serviceTicket.getTicketGrantingTicket());
            }
            ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
            this.doPublishEvent((ApplicationEvent)new CasProxyGrantingTicketCreatedEvent((Object)this, addedTicket, clientInfo));
            return addedTicket;
        })).orElseThrow(UnauthorizedProxyingException::new);
    }

    private void enforceRegisteredServiceAccess(Authentication authentication, Service service, RegisteredService registeredService) throws Throwable {
        RegisteredServiceAttributeReleasePolicyContext attributeReleaseContext = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService(registeredService).service(service).principal(authentication.getPrincipal()).applicationContext((ApplicationContext)this.configurationContext.getApplicationContext()).build();
        Map releasingAttributes = registeredService.getAttributeReleasePolicy().getAttributes(attributeReleaseContext);
        releasingAttributes.putAll(authentication.getAttributes());
        Map accessStrategyAttributes = CoreAuthenticationUtils.mergeAttributes((Map)authentication.getPrincipal().getAttributes(), (Map)releasingAttributes);
        Principal accessStrategyPrincipal = this.configurationContext.getPrincipalFactory().createPrincipal(authentication.getPrincipal().getId(), accessStrategyAttributes);
        AuditableContext audit = AuditableContext.builder().service(service).principal(accessStrategyPrincipal).registeredService(registeredService).build();
        this.enforceRegisteredServiceAccess(audit);
    }

    protected void enforceRegisteredServiceAccess(AuditableContext audit) throws Throwable {
        AuditableExecutionResult accessResult = this.configurationContext.getRegisteredServiceAccessStrategyEnforcer().execute(audit);
        accessResult.throwExceptionIfNeeded();
    }

    private void enforceRegisteredServiceAccess(Service service, RegisteredService registeredService, Principal principal) throws Throwable {
        AuditableContext audit = AuditableContext.builder().service(service).principal(principal).registeredService(registeredService).build();
        this.enforceRegisteredServiceAccess(audit);
    }

    private void enforceRegisteredServiceAccess(Service service, TicketGrantingTicket ticket, RegisteredService registeredService) throws Throwable {
        AuditableContext audit = AuditableContext.builder().service(service).ticketGrantingTicket(ticket).registeredService(registeredService).build();
        this.enforceRegisteredServiceAccess(audit);
    }

    protected Principal rebuildStatelessTicketPrincipal(ServiceTicket serviceTicket) throws Throwable {
        Authentication authentication = serviceTicket.getAuthentication();
        return this.configurationContext.getPrincipalResolver().resolve((Credential)new BasicIdentifiableCredential(authentication.getPrincipal().getId()), Optional.of(authentication.getPrincipal()), Optional.empty(), Optional.of(serviceTicket.getService()));
    }

    private static Authentication evaluatePossibilityOfMixedPrincipals(AuthenticationResult context, TicketGrantingTicket ticketGrantingTicket) {
        if (context == null) {
            LOGGER.warn("Provided authentication result is undefined to evaluate for mixed principals");
            return null;
        }
        Authentication currentAuthentication = context.getAuthentication();
        if (currentAuthentication != null) {
            Authentication original = ticketGrantingTicket.getAuthentication();
            if (!currentAuthentication.getPrincipal().equals((Object)original.getPrincipal())) {
                throw new MixedPrincipalException(currentAuthentication, currentAuthentication.getPrincipal(), original.getPrincipal());
            }
        }
        return currentAuthentication;
    }
}

