/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.starter.actuate;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.Status;

public class DomainsHealthIndicator
implements HealthIndicator {
    protected static final Logger LOG = LoggerFactory.getLogger(DomainsHealthIndicator.class);
    protected final DomainHolder<?> domainHolder;

    public DomainsHealthIndicator(DomainHolder<?> domainHolder) {
        this.domainHolder = domainHolder;
    }

    public Health health() {
        Health.Builder builder = new Health.Builder();
        AtomicReference<Boolean> anyDown = new AtomicReference<Boolean>(Boolean.FALSE);
        this.domainHolder.getHealthInfo().forEach((domain, status) -> {
            builder.withDetail(domain, (Object)(status != false ? Status.UP : Status.DOWN));
            if (!status.booleanValue()) {
                anyDown.set(true);
            }
        });
        builder.status(anyDown.get() != false ? Status.DOWN : Status.UP);
        return builder.build();
    }
}

