/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.starter;

import java.util.Map;
import org.apache.cxf.spring.boot.autoconfigure.openapi.OpenApiAutoConfiguration;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.keymaster.client.api.DomainOps;
import org.apache.syncope.common.keymaster.client.api.startstop.KeymasterStop;
import org.apache.syncope.common.lib.info.SystemInfo;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.EntityCacheDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotificationDAO;
import org.apache.syncope.core.persistence.api.dao.PersistenceInfoDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.SecurityQuestionDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.provisioning.api.ConnIdBundleManager;
import org.apache.syncope.core.provisioning.api.ConnectorManager;
import org.apache.syncope.core.provisioning.api.ImplementationLookup;
import org.apache.syncope.core.provisioning.api.data.ConnInstanceDataBinder;
import org.apache.syncope.core.starter.SyncopeCoreStart;
import org.apache.syncope.core.starter.SyncopeCoreStop;
import org.apache.syncope.core.starter.TaskExecutorUnloader;
import org.apache.syncope.core.starter.actuate.DefaultSyncopeCoreInfoContributor;
import org.apache.syncope.core.starter.actuate.DomainsHealthIndicator;
import org.apache.syncope.core.starter.actuate.EntityCacheEndpoint;
import org.apache.syncope.core.starter.actuate.ExternalResourcesHealthIndicator;
import org.apache.syncope.core.starter.actuate.SyncopeCoreInfoContributor;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.mail.MailHealthIndicator;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.neo4j.Neo4jDataAutoConfiguration;
import org.springframework.boot.autoconfigure.data.neo4j.Neo4jReactiveDataAutoConfiguration;
import org.springframework.boot.autoconfigure.data.neo4j.Neo4jReactiveRepositoriesAutoConfiguration;
import org.springframework.boot.autoconfigure.data.neo4j.Neo4jRepositoriesAutoConfiguration;
import org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchClientAutoConfiguration;
import org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchRestClientAutoConfiguration;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceTransactionManagerAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.autoconfigure.sql.init.SqlInitializationAutoConfiguration;
import org.springframework.boot.autoconfigure.task.TaskExecutionAutoConfiguration;
import org.springframework.boot.autoconfigure.task.TaskSchedulingAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorMvcAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.event.EventListener;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@SpringBootApplication(exclude={ErrorMvcAutoConfiguration.class, HttpMessageConvertersAutoConfiguration.class, OpenApiAutoConfiguration.class, DataSourceAutoConfiguration.class, DataSourceTransactionManagerAutoConfiguration.class, SqlInitializationAutoConfiguration.class, HibernateJpaAutoConfiguration.class, JdbcTemplateAutoConfiguration.class, Neo4jDataAutoConfiguration.class, Neo4jRepositoriesAutoConfiguration.class, Neo4jReactiveDataAutoConfiguration.class, Neo4jReactiveRepositoriesAutoConfiguration.class, TaskExecutionAutoConfiguration.class, TaskSchedulingAutoConfiguration.class, ElasticsearchRestClientAutoConfiguration.class, ElasticsearchClientAutoConfiguration.class}, proxyBeanMethods=false)
@EnableTransactionManagement
@EnableCaching
public class SyncopeCoreApplication
extends SpringBootServletInitializer {
    public static void main(String[] args) {
        new SpringApplicationBuilder(new Class[]{SyncopeCoreApplication.class}).properties(new String[]{"spring.config.name:core"}).build().run(args);
    }

    protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
        return builder.properties(Map.of("spring.config.name", "core")).sources(new Class[]{SyncopeCoreApplication.class});
    }

    @ConditionalOnMissingBean
    @Bean
    public TaskExecutorUnloader taskExecutorUnloader(ListableBeanFactory beanFactory) {
        return new TaskExecutorUnloader(beanFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public SyncopeCoreStart keymasterStart(DomainHolder<?> domainHolder) {
        return new SyncopeCoreStart(domainHolder);
    }

    @ConditionalOnMissingBean
    @Bean
    public KeymasterStop keymasterStop(DomainHolder<?> domainHolder) {
        return new SyncopeCoreStop(domainHolder);
    }

    @ConditionalOnMissingBean
    @Bean
    public SyncopeCoreInfoContributor syncopeCoreInfoContributor(AnyTypeDAO anyTypeDAO, AnyTypeClassDAO anyTypeClassDAO, ExternalResourceDAO resourceDAO, UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, RoleDAO roleDAO, PolicyDAO policyDAO, NotificationDAO notificationDAO, TaskDAO taskDAO, VirSchemaDAO virSchemaDAO, SecurityQuestionDAO securityQuestionDAO, PersistenceInfoDAO persistenceInfoDAO, ConfParamOps confParamOps, ConnIdBundleManager bundleManager, ImplementationLookup implLookup) {
        return new DefaultSyncopeCoreInfoContributor(anyTypeDAO, anyTypeClassDAO, resourceDAO, userDAO, groupDAO, anyObjectDAO, roleDAO, policyDAO, notificationDAO, taskDAO, virSchemaDAO, securityQuestionDAO, persistenceInfoDAO, confParamOps, bundleManager, implLookup);
    }

    @ConditionalOnMissingBean
    @Bean
    public DomainsHealthIndicator domainsHealthIndicator(DomainHolder<?> domainHolder) {
        return new DomainsHealthIndicator(domainHolder);
    }

    @ConditionalOnMissingBean
    @Bean
    public MailHealthIndicator mailHealthIndicator(JavaMailSender mailSender) {
        return new MailHealthIndicator((JavaMailSenderImpl)mailSender);
    }

    @ConditionalOnClass(name={"org.apache.syncope.core.logic.ResourceLogic"})
    @ConditionalOnMissingBean
    @Bean
    public ExternalResourcesHealthIndicator externalResourcesHealthIndicator(DomainOps domainOps, ExternalResourceDAO resourceDAO, ConnInstanceDataBinder connInstanceDataBinder, ConnectorManager connectorManager) {
        return new ExternalResourcesHealthIndicator(domainOps, resourceDAO, connInstanceDataBinder, connectorManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public EntityCacheEndpoint entityCacheEndpoint(EntityCacheDAO entityCacheDAO) {
        return new EntityCacheEndpoint(entityCacheDAO);
    }

    @Bean
    public SyncopeStarterEventListener syncopeCoreEventListener(@Qualifier(value="syncopeCoreInfoContributor") SyncopeCoreInfoContributor syncopeCoreInfoContributor) {
        return new DefaultSyncopeStarterEventListener(syncopeCoreInfoContributor);
    }

    public static class DefaultSyncopeStarterEventListener
    implements SyncopeStarterEventListener {
        private final SyncopeCoreInfoContributor contributor;

        public DefaultSyncopeStarterEventListener(SyncopeCoreInfoContributor contributor) {
            this.contributor = contributor;
        }

        @Override
        @EventListener
        public void addLoadInstant(PayloadApplicationEvent<SystemInfo.LoadInstant> event) {
            this.contributor.addLoadInstant(event);
        }
    }

    @FunctionalInterface
    public static interface SyncopeStarterEventListener {
        public void addLoadInstant(PayloadApplicationEvent<SystemInfo.LoadInstant> var1);
    }
}

