/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.metadata;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.LiteralStringValueExpr;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.metadata.ConfigurationMetadataClassSourceLocator;
import org.apereo.cas.configuration.metadata.ConfigurationMetadataHint;
import org.apereo.cas.configuration.metadata.ConfigurationMetadataPropertyCreator;
import org.apereo.cas.configuration.metadata.ConfigurationMetadataUnitParser;
import org.apereo.cas.configuration.support.DurationCapable;
import org.apereo.cas.configuration.support.ExpressionLanguageCapable;
import org.apereo.cas.configuration.support.PropertyOwner;
import org.apereo.cas.configuration.support.RegularExpressionCapable;
import org.apereo.cas.configuration.support.RelaxedPropertyNames;
import org.apereo.cas.configuration.support.RequiredProperty;
import org.apereo.cas.configuration.support.RequiresModule;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.Deprecation;
import org.springframework.boot.configurationmetadata.ValueHint;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.ReflectionUtils;

public class ConfigurationMetadataGenerator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationMetadataGenerator.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().setDefaultPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS}).findAndRegisterModules();
    private static final Pattern PATTERN_GENERICS = Pattern.compile(".+\\<(.+)\\>");
    private static final Pattern NESTED_TYPE_PATTERN1 = Pattern.compile("java\\.util\\.\\w+<(org\\.apereo\\.cas\\..+)>");
    private static final Pattern NESTED_TYPE_PATTERN2 = Pattern.compile("java\\.util\\.(List|Set)<(.+Properties)>");
    private static final Pattern MAP_TYPE_STRING_KEY_OBJECT_PATTERN = Pattern.compile("java\\.util\\.Map<java\\.lang\\.String,\\s*(org\\.apereo\\.cas\\..+)>");
    private static final Pattern NESTED_CLASS_PATTERN = Pattern.compile("(.+)\\$(\\w+)");
    private final File inputSpringConfigurationMetadata;
    private final File outputSpringConfigurationMetadata;
    private final File projectDirectory;

    public ConfigurationMetadataGenerator(File inputSpringConfigurationMetadata, File outputSpringConfigurationMetadata) {
        this.inputSpringConfigurationMetadata = inputSpringConfigurationMetadata;
        this.outputSpringConfigurationMetadata = outputSpringConfigurationMetadata;
        this.projectDirectory = inputSpringConfigurationMetadata.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            throw new IllegalArgumentException("Usage: ConfigurationMetadataGenerator <input-file> <output-file>");
        }
        File inputSpringConfigurationMetadata = new File(args[0]);
        File outputSpringConfigurationMetadata = new File(args[1]);
        LOGGER.info("Input configuration file: [{}], Output configuration file [{}]", (Object)inputSpringConfigurationMetadata, (Object)outputSpringConfigurationMetadata);
        ConfigurationMetadataGenerator generator = new ConfigurationMetadataGenerator(inputSpringConfigurationMetadata, outputSpringConfigurationMetadata);
        generator.adjustConfigurationMetadata();
    }

    protected void adjustConfigurationMetadata() throws Exception {
        if (!this.inputSpringConfigurationMetadata.exists()) {
            throw new RuntimeException("Could not locate file " + this.inputSpringConfigurationMetadata.getCanonicalPath());
        }
        LOGGER.info("Project directory [{}]", (Object)this.projectDirectory);
        TypeReference<Map<String, Set<ConfigurationMetadataProperty>>> values = new TypeReference<Map<String, Set<ConfigurationMetadataProperty>>>(this){};
        Map jsonMap = (Map)MAPPER.readValue(this.inputSpringConfigurationMetadata, (TypeReference)values);
        Set properties = (Set)jsonMap.get("properties");
        Set groups = (Set)jsonMap.get("groups");
        this.processMappableProperties(properties, groups);
        this.processNestedTypes(properties, groups);
        Set<ConfigurationMetadataHint> hints = ConfigurationMetadataGenerator.processHints(properties, groups);
        this.processNestedEnumProperties(properties, groups);
        ConfigurationMetadataGenerator.processDeprecatedProperties(properties);
        this.processTopLevelEnumTypes(properties);
        ConfigurationMetadataGenerator.removeNestedConfigurationPropertyGroups(properties, groups);
        jsonMap.put("properties", (Set)properties.parallelStream().sorted(Comparator.comparing(ConfigurationMetadataProperty::getName)).collect(Collectors.toCollection(LinkedHashSet::new)));
        jsonMap.put("groups", (Set)groups.parallelStream().sorted(Comparator.comparing(ConfigurationMetadataProperty::getName)).collect(Collectors.toCollection(LinkedHashSet::new)));
        jsonMap.put("hints", (Set)hints.parallelStream().sorted(Comparator.comparing(ConfigurationMetadataHint::getName)).collect(Collectors.toCollection(LinkedHashSet::new)));
        MAPPER.writerWithDefaultPrettyPrinter().writeValue(this.outputSpringConfigurationMetadata, (Object)jsonMap);
    }

    protected static Set<ConfigurationMetadataHint> processHints(Collection<ConfigurationMetadataProperty> props, Collection<ConfigurationMetadataProperty> groups) {
        LinkedHashSet<ConfigurationMetadataHint> hints = new LinkedHashSet<ConfigurationMetadataHint>(0);
        List<ConfigurationMetadataProperty> allValidProps = props.stream().filter(p -> p.getDeprecation() == null || Deprecation.Level.ERROR != p.getDeprecation().getLevel()).toList();
        for (ConfigurationMetadataProperty entry : allValidProps) {
            String propName = StringUtils.substringAfterLast((String)entry.getName(), (String)".");
            String groupName = StringUtils.substringBeforeLast((String)entry.getName(), (String)".");
            groups.stream().filter(g -> g.getName().equalsIgnoreCase(groupName)).findFirst().ifPresent(grp -> {
                try {
                    Matcher matcher = PATTERN_GENERICS.matcher(grp.getType());
                    String className = matcher.find() ? matcher.group(1) : grp.getType();
                    Class clazz = ClassUtils.getClass((String)className);
                    ConfigurationMetadataHint hint = new ConfigurationMetadataHint();
                    hint.setName(entry.getName());
                    RequiresModule annotation = Arrays.stream(clazz.getAnnotations()).filter(a -> a.annotationType().equals(RequiresModule.class)).findFirst().map(RequiresModule.class::cast).orElseThrow(() -> new RuntimeException(clazz.getCanonicalName() + " is missing @RequiresModule"));
                    ValueHint valueHint = new ValueHint();
                    TreeMap<String, Object> hintsMap = new TreeMap<String, Object>();
                    hintsMap.put("module", annotation.name());
                    hintsMap.put("automated", annotation.automated());
                    valueHint.setValue((Object)ConfigurationMetadataGenerator.toJson(hintsMap));
                    valueHint.setDescription(RequiresModule.class.getName());
                    hint.getValues().add(valueHint);
                    ValueHint grpHint = new ValueHint();
                    grpHint.setValue((Object)ConfigurationMetadataGenerator.toJson(Map.of("owner", clazz.getCanonicalName())));
                    grpHint.setDescription(PropertyOwner.class.getName());
                    hint.getValues().add(grpHint);
                    RelaxedPropertyNames names = RelaxedPropertyNames.forCamelCase(propName);
                    names.getValues().forEach(Unchecked.consumer(name -> {
                        ValueHint propertyHint;
                        Field f = ReflectionUtils.findField((Class)clazz, (String)name);
                        if (f != null && f.isAnnotationPresent(RequiredProperty.class)) {
                            propertyHint = new ValueHint();
                            propertyHint.setValue((Object)ConfigurationMetadataGenerator.toJson(Map.of("owner", clazz.getName())));
                            propertyHint.setDescription(RequiredProperty.class.getName());
                            hint.getValues().add(propertyHint);
                        }
                        if (f != null && f.isAnnotationPresent(DurationCapable.class)) {
                            propertyHint = new ValueHint();
                            propertyHint.setDescription(DurationCapable.class.getName());
                            propertyHint.setValue((Object)ConfigurationMetadataGenerator.toJson(List.of(DurationCapable.class.getName())));
                            hint.getValues().add(propertyHint);
                        }
                        if (f != null && f.isAnnotationPresent(ExpressionLanguageCapable.class)) {
                            propertyHint = new ValueHint();
                            propertyHint.setDescription(ExpressionLanguageCapable.class.getName());
                            propertyHint.setValue((Object)ConfigurationMetadataGenerator.toJson(List.of(ExpressionLanguageCapable.class.getName())));
                            hint.getValues().add(propertyHint);
                        }
                        if (f != null && f.isAnnotationPresent(RegularExpressionCapable.class)) {
                            propertyHint = new ValueHint();
                            propertyHint.setDescription(RegularExpressionCapable.class.getName());
                            propertyHint.setValue((Object)ConfigurationMetadataGenerator.toJson(List.of(RegularExpressionCapable.class.getName())));
                            hint.getValues().add(propertyHint);
                        }
                    }));
                    if (!hint.getValues().isEmpty()) {
                        hints.add(hint);
                    }
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            });
        }
        return hints;
    }

    protected static void processDeprecatedProperties(Set<ConfigurationMetadataProperty> properties) {
        properties.stream().filter(p -> p.getDeprecation() != null).forEach(property -> property.getDeprecation().setLevel(Deprecation.Level.ERROR));
    }

    protected static String toJson(Object value) throws Exception {
        return MAPPER.writeValueAsString(value);
    }

    protected static void removeNestedConfigurationPropertyGroups(Set<ConfigurationMetadataProperty> properties, Set<ConfigurationMetadataProperty> groups) {
        Iterator<ConfigurationMetadataProperty> it = properties.iterator();
        while (it.hasNext()) {
            ConfigurationMetadataProperty entry = it.next();
            try {
                String propName = StringUtils.substringAfterLast((String)entry.getName(), (String)".");
                String groupName = StringUtils.substringBeforeLast((String)entry.getName(), (String)".");
                Optional<ConfigurationMetadataProperty> res = groups.stream().filter(g -> g.getName().equalsIgnoreCase(groupName)).findFirst();
                if (!res.isPresent()) continue;
                ConfigurationMetadataProperty grp = res.get();
                String className = grp.getType();
                Class clazz = ClassUtils.getClass((String)className);
                RelaxedPropertyNames names = RelaxedPropertyNames.forCamelCase(propName);
                names.getValues().forEach(Unchecked.consumer(name -> {
                    Field f = ReflectionUtils.findField((Class)clazz, (String)name);
                    if (f != null && f.isAnnotationPresent(NestedConfigurationProperty.class)) {
                        it.remove();
                    }
                }));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void processMappableProperties(Set<ConfigurationMetadataProperty> properties, Set<ConfigurationMetadataProperty> groups) {
        HashSet collectedProps = new HashSet(0);
        HashSet collectedGroups = new HashSet(0);
        properties.forEach(property -> {
            block3: {
                try {
                    Matcher matcher = MAP_TYPE_STRING_KEY_OBJECT_PATTERN.matcher(property.getType());
                    if (!matcher.matches()) break block3;
                    String valueType = matcher.group(1);
                    String typePath = ConfigurationMetadataClassSourceLocator.buildTypeSourcePath(this.projectDirectory.getCanonicalPath(), valueType);
                    File typeFile = new File(typePath);
                    if (typeFile.exists()) {
                        ConfigurationMetadataUnitParser parser = new ConfigurationMetadataUnitParser(this.projectDirectory.getCanonicalPath());
                        property.setName(property.getName().concat(".[key]"));
                        property.setId(property.getName());
                        parser.parseCompilationUnit(collectedProps, collectedGroups, (ConfigurationMetadataProperty)property, typePath, valueType, false);
                        break block3;
                    }
                    throw new RuntimeException(typePath + " does not exist");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        properties.addAll(collectedProps);
        groups.addAll(collectedGroups);
    }

    protected void processNestedEnumProperties(Set<ConfigurationMetadataProperty> properties, Set<ConfigurationMetadataProperty> groups) throws Exception {
        Set propertiesToProcess = properties.stream().filter(e -> {
            Matcher matcher = NESTED_CLASS_PATTERN.matcher(e.getType());
            return matcher.matches();
        }).collect(Collectors.toSet());
        for (ConfigurationMetadataProperty prop : propertiesToProcess) {
            Matcher matcher = NESTED_CLASS_PATTERN.matcher(prop.getType());
            if (!matcher.matches()) {
                throw new RuntimeException("Unable to find a match for " + prop.getType());
            }
            String parent = matcher.group(1);
            String innerType = matcher.group(2);
            String typePath = ConfigurationMetadataClassSourceLocator.buildTypeSourcePath(this.projectDirectory.getCanonicalPath(), parent);
            try {
                TypeDeclaration primaryType = null;
                if (typePath.contains("$")) {
                    String innerClass = StringUtils.substringBetween((String)typePath, (String)"$", (String)".");
                    typePath = StringUtils.remove((String)typePath, (String)("$" + innerClass));
                    CompilationUnit cu = StaticJavaParser.parse((File)new File(typePath));
                    block3: for (TypeDeclaration type : cu.getTypes()) {
                        for (BodyDeclaration member2 : type.getMembers()) {
                            String name;
                            if (!member2.isClassOrInterfaceDeclaration() || !(name = member2.asClassOrInterfaceDeclaration().getNameAsString()).equals(innerClass)) continue;
                            primaryType = member2.asClassOrInterfaceDeclaration();
                            continue block3;
                        }
                    }
                } else {
                    CompilationUnit cu = StaticJavaParser.parse((File)new File(typePath));
                    primaryType = (TypeDeclaration)cu.getPrimaryType().get();
                }
                Objects.requireNonNull(primaryType).getMembers().stream().peek(member -> {
                    FieldDeclaration fieldDecl;
                    VariableDeclarator variable;
                    if (member.isFieldDeclaration() && (variable = (fieldDecl = member.asFieldDeclaration()).getVariable(0)).getInitializer().isPresent()) {
                        int beginIndex = prop.getName().lastIndexOf(46);
                        String propShortName = beginIndex != -1 ? prop.getName().substring(beginIndex + 1) : prop.getName();
                        Set<String> names = RelaxedPropertyNames.forCamelCase(variable.getNameAsString()).getValues();
                        if (names.contains(propShortName)) {
                            variable.getInitializer().ifPresent(expression -> {
                                Object value = null;
                                if (expression instanceof LiteralStringValueExpr) {
                                    LiteralStringValueExpr expr = (LiteralStringValueExpr)expression;
                                    value = expr.getValue();
                                } else if (expression instanceof BooleanLiteralExpr) {
                                    BooleanLiteralExpr expr = (BooleanLiteralExpr)expression;
                                    value = expr.getValue();
                                } else if (expression instanceof FieldAccessExpr) {
                                    FieldAccessExpr expr = (FieldAccessExpr)expression;
                                    value = expr.getNameAsString();
                                }
                                prop.setDefaultValue(value);
                            });
                        }
                    }
                }).filter(member -> {
                    if (member.isEnumDeclaration()) {
                        EnumDeclaration enumMem = member.asEnumDeclaration();
                        return enumMem.getNameAsString().equals(innerType);
                    }
                    if (member.isClassOrInterfaceDeclaration()) {
                        ClassOrInterfaceDeclaration typeName = member.asClassOrInterfaceDeclaration();
                        return typeName.getNameAsString().equals(innerType);
                    }
                    return false;
                }).forEach(member -> {
                    if (member.isEnumDeclaration()) {
                        EnumDeclaration enumMem = member.asEnumDeclaration();
                        StringBuilder builder = ConfigurationMetadataPropertyCreator.collectJavadocsEnumFields(prop, enumMem);
                        prop.setDescription(builder.toString());
                    }
                    if (member.isClassOrInterfaceDeclaration()) {
                        ClassOrInterfaceDeclaration typeName = member.asClassOrInterfaceDeclaration();
                        typeName.getFields().stream().filter(field -> !field.isStatic()).forEach(field -> {
                            HashSet<ConfigurationMetadataProperty> resultProps = new HashSet<ConfigurationMetadataProperty>();
                            HashSet<ConfigurationMetadataProperty> resultGroups = new HashSet<ConfigurationMetadataProperty>();
                            ConfigurationMetadataPropertyCreator creator = new ConfigurationMetadataPropertyCreator(false, resultProps, resultGroups, parent);
                            creator.createConfigurationProperty((FieldDeclaration)field, prop.getName());
                            groups.addAll(resultGroups);
                            properties.addAll(resultProps);
                        });
                    }
                });
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected void processTopLevelEnumTypes(Set<ConfigurationMetadataProperty> properties) throws Exception {
        for (ConfigurationMetadataProperty property : properties) {
            Optional<Class<?>> clazz;
            String typePath = ConfigurationMetadataClassSourceLocator.buildTypeSourcePath(this.projectDirectory.getCanonicalPath(), property.getType());
            File typeFile = new File(typePath);
            if (!typeFile.exists() && !property.getType().contains(".") && (clazz = ConfigurationMetadataClassSourceLocator.findClassBySimpleNameInPackage(property.getType(), "org.apereo.cas")).isPresent()) {
                typePath = ConfigurationMetadataClassSourceLocator.buildTypeSourcePath(this.projectDirectory.getCanonicalPath(), clazz.get().getName());
                typeFile = new File(typePath);
            }
            if (!typeFile.exists()) continue;
            CompilationUnit cu = StaticJavaParser.parse((File)new File(typePath));
            for (TypeDeclaration type : cu.getTypes()) {
                if (!type.isEnumDeclaration()) continue;
                EnumDeclaration enumMem = type.asEnumDeclaration();
                StringBuilder builder = ConfigurationMetadataPropertyCreator.collectJavadocsEnumFields(property, enumMem);
                property.setDescription(builder.toString());
            }
        }
    }

    protected void processNestedTypes(Set<ConfigurationMetadataProperty> properties, Set<ConfigurationMetadataProperty> groups) {
        HashSet collectedProps = new HashSet(0);
        HashSet collectedGroups = new HashSet(0);
        LOGGER.trace("Processing nested configuration types...");
        properties.forEach(Unchecked.consumer(p -> {
            boolean indexBrackets = false;
            String typeName = "";
            if (NESTED_TYPE_PATTERN1.matcher(p.getType()).matches()) {
                matcher = NESTED_TYPE_PATTERN1.matcher(p.getType());
                indexBrackets = matcher.matches();
                typeName = matcher.group(1);
            } else if (NESTED_TYPE_PATTERN2.matcher(p.getType()).matches()) {
                matcher = NESTED_TYPE_PATTERN2.matcher(p.getType());
                indexBrackets = matcher.matches();
                typeName = matcher.group(2);
                Optional<Class<?>> result = ConfigurationMetadataClassSourceLocator.findClassBySimpleNameInPackage(typeName, "org.apereo.cas");
                if (result.isPresent()) {
                    typeName = result.get().getName();
                }
            }
            if (!typeName.isEmpty()) {
                String typePath = ConfigurationMetadataClassSourceLocator.buildTypeSourcePath(this.projectDirectory.getCanonicalPath(), typeName);
                LOGGER.debug("Matched Type [{}], Property [{}], Type: [{}], Path [{}]", new Object[]{typeName, p.getName(), p.getType(), typePath});
                ConfigurationMetadataUnitParser parser = new ConfigurationMetadataUnitParser(this.projectDirectory.getCanonicalPath());
                parser.parseCompilationUnit(collectedProps, collectedGroups, (ConfigurationMetadataProperty)p, typePath, typeName, indexBrackets);
            }
        }));
        properties.addAll(collectedProps);
        groups.addAll(collectedGroups);
    }
}

