/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.MediaType;
import jakarta.xml.ws.WebServiceException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.client.enduser.SyncopeWebApplication;
import org.apache.syncope.client.lib.SyncopeAnonymousClient;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.lib.SyncopeClientFactoryBean;
import org.apache.syncope.client.ui.commons.BaseSession;
import org.apache.syncope.client.ui.commons.DateOps;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.info.PlatformInfo;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.wicket.Session;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.request.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncopeEnduserSession
extends AuthenticatedWebSession
implements BaseSession {
    private static final long serialVersionUID = 747562246415852166L;
    protected static final Logger LOG = LoggerFactory.getLogger(SyncopeEnduserSession.class);
    protected final SyncopeClientFactoryBean clientFactory;
    protected final Map<Class<?>, Object> services = Collections.synchronizedMap(new HashMap());
    protected String domain;
    protected SyncopeClient client;
    protected SyncopeAnonymousClient anonymousClient;
    protected UserTO selfTO;

    public static SyncopeEnduserSession get() {
        return (SyncopeEnduserSession)Session.get();
    }

    public SyncopeEnduserSession(Request request) {
        super(request);
        this.clientFactory = SyncopeWebApplication.get().newClientFactory();
    }

    protected String message(SyncopeClientException sce) {
        Error error = null;
        if (sce.getType() == ClientExceptionType.InvalidSecurityAnswer) {
            error = Error.INVALID_SECURITY_ANSWER;
        }
        if (error == null) {
            return sce.getType().name() + ": " + sce.getElements().stream().collect(Collectors.joining(", "));
        }
        return this.getApplication().getResourceSettings().getLocalizer().getString(error.key(), null, null, null, null, error.fallback());
    }

    public void onException(Exception e) {
        Throwable root = ExceptionUtils.getRootCause((Throwable)e);
        String message = root.getMessage();
        if (root instanceof SyncopeClientException) {
            SyncopeClientException sce = (SyncopeClientException)root;
            message = sce.isComposite() ? sce.asComposite().getExceptions().stream().map(this::message).collect(Collectors.joining("; ")) : this.message(sce);
        } else if (root instanceof NotAuthorizedException || root instanceof ForbiddenException) {
            Error error = StringUtils.containsIgnoreCase((CharSequence)message, (CharSequence)"expired") ? Error.SESSION_EXPIRED : Error.AUTHORIZATION;
            message = this.getApplication().getResourceSettings().getLocalizer().getString(error.key(), null, null, null, null, error.fallback());
        } else if (root instanceof BadRequestException || root instanceof WebServiceException) {
            message = this.getApplication().getResourceSettings().getLocalizer().getString(Error.REST.key(), null, null, null, null, Error.REST.fallback());
        }
        message = this.getApplication().getResourceSettings().getLocalizer().getString(message, null, null, null, null, message);
        this.error((Serializable)((Object)message));
    }

    public MediaType getMediaType() {
        return this.clientFactory.getContentType().getMediaType();
    }

    public <T> Future<T> execute(Callable<T> command) {
        try {
            return CompletableFuture.completedFuture(command.call());
        }
        catch (Exception e) {
            LOG.error("Could not execute {}", command, (Object)e);
            return new CompletableFuture();
        }
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return StringUtils.isBlank((CharSequence)this.domain) ? "Master" : this.domain;
    }

    public String getJWT() {
        return this.client == null ? null : this.client.getJWT();
    }

    public Roles getRoles() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PlatformInfo getPlatformInfo() {
        return this.getAnonymousClient().platform();
    }

    public boolean authenticate(String username, String password) {
        boolean authenticated = false;
        if (SyncopeWebApplication.get().getAdminUser().equalsIgnoreCase(username)) {
            return authenticated;
        }
        try {
            this.client = this.clientFactory.setDomain(this.getDomain()).create(username, password);
            this.refreshAuth(username);
            authenticated = true;
        }
        catch (Exception e) {
            LOG.error("Authentication failed", (Throwable)e);
        }
        return authenticated;
    }

    public boolean authenticate(String jwt) {
        boolean authenticated = false;
        try {
            this.client = this.clientFactory.setDomain(this.getDomain()).create(jwt);
            this.refreshAuth(null);
            authenticated = true;
        }
        catch (Exception e) {
            LOG.error("Authentication failed", (Throwable)e);
        }
        return authenticated;
    }

    protected void refreshAuth(String username) {
        try {
            this.anonymousClient = SyncopeWebApplication.get().newAnonymousClient(this.getDomain());
            this.selfTO = (UserTO)this.client.self().getRight();
        }
        catch (ForbiddenException e) {
            LOG.warn("Could not read self(), probably in a {} scenario", (Object)"MUST_CHANGE_PASSWORD", (Object)e);
            this.selfTO = new UserTO();
            this.selfTO.setUsername(username);
            this.selfTO.setMustChangePassword(true);
        }
        this.bind();
    }

    protected boolean isAuthenticated() {
        return this.client != null && this.client.getJWT() != null;
    }

    protected boolean isMustChangePassword() {
        return this.selfTO != null && this.selfTO.isMustChangePassword();
    }

    public void cleanup() {
        this.anonymousClient = null;
        this.client = null;
        this.selfTO = null;
        this.services.clear();
    }

    public void invalidate() {
        if (this.isAuthenticated()) {
            try {
                this.client.logout();
            }
            catch (Exception e) {
                LOG.debug("Unexpected exception while logging out", (Throwable)e);
            }
            finally {
                this.client = null;
                this.selfTO = null;
            }
        }
        super.invalidate();
    }

    public UserTO getSelfTO() {
        return this.getSelfTO(false);
    }

    public UserTO getSelfTO(boolean reload) {
        if (reload) {
            this.refreshAuth(this.selfTO.getUsername());
        }
        return this.selfTO;
    }

    public SyncopeAnonymousClient getAnonymousClient() {
        return Optional.ofNullable(this.anonymousClient).orElseGet(() -> SyncopeWebApplication.get().newAnonymousClient(this.getDomain()));
    }

    public <T> T getAnonymousService(Class<T> serviceClass) {
        return (T)this.getAnonymousClient().getService(serviceClass);
    }

    private <T> T getCachedService(Class<T> serviceClass) {
        Object service;
        if (this.services.containsKey(serviceClass)) {
            service = this.services.get(serviceClass);
        } else {
            service = this.client.getService(serviceClass);
            this.services.put(serviceClass, service);
        }
        WebClient.client((Object)service).type("application/json").accept(new String[]{"application/json"});
        return (T)service;
    }

    public <T> T getService(Class<T> serviceClass) {
        Object service = this.client == null || !this.isAuthenticated() ? this.getAnonymousClient().getService(serviceClass) : this.client.getService(serviceClass);
        WebClient.client((Object)service).header("X-Syncope-Domain", new Object[]{this.getDomain()});
        return (T)service;
    }

    public <T> T getService(String etag, Class<T> serviceClass) {
        T serviceInstance = this.getService(serviceClass);
        WebClient.client(serviceInstance).match(new EntityTag(etag), false).type("application/json").accept(new String[]{"application/json"});
        return serviceInstance;
    }

    public <T> void resetClient(Class<T> service) {
        T serviceInstance = this.getCachedService(service);
        WebClient.client(serviceInstance).reset();
    }

    public DateOps.Format getDateFormat() {
        return new DateOps.Format(FastDateFormat.getDateTimeInstance((int)3, (int)3, (Locale)this.getLocale()));
    }

    public static enum Error {
        INVALID_SECURITY_ANSWER("invalid.security.answer", "Invalid Security Answer"),
        SESSION_EXPIRED("error.session.expired", "Session expired: please login again"),
        AUTHORIZATION("error.authorization", "Insufficient access rights when performing the requested operation"),
        REST("error.rest", "There was an error while contacting the Core server");

        private final String key;
        private final String fallback;

        private Error(String key, String fallback) {
            this.key = key;
            this.fallback = fallback;
        }

        public String key() {
            return this.key;
        }

        public String fallback() {
            return this.fallback;
        }
    }
}

