/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class PasswordManagementCaptchaWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    public PasswordManagementCaptchaWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
        if (flow != null && pm.getCore().isEnabled() && pm.getGoogleRecaptcha().isEnabled()) {
            flow.getStartActionList().add((Action)this.createEvaluateAction("passwordResetInitializeCaptchaAction"));
            this.prependActionsToActionStateExecutionList(flow, "sendPasswordResetInstructions", new Object[]{"passwordResetValidateCaptchaAction"});
            this.createTransitionForState(flow, "sendPasswordResetInstructions", "captchaError", "casResetPasswordSendInstructionsView");
        }
    }
}

