/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.cookie;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import org.apereo.cas.web.cookie.CookieSameSitePolicy;

public interface CookieValueManager
extends Serializable {
    public static final String BEAN_NAME = "cookieValueManager";

    public static CookieValueManager noOp() {
        return new NoOpCookieValueManager();
    }

    public String buildCookieValue(String var1, HttpServletRequest var2);

    default public String obtainCookieValue(Cookie cookie, HttpServletRequest request) {
        return this.obtainCookieValue(cookie.getValue(), request);
    }

    public String obtainCookieValue(String var1, HttpServletRequest var2);

    public CookieSameSitePolicy getCookieSameSitePolicy();

    public static class NoOpCookieValueManager
    implements CookieValueManager {
        private static final long serialVersionUID = 5776311151053397600L;

        @Override
        public String buildCookieValue(String givenCookieValue, HttpServletRequest request) {
            return givenCookieValue;
        }

        @Override
        public String obtainCookieValue(String cookie, HttpServletRequest request) {
            return cookie;
        }

        @Override
        public CookieSameSitePolicy getCookieSameSitePolicy() {
            return CookieSameSitePolicy.off();
        }
    }
}

