/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.events.listener;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apereo.cas.config.CasConfigurationModifiedEvent;
import org.apereo.cas.configuration.CasConfigurationPropertiesEnvironmentManager;
import org.apereo.cas.support.events.listener.CasConfigurationEventListener;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public class DefaultCasConfigurationEventListener
implements CasConfigurationEventListener {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasConfigurationEventListener.class);
    private final CasConfigurationPropertiesEnvironmentManager configurationPropertiesEnvironmentManager;
    private final ConfigurationPropertiesBindingPostProcessor binder;
    private final ContextRefresher contextRefresher;
    private final ApplicationContext applicationContext;

    @Override
    public void onRefreshScopeRefreshed(RefreshScopeRefreshedEvent event) {
        LOGGER.info("Refreshing application context beans eagerly...");
        this.initializeBeansEagerly();
    }

    @Override
    public void onEnvironmentChangedEvent(EnvironmentChangeEvent event) {
        LOGGER.trace("Received event [{}]", (Object)event);
        this.rebind();
    }

    @Override
    public void handleConfigurationModifiedEvent(CasConfigurationModifiedEvent event) {
        if (event.isEligibleForContextRefresh()) {
            LOGGER.info("Received event [{}]. Refreshing CAS configuration...", (Object)event);
            Set keys = this.contextRefresher.refresh();
            LOGGER.info("Refreshed the following settings: [{}].", (Object)keys);
            this.rebind();
            LOGGER.info("CAS finished rebinding configuration with new settings [{}]", ObjectUtils.defaultIfNull((Object)keys, new ArrayList(0)));
        }
    }

    private void initializeBeansEagerly() {
        FunctionUtils.doAndHandle(__ -> {
            for (String beanName : this.applicationContext.getBeanDefinitionNames()) {
                Objects.requireNonNull(this.applicationContext.getBean(beanName).getClass());
            }
            if (this.applicationContext.containsBean("dispatcherServlet")) {
                DispatcherServlet servlet = (DispatcherServlet)this.applicationContext.getBean(DispatcherServlet.class);
                servlet.setApplicationContext(this.applicationContext);
                servlet.init();
            }
        });
    }

    private void rebind() {
        LOGGER.info("Refreshing CAS configuration. Stand by...");
        ApplicationContext ctx = (ApplicationContext)FunctionUtils.doIfNotNull((Object)this.configurationPropertiesEnvironmentManager, () -> this.configurationPropertiesEnvironmentManager.rebindCasConfigurationProperties(this.applicationContext), () -> CasConfigurationPropertiesEnvironmentManager.rebindCasConfigurationProperties((ConfigurationPropertiesBindingPostProcessor)this.binder, (ApplicationContext)this.applicationContext)).get();
        Objects.requireNonNull(ctx);
        this.initializeBeansEagerly();
    }

    @Generated
    public DefaultCasConfigurationEventListener(CasConfigurationPropertiesEnvironmentManager configurationPropertiesEnvironmentManager, ConfigurationPropertiesBindingPostProcessor binder, ContextRefresher contextRefresher, ApplicationContext applicationContext) {
        this.configurationPropertiesEnvironmentManager = configurationPropertiesEnvironmentManager;
        this.binder = binder;
        this.contextRefresher = contextRefresher;
        this.applicationContext = applicationContext;
    }
}

