/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.claims;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface OidcAttributeToScopeClaimMapper {
    public static final Logger LOGGER = LoggerFactory.getLogger(OidcAttributeToScopeClaimMapper.class);
    public static final String DEFAULT_BEAN_NAME = "oidcAttributeToScopeClaimMapper";

    public String getMappedAttribute(String var1, RegisteredService var2);

    public boolean containsMappedAttribute(String var1, RegisteredService var2);

    default public String toMappedClaimName(String claimName, RegisteredService registeredService) {
        return this.containsMappedAttribute(claimName, registeredService) ? this.getMappedAttribute(claimName, registeredService) : claimName;
    }

    default public List<Object> mapClaim(String claimName, RegisteredService registeredService, Principal principal, Object defaultValue) {
        String attribute = this.toMappedClaimName(claimName, registeredService);
        Object attributeValues = principal.getAttributes().containsKey(attribute) ? principal.getAttributes().get(attribute) : defaultValue;
        LOGGER.trace("Handling claim [{}] with value(s) [{}]", (Object)attribute, attributeValues);
        return CollectionUtils.toCollection((Object)attributeValues).stream().map(value -> {
            if (value instanceof Boolean) {
                return value;
            }
            String valueContent = value.toString();
            if (valueContent.equalsIgnoreCase(Boolean.FALSE.toString()) || valueContent.equalsIgnoreCase(Boolean.TRUE.toString())) {
                return BooleanUtils.toBoolean((String)valueContent);
            }
            return value;
        }).collect(Collectors.toCollection(ArrayList::new));
    }
}

