/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.claims;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.oidc.claims.OidcAttributeToScopeClaimMapper;
import org.apereo.cas.oidc.claims.OidcRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.AbstractRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.apereo.cas.util.scripting.ScriptResourceCacheManager;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public abstract class BaseOidcScopeAttributeReleasePolicy
extends AbstractRegisteredServiceAttributeReleasePolicy
implements OidcRegisteredServiceAttributeReleasePolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseOidcScopeAttributeReleasePolicy.class);
    private static final long serialVersionUID = -7302163334687300920L;
    @JsonProperty
    private List<String> allowedAttributes;
    @JsonProperty(value="claimMappings")
    private Map<String, String> claimMappings = new TreeMap<String, String>();
    @JsonIgnore
    private String scopeType;

    protected BaseOidcScopeAttributeReleasePolicy(String scopeType) {
        this.scopeType = scopeType;
    }

    protected Optional<String> getMappedClaim(String claim, RegisteredServiceAttributeReleasePolicyContext context) {
        OidcAttributeToScopeClaimMapper mapper = (OidcAttributeToScopeClaimMapper)context.getApplicationContext().getBean("oidcAttributeToScopeClaimMapper", OidcAttributeToScopeClaimMapper.class);
        LOGGER.debug("Attempting to process claim [{}]", (Object)claim);
        return mapper.containsMappedAttribute(claim, context.getRegisteredService()) ? Optional.of(mapper.getMappedAttribute(claim, context.getRegisteredService())) : Optional.empty();
    }

    protected Pair<String, Object> mapClaimToAttribute(String claim, RegisteredServiceAttributeReleasePolicyContext context, Map<String, List<Object>> resolvedAttributes) throws Throwable {
        Optional<String> mappedClaimResult = this.getMappedClaim(claim, context);
        if (mappedClaimResult.isPresent()) {
            String mappedAttr = mappedClaimResult.get();
            LOGGER.trace("Attribute [{}] is mapped to claim [{}]", (Object)mappedAttr, (Object)claim);
            Optional scriptFactoryInstance = ExecutableCompiledScriptFactory.findExecutableCompiledScriptFactory();
            if (scriptFactoryInstance.isPresent() && ((ExecutableCompiledScriptFactory)scriptFactoryInstance.get()).isInlineScript(mappedAttr)) {
                String script = (String)((ExecutableCompiledScriptFactory)scriptFactoryInstance.get()).getInlineScript(mappedAttr).orElseThrow();
                LOGGER.trace("Locating attribute value via script [{}] for definition [{}]", (Object)script, (Object)claim);
                try (ScriptResourceCacheManager cacheManager = (ScriptResourceCacheManager)ApplicationContextProvider.getScriptResourceCacheManager().orElseThrow(() -> new IllegalArgumentException("No groovy script cache manager is available to execute claim mappings"));){
                    ExecutableCompiledScript scriptResource = cacheManager.resolveScriptableResource(script, new String[]{mappedAttr});
                    Map<String, Logger> args = Map.of("attributes", resolvedAttributes, "context", context, "logger", LOGGER);
                    scriptResource.setBinding(args);
                    Object result = scriptResource.execute(args.values().toArray(), Object.class);
                    LOGGER.debug("Mapped attribute [{}] to [{}] from script", (Object)claim, result);
                    Pair pair = Pair.of((Object)claim, (Object)result);
                    return pair;
                }
            }
            if (resolvedAttributes.containsKey(mappedAttr)) {
                List<Object> value = resolvedAttributes.get(mappedAttr);
                LOGGER.debug("Found mapped attribute [{}] with value [{}] for claim [{}]", new Object[]{mappedAttr, value, claim});
                return Pair.of((Object)claim, value);
            }
            if (resolvedAttributes.containsKey(claim)) {
                List<Object> value = resolvedAttributes.get(claim);
                LOGGER.debug("CAS is unable to find the attribute [{}] that is mapped to claim [{}]. However, since resolved attributes [{}] already contain this claim, CAS will use [{}] with value(s) [{}]", new Object[]{mappedAttr, claim, resolvedAttributes, claim, value});
                return Pair.of((Object)claim, value);
            }
            LOGGER.warn("Located claim [{}] mapped to attribute [{}], yet resolved attributes [{}] do not contain attribute [{}]", new Object[]{claim, mappedAttr, resolvedAttributes, mappedAttr});
        }
        List<Object> value = resolvedAttributes.get(claim);
        LOGGER.debug("No mapped attribute is defined for claim [{}]; Used [{}] to locate value [{}]", new Object[]{claim, claim, value});
        return Pair.of((Object)claim, value);
    }

    public Map<String, List<Object>> getAttributesInternal(RegisteredServiceAttributeReleasePolicyContext context, Map<String, List<Object>> attributes) {
        TreeMap<String, List<Object>> resolvedAttributes = new TreeMap<String, List<Object>>(String.CASE_INSENSITIVE_ORDER);
        resolvedAttributes.putAll(attributes);
        HashMap<String, List<Object>> attributesToRelease = new HashMap<String, List<Object>>(attributes.size());
        LOGGER.debug("Attempting to map and filter claims based on resolved attributes [{}]", resolvedAttributes);
        LinkedHashSet<String> allowedClaims = new LinkedHashSet<String>(this.getAllowedAttributes());
        if (this.claimsMustBeDefinedViaDiscovery()) {
            ApplicationContext applicationContext = ApplicationContextProvider.getApplicationContext();
            if (applicationContext == null) {
                LOGGER.warn("Could not locate the application context to process attributes and claims");
                return new HashMap<String, List<Object>>(0);
            }
            CasConfigurationProperties properties = (CasConfigurationProperties)applicationContext.getBean(CasConfigurationProperties.class);
            List supportedClaims = properties.getAuthn().getOidc().getDiscovery().getClaims();
            allowedClaims.retainAll(supportedClaims);
            LOGGER.debug("[{}] is designed to allow claims [{}] for scope [{}]. After cross-checking with supported claims [{}], the final collection of allowed attributes is [{}]", new Object[]{this.getClass().getSimpleName(), this.getAllowedAttributes(), this.getScopeType(), supportedClaims, allowedClaims});
        } else {
            LOGGER.debug("[{}] is designed to allow claims [{}].", (Object)this.getClass().getSimpleName(), allowedClaims);
        }
        allowedClaims.stream().map(Unchecked.function(claim -> this.mapClaimToAttribute((String)claim, context, (Map<String, List<Object>>)resolvedAttributes))).filter(p -> Objects.nonNull(p.getValue())).forEach(p -> attributesToRelease.put((String)p.getKey(), (List)CollectionUtils.toCollection((Object)p.getValue(), ArrayList.class)));
        return attributesToRelease;
    }

    public List<String> determineRequestedAttributeDefinitions(RegisteredServiceAttributeReleasePolicyContext context) {
        ArrayList attributes = this.getAllowedAttributes();
        return attributes != null ? attributes : new ArrayList();
    }

    @JsonIgnore
    protected boolean claimsMustBeDefinedViaDiscovery() {
        return true;
    }

    @Generated
    public String toString() {
        return "BaseOidcScopeAttributeReleasePolicy(super=" + super.toString() + ", allowedAttributes=" + String.valueOf(this.allowedAttributes) + ", claimMappings=" + String.valueOf(this.claimMappings) + ", scopeType=" + this.scopeType + ")";
    }

    @Override
    @Generated
    public List<String> getAllowedAttributes() {
        return this.allowedAttributes;
    }

    @Override
    @Generated
    public Map<String, String> getClaimMappings() {
        return this.claimMappings;
    }

    @Override
    @Generated
    public String getScopeType() {
        return this.scopeType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseOidcScopeAttributeReleasePolicy)) {
            return false;
        }
        BaseOidcScopeAttributeReleasePolicy other = (BaseOidcScopeAttributeReleasePolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$allowedAttributes = this.allowedAttributes;
        List<String> other$allowedAttributes = other.allowedAttributes;
        if (this$allowedAttributes == null ? other$allowedAttributes != null : !((Object)this$allowedAttributes).equals(other$allowedAttributes)) {
            return false;
        }
        Map<String, String> this$claimMappings = this.claimMappings;
        Map<String, String> other$claimMappings = other.claimMappings;
        if (this$claimMappings == null ? other$claimMappings != null : !((Object)this$claimMappings).equals(other$claimMappings)) {
            return false;
        }
        String this$scopeType = this.scopeType;
        String other$scopeType = other.scopeType;
        return !(this$scopeType == null ? other$scopeType != null : !this$scopeType.equals(other$scopeType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseOidcScopeAttributeReleasePolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $allowedAttributes = this.allowedAttributes;
        result = result * 59 + ($allowedAttributes == null ? 43 : ((Object)$allowedAttributes).hashCode());
        Map<String, String> $claimMappings = this.claimMappings;
        result = result * 59 + ($claimMappings == null ? 43 : ((Object)$claimMappings).hashCode());
        String $scopeType = this.scopeType;
        result = result * 59 + ($scopeType == null ? 43 : $scopeType.hashCode());
        return result;
    }

    @JsonProperty
    @Generated
    public void setAllowedAttributes(List<String> allowedAttributes) {
        this.allowedAttributes = allowedAttributes;
    }

    @JsonProperty(value="claimMappings")
    @Generated
    public void setClaimMappings(Map<String, String> claimMappings) {
        this.claimMappings = claimMappings;
    }

    @JsonIgnore
    @Generated
    public void setScopeType(String scopeType) {
        this.scopeType = scopeType;
    }
}

