/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.ExternalWorkerServiceTask;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.interceptor.CreateExternalWorkerJobAfterContext;
import org.flowable.engine.interceptor.CreateExternalWorkerJobBeforeContext;
import org.flowable.engine.interceptor.CreateExternalWorkerJobInterceptor;
import org.flowable.job.service.JobService;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntity;

public class ExternalWorkerTaskActivityBehavior
extends TaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected ExternalWorkerServiceTask externalWorkerServiceTask;
    protected Expression jobTopicExpression;
    protected Expression skipExpression;
    protected boolean exclusive;

    public ExternalWorkerTaskActivityBehavior(ExternalWorkerServiceTask externalWorkerServiceTask, Expression jobTopicExpression, Expression skipExpression) {
        this.externalWorkerServiceTask = externalWorkerServiceTask;
        this.jobTopicExpression = jobTopicExpression;
        this.skipExpression = skipExpression;
        this.exclusive = externalWorkerServiceTask.isExclusive();
    }

    @Override
    public void execute(DelegateExecution execution) {
        FlowElement currentFlowElement;
        String elementId;
        boolean isSkipExpressionEnabled;
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        String skipExpressionText = null;
        if (this.skipExpression != null) {
            skipExpressionText = this.skipExpression.getExpressionText();
        }
        if (!(isSkipExpressionEnabled = SkipExpressionUtil.isSkipExpressionEnabled(skipExpressionText, elementId = (currentFlowElement = execution.getCurrentFlowElement()).getId(), execution, commandContext)) || !SkipExpressionUtil.shouldSkipFlowElement(skipExpressionText, elementId, execution, commandContext)) {
            Expression jobTopicExpression;
            Object topicValue;
            Expression categoryExpression;
            Object categoryValue;
            CreateExternalWorkerJobInterceptor interceptor = CommandContextUtil.getProcessEngineConfiguration(commandContext).getCreateExternalWorkerJobInterceptor();
            CreateExternalWorkerJobBeforeContext beforeContext = new CreateExternalWorkerJobBeforeContext(this.externalWorkerServiceTask, execution, this.getJobCategory(currentFlowElement));
            if (interceptor != null) {
                interceptor.beforeCreateExternalWorkerJob(beforeContext);
            }
            ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
            JobServiceConfiguration jobServiceConfiguration = processEngineConfiguration.getJobServiceConfiguration();
            JobService jobService = jobServiceConfiguration.getJobService();
            ExternalWorkerJobEntity job = jobService.createExternalWorkerJob();
            job.setExecutionId(execution.getId());
            job.setProcessInstanceId(execution.getProcessInstanceId());
            job.setProcessDefinitionId(execution.getProcessDefinitionId());
            job.setElementId(elementId);
            job.setElementName(currentFlowElement.getName());
            job.setJobHandlerType("external-worker-complete");
            job.setExclusive(this.exclusive);
            if (StringUtils.isNotEmpty((CharSequence)beforeContext.getJobCategory()) && (categoryValue = (categoryExpression = processEngineConfiguration.getExpressionManager().createExpression(beforeContext.getJobCategory())).getValue((VariableContainer)execution)) != null) {
                job.setCategory(categoryValue.toString());
            }
            job.setJobType("externalWorker");
            job.setRetries(jobServiceConfiguration.getAsyncExecutorNumberOfRetries());
            if (execution.getTenantId() != null) {
                job.setTenantId(execution.getTenantId());
            }
            if ((topicValue = (jobTopicExpression = StringUtils.isEmpty((CharSequence)beforeContext.getJobTopicExpression()) ? this.jobTopicExpression : processEngineConfiguration.getExpressionManager().createExpression(beforeContext.getJobTopicExpression())).getValue((VariableContainer)execution)) == null || topicValue.toString().isEmpty()) {
                throw new FlowableException("Expression " + jobTopicExpression + " did not evaluate to a valid value (non empty String). Was: " + topicValue + ". For " + execution);
            }
            job.setJobHandlerConfiguration(topicValue.toString());
            jobService.insertExternalWorkerJob(job);
            if (interceptor != null) {
                interceptor.afterCreateExternalWorkerJob(new CreateExternalWorkerJobAfterContext((ExternalWorkerServiceTask)currentFlowElement, job, execution));
            }
        } else {
            this.leave(execution);
        }
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        this.leave(execution);
    }

    protected String getJobCategory(FlowElement flowElement) {
        List jobCategoryElements = (List)flowElement.getExtensionElements().get("jobCategory");
        if (jobCategoryElements != null && jobCategoryElements.size() > 0) {
            return ((ExtensionElement)jobCategoryElements.get(0)).getElementText();
        }
        return null;
    }
}

