/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.profile.definition;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.factory.ProfileFactory;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProfileDefinition {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String profileId = null;
    private final List<String> primaryAttributes = new ArrayList<String>();
    private final List<String> secondaryAttributes = new ArrayList<String>();
    private final Map<String, AttributeConverter> converters = new HashMap<String, AttributeConverter>();
    private ProfileFactory profileFactory = parameters -> new CommonProfile();
    private boolean restoreProfileFromTypedId = false;

    public UserProfile newProfile(Object ... parameters) {
        Object typedId;
        if (this.restoreProfileFromTypedId && (typedId = this.getParameter(parameters, 0)) instanceof String) {
            String sTypedId = (String)typedId;
            this.logger.debug("Building user profile based on typedId: {}", typedId);
            if (sTypedId.contains("#")) {
                String profileClass = CommonHelper.substringBefore(sTypedId, "#");
                for (String profileClassPrefix : ProfileHelper.getProfileClassPrefixes()) {
                    if (!profileClass.startsWith(profileClassPrefix)) continue;
                    try {
                        return ProfileHelper.buildUserProfileByClassCompleteName(profileClass);
                    }
                    catch (TechnicalException e) {
                        this.logger.error("Cannot build instance for class name: {}", (Object)profileClass, (Object)e);
                    }
                }
            }
        }
        return (UserProfile)this.profileFactory.apply(parameters);
    }

    protected Object getParameter(Object[] parameters, int num) {
        if (parameters != null && parameters.length >= num) {
            return parameters[num];
        }
        return null;
    }

    public void convertAndAdd(UserProfile profile, AttributeLocation attributeLocation, String name, Object value) {
        if (value != null) {
            Object convertedValue;
            AttributeConverter converter = this.converters.get(name);
            if (converter != null) {
                convertedValue = converter.convert(value);
                if (convertedValue != null) {
                    this.logger.debug("converted to => key: {} / value: {} / {}", new Object[]{name, convertedValue, convertedValue.getClass()});
                }
            } else {
                convertedValue = value;
                this.logger.debug("no conversion => key: {} / value: {} / {}", new Object[]{name, convertedValue, convertedValue.getClass()});
            }
            if (attributeLocation.equals((Object)AttributeLocation.AUTHENTICATION_ATTRIBUTE)) {
                profile.addAuthenticationAttribute(name, convertedValue);
            } else {
                profile.addAttribute(name, convertedValue);
            }
        }
    }

    public void convertAndAdd(UserProfile profile, Map<String, Object> profileAttributes, Map<String, Object> authenticationAttributes) {
        if (profileAttributes != null) {
            profileAttributes.entrySet().forEach(entry -> this.convertAndAdd(profile, AttributeLocation.PROFILE_ATTRIBUTE, (String)entry.getKey(), entry.getValue()));
        }
        if (authenticationAttributes != null) {
            authenticationAttributes.entrySet().forEach(entry -> this.convertAndAdd(profile, AttributeLocation.AUTHENTICATION_ATTRIBUTE, (String)entry.getKey(), entry.getValue()));
        }
    }

    protected void primary(String name, AttributeConverter converter) {
        this.primaryAttributes.add(name);
        this.converters.put(name, converter);
    }

    protected void secondary(String name, AttributeConverter converter) {
        this.secondaryAttributes.add(name);
        this.converters.put(name, converter);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getProfileId() {
        return this.profileId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<String> getPrimaryAttributes() {
        return this.primaryAttributes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<String> getSecondaryAttributes() {
        return this.secondaryAttributes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, AttributeConverter> getConverters() {
        return this.converters;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ProfileFactory getProfileFactory() {
        return this.profileFactory;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isRestoreProfileFromTypedId() {
        return this.restoreProfileFromTypedId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setProfileFactory(ProfileFactory profileFactory) {
        this.profileFactory = profileFactory;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setRestoreProfileFromTypedId(boolean restoreProfileFromTypedId) {
        this.restoreProfileFromTypedId = restoreProfileFromTypedId;
    }
}

