/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.logout;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import lombok.Generated;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.logout.LogoutActionBuilder;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasLogoutActionBuilder
implements LogoutActionBuilder {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasLogoutActionBuilder.class);
    private final String serverLogoutUrl;
    private final String postLogoutUrlParameter;

    public CasLogoutActionBuilder(String serverLogoutUrl, String postLogoutUrlParameter) {
        if (CommonHelper.isNotBlank(serverLogoutUrl)) {
            CommonHelper.assertNotBlank("postLogoutUrlParameter", postLogoutUrlParameter);
        }
        this.serverLogoutUrl = serverLogoutUrl;
        this.postLogoutUrlParameter = postLogoutUrlParameter;
    }

    @Override
    public Optional<RedirectionAction> getLogoutAction(CallContext ctx, UserProfile currentProfile, String targetUrl) {
        if (CommonHelper.isBlank(this.serverLogoutUrl)) {
            return Optional.empty();
        }
        String redirectUrl = this.serverLogoutUrl;
        if (CommonHelper.isNotBlank(targetUrl)) {
            redirectUrl = CommonHelper.addParameter(redirectUrl, this.postLogoutUrlParameter, targetUrl);
        }
        LOGGER.debug("redirectUrl: {}", (Object)redirectUrl);
        return Optional.of(HttpActionHelper.buildRedirectUrlAction(ctx.webContext(), redirectUrl));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "CasLogoutActionBuilder(serverLogoutUrl=" + this.serverLogoutUrl + ", postLogoutUrlParameter=" + this.postLogoutUrlParameter + ")";
    }
}

