/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.engine;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.FrameworkParameters;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.profile.factory.ProfileManagerFactory;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExceptionAwareLogic {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractExceptionAwareLogic.class);
    private String errorUrl;

    protected Object handleException(Exception e, HttpActionAdapter httpActionAdapter, WebContext context) {
        if (httpActionAdapter == null || context == null) {
            throw this.runtimeException(e);
        }
        if (e instanceof HttpAction) {
            HttpAction httpAction = (HttpAction)e;
            LOGGER.debug("extra HTTP action required in security: {}", (Object)httpAction.getCode());
            return httpActionAdapter.adapt(httpAction, context);
        }
        if (CommonHelper.isNotBlank(this.errorUrl)) {
            RedirectionAction action = HttpActionHelper.buildRedirectUrlAction(context, this.errorUrl);
            return httpActionAdapter.adapt(action, context);
        }
        throw this.runtimeException(e);
    }

    protected RuntimeException runtimeException(Exception exception) {
        if (exception instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)exception;
            throw runtimeException;
        }
        throw new RuntimeException(exception);
    }

    protected CallContext buildContext(Config config, FrameworkParameters parameters) {
        CommonHelper.assertNotNull("config", config);
        CommonHelper.assertNotNull("config.getWebContextFactory()", config.getWebContextFactory());
        WebContext webContext = config.getWebContextFactory().newContext(parameters);
        CommonHelper.assertNotNull("context", webContext);
        CommonHelper.assertNotNull("config.getSessionStoreFactory()", config.getSessionStoreFactory());
        SessionStore sessionStore = config.getSessionStoreFactory().newSessionStore(parameters);
        CommonHelper.assertNotNull("sessionStore", sessionStore);
        ProfileManagerFactory profileManagerFactory = config.getProfileManagerFactory();
        CommonHelper.assertNotNull("profileManagerFactory", profileManagerFactory);
        return new CallContext(webContext, sessionStore, profileManagerFactory);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getErrorUrl() {
        return this.errorUrl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setErrorUrl(String errorUrl) {
        this.errorUrl = errorUrl;
    }
}

