/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.Clock;
import java.time.ZonedDateTime;
import lombok.Generated;

public class ThrottledSubmission
implements Serializable {
    private static final long serialVersionUID = -853401483455717926L;
    private final String id;
    private final String key;
    private final ZonedDateTime value;
    private final String username;
    private final String clientIpAddress;
    private ZonedDateTime expiration;

    public boolean hasExpiredAlready() {
        ZonedDateTime now = ZonedDateTime.now(Clock.systemUTC());
        return this.expiration == null || now.isAfter(this.expiration) || now.isEqual(this.expiration);
    }

    @JsonIgnore
    public boolean isStillInExpirationWindow() {
        ZonedDateTime now = ZonedDateTime.now(Clock.systemUTC());
        return this.expiration != null && (this.expiration.isAfter(now) || this.expiration.isEqual(now));
    }

    @Generated
    private static ZonedDateTime $default$value() {
        return ZonedDateTime.now(Clock.systemUTC());
    }

    @Generated
    protected ThrottledSubmission(ThrottledSubmissionBuilder<?, ?> b) {
        this.id = b.id;
        this.key = b.key;
        this.value = b.value$set ? b.value$value : ThrottledSubmission.$default$value();
        this.username = b.username;
        this.clientIpAddress = b.clientIpAddress;
        this.expiration = b.expiration;
    }

    @Generated
    public static ThrottledSubmissionBuilder<?, ?> builder() {
        return new ThrottledSubmissionBuilderImpl();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public ZonedDateTime getValue() {
        return this.value;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getClientIpAddress() {
        return this.clientIpAddress;
    }

    @Generated
    public ZonedDateTime getExpiration() {
        return this.expiration;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThrottledSubmission)) {
            return false;
        }
        ThrottledSubmission other = (ThrottledSubmission)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.id;
        String other$id = other.id;
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$key = this.key;
        String other$key = other.key;
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        ZonedDateTime this$value = this.value;
        ZonedDateTime other$value = other.value;
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        String this$username = this.username;
        String other$username = other.username;
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$clientIpAddress = this.clientIpAddress;
        String other$clientIpAddress = other.clientIpAddress;
        if (this$clientIpAddress == null ? other$clientIpAddress != null : !this$clientIpAddress.equals(other$clientIpAddress)) {
            return false;
        }
        ZonedDateTime this$expiration = this.expiration;
        ZonedDateTime other$expiration = other.expiration;
        return !(this$expiration == null ? other$expiration != null : !((Object)this$expiration).equals(other$expiration));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ThrottledSubmission;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.id;
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $key = this.key;
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        ZonedDateTime $value = this.value;
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        String $username = this.username;
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $clientIpAddress = this.clientIpAddress;
        result = result * 59 + ($clientIpAddress == null ? 43 : $clientIpAddress.hashCode());
        ZonedDateTime $expiration = this.expiration;
        result = result * 59 + ($expiration == null ? 43 : ((Object)$expiration).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ThrottledSubmission(id=" + this.id + ", key=" + this.key + ", value=" + String.valueOf(this.value) + ", username=" + this.username + ", clientIpAddress=" + this.clientIpAddress + ", expiration=" + String.valueOf(this.expiration) + ")";
    }

    @Generated
    public ThrottledSubmission(String id, String key, ZonedDateTime value, String username, String clientIpAddress, ZonedDateTime expiration) {
        this.id = id;
        this.key = key;
        this.value = value;
        this.username = username;
        this.clientIpAddress = clientIpAddress;
        this.expiration = expiration;
    }

    @Generated
    public ThrottledSubmission withId(String id) {
        return this.id == id ? this : new ThrottledSubmission(id, this.key, this.value, this.username, this.clientIpAddress, this.expiration);
    }

    @Generated
    public ThrottledSubmission withKey(String key) {
        return this.key == key ? this : new ThrottledSubmission(this.id, key, this.value, this.username, this.clientIpAddress, this.expiration);
    }

    @Generated
    public ThrottledSubmission withValue(ZonedDateTime value) {
        return this.value == value ? this : new ThrottledSubmission(this.id, this.key, value, this.username, this.clientIpAddress, this.expiration);
    }

    @Generated
    public ThrottledSubmission withUsername(String username) {
        return this.username == username ? this : new ThrottledSubmission(this.id, this.key, this.value, username, this.clientIpAddress, this.expiration);
    }

    @Generated
    public ThrottledSubmission withClientIpAddress(String clientIpAddress) {
        return this.clientIpAddress == clientIpAddress ? this : new ThrottledSubmission(this.id, this.key, this.value, this.username, clientIpAddress, this.expiration);
    }

    @Generated
    public ThrottledSubmission withExpiration(ZonedDateTime expiration) {
        return this.expiration == expiration ? this : new ThrottledSubmission(this.id, this.key, this.value, this.username, this.clientIpAddress, expiration);
    }

    @Generated
    public void setExpiration(ZonedDateTime expiration) {
        this.expiration = expiration;
    }

    @Generated
    public static abstract class ThrottledSubmissionBuilder<C extends ThrottledSubmission, B extends ThrottledSubmissionBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String key;
        @Generated
        private boolean value$set;
        @Generated
        private ZonedDateTime value$value;
        @Generated
        private String username;
        @Generated
        private String clientIpAddress;
        @Generated
        private ZonedDateTime expiration;

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B key(String key) {
            this.key = key;
            return this.self();
        }

        @Generated
        public B value(ZonedDateTime value) {
            this.value$value = value;
            this.value$set = true;
            return this.self();
        }

        @Generated
        public B username(String username) {
            this.username = username;
            return this.self();
        }

        @Generated
        public B clientIpAddress(String clientIpAddress) {
            this.clientIpAddress = clientIpAddress;
            return this.self();
        }

        @Generated
        public B expiration(ZonedDateTime expiration) {
            this.expiration = expiration;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ThrottledSubmission.ThrottledSubmissionBuilder(id=" + this.id + ", key=" + this.key + ", value$value=" + String.valueOf(this.value$value) + ", username=" + this.username + ", clientIpAddress=" + this.clientIpAddress + ", expiration=" + String.valueOf(this.expiration) + ")";
        }
    }

    @Generated
    private static final class ThrottledSubmissionBuilderImpl
    extends ThrottledSubmissionBuilder<ThrottledSubmission, ThrottledSubmissionBuilderImpl> {
        @Generated
        private ThrottledSubmissionBuilderImpl() {
        }

        @Override
        @Generated
        protected ThrottledSubmissionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ThrottledSubmission build() {
            return new ThrottledSubmission(this);
        }
    }
}

