/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.panels.DerSchemaDetails;
import org.apache.syncope.client.console.panels.PlainSchemaDetails;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.BaseAjaxWizardBuilder;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.to.DerSchemaTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.to.VirSchemaTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;

public class SchemaTypeWizardBuilder
extends BaseAjaxWizardBuilder<SchemaTO> {
    private static final long serialVersionUID = -3893521796674873644L;
    protected final SchemaType schemaType;
    protected final SchemaRestClient schemaRestClient;
    protected final ListModel<MutablePair<Locale, String>> translations = new ListModel(new ArrayList());

    public SchemaTypeWizardBuilder(SchemaTO schemaTO, SchemaRestClient schemaRestClient, PageReference pageRef) {
        super(schemaTO, pageRef);
        this.schemaType = SchemaType.fromToClass(schemaTO.getClass());
        this.schemaRestClient = schemaRestClient;
    }

    protected Serializable onApplyInternal(SchemaTO modelObject) {
        modelObject.getLabels().clear();
        modelObject.getLabels().putAll(((List)this.translations.getObject()).stream().filter(Objects::nonNull).filter(translation -> translation.getKey() != null).filter(translation -> translation.getValue() != null).collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
        if (this.getOriginalItem() == null || StringUtils.isBlank((CharSequence)((SchemaTO)this.getOriginalItem()).getKey())) {
            this.schemaRestClient.create(this.schemaType, modelObject);
        } else {
            this.schemaRestClient.update(this.schemaType, modelObject);
        }
        return null;
    }

    protected WizardModel buildModelSteps(SchemaTO modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Details(modelObject));
        wizardModel.add((IWizardStep)new Labels(modelObject));
        return wizardModel;
    }

    public class Details
    extends WizardStep {
        private static final long serialVersionUID = 382498949020534783L;

        public Details(SchemaTO modelObject) {
            AjaxDropDownChoicePanel kind = new AjaxDropDownChoicePanel("kind", this.getString("kind"), (IModel)new Model());
            kind.setChoices(List.of(SchemaType.values()));
            kind.setOutputMarkupId(true);
            kind.setModelObject((Serializable)SchemaTypeWizardBuilder.this.schemaType);
            kind.setEnabled(false);
            this.add(new Component[]{kind});
            this.add(new Component[]{(switch (SchemaTypeWizardBuilder.this.schemaType) {
                case SchemaType.DERIVED -> new DerSchemaDetails("details", (DerSchemaTO)modelObject);
                case SchemaType.VIRTUAL -> SyncopeWebApplication.get().getVirSchemaDetailsPanelProvider().get("details", (VirSchemaTO)modelObject);
                default -> new PlainSchemaDetails("details", (PlainSchemaTO)modelObject);
            }).setOutputMarkupId(true)});
        }
    }

    public class Labels
    extends WizardStep {
        private static final long serialVersionUID = -3130973642912822270L;

        public Labels(SchemaTO modelObject) {
            this.setTitleModel((IModel)new ResourceModel("translations"));
            this.setOutputMarkupId(true);
            ((List)SchemaTypeWizardBuilder.this.translations.getObject()).clear();
            modelObject.getLabels().forEach((locale, display) -> ((List)SchemaTypeWizardBuilder.this.translations.getObject()).add(MutablePair.of((Object)locale, (Object)display)));
            ListView<MutablePair<Locale, String>> labels = new ListView<MutablePair<Locale, String>>("labels", SchemaTypeWizardBuilder.this.translations){
                private static final long serialVersionUID = -8746795666847966508L;

                protected void populateItem(final ListItem<MutablePair<Locale, String>> item) {
                    final MutablePair entry = (MutablePair)item.getModelObject();
                    AjaxTextFieldPanel locale = new AjaxTextFieldPanel("locale", "locale", (IModel)new Model(), true);
                    locale.getField().setModel((IModel)new IModel<String>(){
                        private static final long serialVersionUID = 1500045101360533133L;

                        public String getObject() {
                            return entry.getLeft() == null ? null : ((Locale)entry.getLeft()).toString();
                        }

                        public void setObject(String object) {
                            entry.setLeft((Object)LocaleUtils.toLocale((String)object));
                        }
                    });
                    locale.setRequired(true).hideLabel();
                    locale.setChoices(SyncopeConsoleSession.get().getSupportedLocales().stream().map(Objects::toString).collect(Collectors.toList()));
                    locale.addValidator((IValidator & Serializable)validatable -> {
                        try {
                            LocaleUtils.toLocale((String)((String)validatable.getValue()));
                        }
                        catch (Exception e) {
                            LOG.error("Invalid Locale: {}", validatable.getValue(), (Object)e);
                            validatable.error((IValidationError)new ValidationError("Invalid Locale: " + (String)validatable.getValue()));
                            RequestCycle.get().find(AjaxRequestTarget.class).ifPresent(t -> t.add(new Component[]{Labels.this}));
                        }
                    });
                    item.add(new Component[]{locale});
                    AjaxTextFieldPanel display = new AjaxTextFieldPanel("display", "display", (IModel)new Model());
                    display.getField().setModel((IModel)new IModel<String>(){
                        private static final long serialVersionUID = 1500045101360533133L;

                        public String getObject() {
                            return (String)entry.getRight();
                        }

                        public void setObject(String object) {
                            entry.setRight((Object)object);
                        }
                    });
                    display.setRequired(true).hideLabel();
                    item.add(new Component[]{display});
                    ActionsPanel<Serializable> actions = new ActionsPanel<Serializable>("toRemove", null);
                    actions.add(new ActionLink<Serializable>(){
                        private static final long serialVersionUID = -3722207913631435501L;

                        @Override
                        public void onClick(AjaxRequestTarget target, Serializable ignore) {
                            ((List)SchemaTypeWizardBuilder.this.translations.getObject()).remove(item.getIndex());
                            item.getParent().removeAll();
                            target.add(new Component[]{Labels.this});
                        }
                    }, ActionLink.ActionType.DELETE, "SCHEMA_UPDATE", true).hideLabel();
                    item.add(new Component[]{actions});
                }
            };
            this.add(new Component[]{labels.setReuseItems(true)});
            IndicatingAjaxButton addLabel = new IndicatingAjaxButton("addLabel"){
                private static final long serialVersionUID = -4804368561204623354L;

                protected void onSubmit(AjaxRequestTarget target) {
                    ((List)SchemaTypeWizardBuilder.this.translations.getObject()).add(MutablePair.of(null, null));
                    target.add(new Component[]{Labels.this});
                }
            };
            this.add(new Component[]{addLabel.setDefaultFormProcessing(false)});
        }
    }
}

