/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import org.apache.syncope.client.console.rest.ApplicationRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.JsonEditorPanel;
import org.apache.syncope.client.console.wizards.BaseAjaxWizardBuilder;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.to.ApplicationTO;
import org.apache.syncope.common.lib.to.PrivilegeTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;

public class PrivilegeWizardBuilder
extends BaseAjaxWizardBuilder<PrivilegeTO> {
    private static final long serialVersionUID = -1817419622749405208L;
    protected final ApplicationTO application;
    protected final ApplicationRestClient applicationRestClient;

    public PrivilegeWizardBuilder(ApplicationTO application, PrivilegeTO privilege, ApplicationRestClient applicationRestClient, PageReference pageRef) {
        super(privilege, pageRef);
        this.application = application;
        this.applicationRestClient = applicationRestClient;
    }

    protected WizardModel buildModelSteps(PrivilegeTO modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Profile(modelObject));
        wizardModel.add((IWizardStep)new Spec(modelObject));
        return wizardModel;
    }

    protected Serializable onApplyInternal(PrivilegeTO modelObject) {
        this.application.getPrivileges().removeIf(privilege -> privilege.getKey().equals(modelObject.getKey()));
        this.application.getPrivileges().add(modelObject);
        this.applicationRestClient.update(this.application);
        return modelObject;
    }

    public static class Profile
    extends WizardStep {
        private static final long serialVersionUID = 11881843064077955L;

        public Profile(PrivilegeTO privilege) {
            this.setTitleModel((IModel)(privilege.getKey() == null ? new StringResourceModel("privilege.new") : new StringResourceModel("privilege.edit", (IModel)Model.of((Serializable)privilege))));
            AjaxTextFieldPanel key = new AjaxTextFieldPanel("key", "key", (IModel)new PropertyModel((Object)privilege, "key"), false);
            key.setReadOnly(privilege.getKey() != null);
            key.setRequired(true);
            this.add(new Component[]{key});
            AjaxTextFieldPanel description = new AjaxTextFieldPanel("description", "description", (IModel)new PropertyModel((Object)privilege, "description"), false);
            description.setRequired(false);
            this.add(new Component[]{description});
        }
    }

    public static class Spec
    extends WizardStep {
        private static final long serialVersionUID = -3237113253888332643L;

        public Spec(PrivilegeTO privilege) {
            this.setTitleModel((IModel)(privilege.getKey() == null ? new StringResourceModel("privilege.new") : new StringResourceModel("privilege.edit", (IModel)Model.of((Serializable)privilege))));
            this.add(new Component[]{new JsonEditorPanel((IModel<String>)new PropertyModel((Object)privilege, "spec"))});
        }
    }
}

