/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.panels.ConfParam;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ParametersModalPanel;
import org.apache.syncope.client.console.rest.SyncopeRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.panels.WizardModalPanel;
import org.apache.syncope.client.ui.commons.wizards.AbstractModalPanelBuilder;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class ParametersDirectoryPanel
extends DirectoryPanel<ConfParam, ConfParam, ParametersProvider, SyncopeRestClient> {
    private static final long serialVersionUID = 2765863608539154422L;
    @SpringBean
    protected ConfParamOps confParamOps;

    public ParametersDirectoryPanel(String id, SyncopeRestClient restClient, PageReference pageRef) {
        super(id, new DirectoryPanel.Builder<ConfParam, ConfParam, SyncopeRestClient>(restClient, pageRef){
            private static final long serialVersionUID = 8769126634538601689L;

            @Override
            protected WizardMgtPanel<ConfParam> newInstance(String id, boolean wizardInModal) {
                throw new UnsupportedOperationException();
            }
        });
        this.itemKeyFieldName = "schema";
        this.disableCheckBoxes();
        this.addNewItemPanelBuilder(new AbstractModalPanelBuilder<ConfParam>(new ConfParam(), pageRef){
            private static final long serialVersionUID = 1995192603527154740L;

            public WizardModalPanel<ConfParam> build(String id, int index, AjaxWizard.Mode mode) {
                return new ParametersModalPanel(ParametersDirectoryPanel.this.modal, (ConfParam)this.newModelObject(), ParametersDirectoryPanel.this.confParamOps, mode, this.pageRef);
            }
        }, true);
        this.modal.size(Modal.Size.Default);
        this.initResultTable();
    }

    public ParametersDirectoryPanel(String id, DirectoryPanel.Builder<ConfParam, ConfParam, SyncopeRestClient> builder) {
        super(id, builder);
    }

    @Override
    protected ParametersProvider dataProvider() {
        return new ParametersProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "parameters.paginator.rows";
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    @Override
    protected List<IColumn<ConfParam, String>> getColumns() {
        ArrayList<IColumn<ConfParam, String>> columns = new ArrayList<IColumn<ConfParam, String>>();
        columns.add((IColumn<ConfParam, String>)new PropertyColumn((IModel)new ResourceModel("schema"), "schema"));
        columns.add((IColumn<ConfParam, String>)new PropertyColumn<ConfParam, String>((IModel)new ResourceModel("values"), "values"){
            private static final long serialVersionUID = -1822504503325964706L;

            public void populateItem(Item<ICellPopulator<ConfParam>> item, String componentId, IModel<ConfParam> rowModel) {
                if (((ConfParam)rowModel.getObject()).getValues().toString().length() > 96) {
                    item.add(new Component[]{new Label(componentId, (Serializable)((Object)ParametersDirectoryPanel.this.getString("tooLong"))).add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)"font-style:italic"))})});
                } else {
                    super.populateItem(item, componentId, rowModel);
                }
            }
        });
        return columns;
    }

    @Override
    public ActionsPanel<ConfParam> getActions(final IModel<ConfParam> model) {
        ActionsPanel<ConfParam> panel = super.getActions(model);
        panel.add(new ActionLink<ConfParam>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, ConfParam ignore) {
                target.add(new Component[]{ParametersDirectoryPanel.this.modal});
                ParametersDirectoryPanel.this.modal.header((IModel)new StringResourceModel("any.edit"));
                ParametersDirectoryPanel.this.modal.setContent((ModalPanel)new ParametersModalPanel(ParametersDirectoryPanel.this.modal, (ConfParam)model.getObject(), ParametersDirectoryPanel.this.confParamOps, AjaxWizard.Mode.EDIT, ParametersDirectoryPanel.this.pageRef));
                ParametersDirectoryPanel.this.modal.show(true);
            }
        }, ActionLink.ActionType.EDIT, null);
        panel.add(new ActionLink<ConfParam>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, ConfParam ignore) {
                try {
                    ParametersDirectoryPanel.this.confParamOps.remove(SyncopeConsoleSession.get().getDomain(), ((ConfParam)model.getObject()).getSchema());
                    SyncopeConsoleSession.get().success((Serializable)((Object)ParametersDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{ParametersDirectoryPanel.this.container});
                }
                catch (Exception e) {
                    DirectoryPanel.LOG.error("While deleting {}", model.getObject(), (Object)e);
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BaseWebPage)ParametersDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, null, true);
        return panel;
    }

    protected final class ParametersProvider
    extends DirectoryDataProvider<ConfParam> {
        private static final long serialVersionUID = -185944053385660794L;
        private final SortableDataProviderComparator<ConfParam> comparator;

        private ParametersProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("schema", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<ConfParam>(this);
        }

        public Iterator<ConfParam> iterator(long first, long count) {
            List list = ParametersDirectoryPanel.this.confParamOps.list(SyncopeConsoleSession.get().getDomain()).entrySet().stream().skip(first).limit(count).map(entry -> {
                ConfParam param = new ConfParam();
                param.setSchema((String)entry.getKey());
                param.setValues(entry.getValue());
                return param;
            }).collect(Collectors.toList());
            list.sort(this.comparator);
            return list.iterator();
        }

        public long size() {
            return ParametersDirectoryPanel.this.confParamOps.list(SyncopeConsoleSession.get().getDomain()).size();
        }

        public IModel<ConfParam> model(ConfParam object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

