/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.panels.ListViewPanel;
import org.apache.syncope.client.console.rest.LoggerConf;
import org.apache.syncope.client.console.rest.LoggerConfOp;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.logging.LogLevel;

public class LogsPanel
extends Panel {
    private static final long serialVersionUID = -6313532280206208227L;
    private static final Logger LOG = LoggerFactory.getLogger(LogsPanel.class);
    private final IModel<List<LoggerConf>> loggerConfs = new LoadableDetachableModel<List<LoggerConf>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<LoggerConf> load() {
            return LogsPanel.this.loggerConfOp.list();
        }
    };
    private final LoggerConfOp loggerConfOp;
    private final ListViewPanel<LoggerConf> loggerConfsView;

    public LogsPanel(String id, final LoggerConfOp loggerConfOp, PageReference pageRef) {
        super(id);
        this.loggerConfOp = loggerConfOp;
        WebMarkupContainer searchBoxContainer = new WebMarkupContainer("searchBox");
        this.add(new Component[]{searchBoxContainer.setOutputMarkupId(true)});
        Form form = new Form("form");
        searchBoxContainer.add(new Component[]{form});
        final Model keywordModel = new Model((Serializable)((Object)""));
        AjaxTextFieldPanel filter = new AjaxTextFieldPanel("filter", "filter", (IModel)keywordModel, true);
        form.add(new Component[]{filter.hideLabel().setOutputMarkupId(true).setRenderBodyOnly(true)});
        AjaxButton search = new AjaxButton("search"){
            private static final long serialVersionUID = 8390605330558248736L;

            protected void onSubmit(AjaxRequestTarget target) {
                this.send((IEventSink)LogsPanel.this, Broadcast.EXACT, new LoggerConfSearchEvent(target, (String)((Object)keywordModel.getObject())));
            }
        };
        form.add(new Component[]{search.setOutputMarkupId(true)});
        form.setDefaultButton((IFormSubmittingComponent)search);
        WebMarkupContainer loggerContainer = new WebMarkupContainer("loggerContainer");
        this.add(new Component[]{loggerContainer.setOutputMarkupId(true)});
        ListViewPanel.Builder<LoggerConf> builder = new ListViewPanel.Builder<LoggerConf>(LoggerConf.class, pageRef){
            private static final long serialVersionUID = 6957788356709885298L;

            @Override
            protected Component getValueComponent(String key, final LoggerConf loggerConf) {
                if ("level".equalsIgnoreCase(key)) {
                    final AjaxDropDownChoicePanel loggerLevel = new AjaxDropDownChoicePanel("field", LogsPanel.this.getString("level"), (IModel)Model.of((Serializable)loggerConf.getLevel()), false);
                    MetaDataRoleAuthorizationStrategy.authorize((Component)loggerLevel, (Action)Component.ENABLE, (String)"LOGGER_UPDATE");
                    loggerLevel.hideLabel();
                    loggerLevel.setChoices(List.of(LogLevel.values()));
                    loggerLevel.setNullValid(false);
                    loggerLevel.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                        private static final long serialVersionUID = -1107858522700306810L;

                        protected void onUpdate(AjaxRequestTarget target) {
                            try {
                                loggerConf.setLevel((LogLevel)loggerLevel.getModelObject());
                                loggerConfOp.setLevel(loggerConf.getKey(), loggerConf.getLevel());
                                SyncopeConsoleSession.get().success((Serializable)((Object)LogsPanel.this.getString("operation_succeeded")));
                                target.add(new Component[]{loggerLevel});
                            }
                            catch (SyncopeClientException e) {
                                LOG.error("Error updating the logger level", (Throwable)e);
                                SyncopeConsoleSession.get().onException((Exception)((Object)e));
                            }
                            ((BaseWebPage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                        }
                    }});
                    return loggerLevel;
                }
                return super.getValueComponent(key, loggerConf);
            }
        };
        builder.setItems((List)this.loggerConfs.getObject()).setModel(this.loggerConfs).includes("key", "level").withChecks(ListViewPanel.CheckAvailability.NONE).setCaptionVisible(false).setReuseItem(false);
        this.loggerConfsView = (ListViewPanel)builder.build("logger");
        loggerContainer.add(new Component[]{this.loggerConfsView});
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof LoggerConfSearchEvent) {
            LoggerConfSearchEvent payload = (LoggerConfSearchEvent)LoggerConfSearchEvent.class.cast(event.getPayload());
            AjaxRequestTarget target = payload.getTarget();
            String keyword = payload.getKeyword();
            if (StringUtils.isBlank((CharSequence)keyword)) {
                this.loggerConfsView.refreshList((List)this.loggerConfs.getObject());
            } else {
                this.loggerConfsView.refreshList(((List)this.loggerConfs.getObject()).stream().filter(l -> l.getKey().contains(keyword)).collect(Collectors.toList()));
            }
            target.add(new Component[]{this.loggerConfsView});
        } else {
            super.onEvent(event);
        }
    }

    private static class LoggerConfSearchEvent
    implements Serializable {
        private static final long serialVersionUID = -282052400565266028L;
        private final AjaxRequestTarget target;
        private final String keyword;

        LoggerConfSearchEvent(AjaxRequestTarget target, String keyword) {
            this.target = target;
            this.keyword = keyword;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }

        public String getKeyword() {
            return this.keyword;
        }
    }
}

