/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.rest.SyncopeRestClient;
import org.apache.syncope.client.ui.commons.HttpResourceStream;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.rest.ResponseHolder;
import org.apache.syncope.common.lib.info.SystemInfo;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.resource.IResourceStream;

public class DashboardSystemPanel
extends Panel {
    @SpringBean
    protected SyncopeRestClient syncopeRestClient;
    private static final long serialVersionUID = -776362411304859269L;

    public DashboardSystemPanel(String id) {
        super(id);
        Pair<String, String> gitAndBuildInfo = SyncopeConsoleSession.get().gitAndBuildInfo();
        Label version = new Label("version", (Serializable)gitAndBuildInfo.getRight());
        String versionLink = StringUtils.isNotBlank((CharSequence)((CharSequence)gitAndBuildInfo.getLeft())) && ((String)gitAndBuildInfo.getRight()).endsWith("-SNAPSHOT") ? "https://gitbox.apache.org/repos/asf?p=syncope.git;a=commit;h=" + (String)gitAndBuildInfo.getLeft() : "https://cwiki.apache.org/confluence/display/SYNCOPE/Maggiore";
        version.add(new Behavior[]{new AttributeModifier("onclick", (Serializable)((Object)("window.open('" + versionLink + "', '_blank')")))});
        this.add(new Component[]{version});
        SystemInfo systemInfo = SyncopeConsoleSession.get().getSystemInfo();
        this.add(new Component[]{new Label("hostname", (Serializable)((Object)systemInfo.getHostname()))});
        this.add(new Component[]{new Label("processors", (Serializable)Integer.valueOf(systemInfo.getAvailableProcessors()))});
        this.add(new Component[]{new Label("os", (Serializable)((Object)systemInfo.getOs()))});
        this.add(new Component[]{new Label("jvm", (Serializable)((Object)systemInfo.getJvm()))});
        final Model tableThresholdModel = Model.of((Serializable)Integer.valueOf(100));
        this.add(new Component[]{new TextField("tableThreshold", (IModel)tableThresholdModel).add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
            }
        }})});
        Link<Void> dbExportLink = new Link<Void>("dbExportLink"){
            private static final long serialVersionUID = -4331619903296515985L;

            public void onClick() {
                try {
                    HttpResourceStream stream = new HttpResourceStream(new ResponseHolder(DashboardSystemPanel.this.syncopeRestClient.exportInternalStorageContent((Integer)tableThresholdModel.getObject())));
                    ResourceStreamRequestHandler rsrh = new ResourceStreamRequestHandler((IResourceStream)stream);
                    rsrh.setFileName((String)(stream.getFilename() == null ? SyncopeConsoleSession.get().getDomain() + "Content.xml" : stream.getFilename()));
                    rsrh.setContentDisposition(ContentDisposition.ATTACHMENT);
                    rsrh.setCacheDuration(Duration.ZERO);
                    this.getRequestCycle().scheduleRequestHandlerAfterCurrent((IRequestHandler)rsrh);
                }
                catch (Exception e) {
                    SyncopeConsoleSession.get().onException(e);
                }
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)dbExportLink, (Action)WebPage.RENDER, (String)"KEYMASTER");
        this.add(new Component[]{dbExportLink});
    }
}

