/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.notifications;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.events.EventCategory;
import org.apache.syncope.client.console.events.EventCategoryPanel;
import org.apache.syncope.client.console.notifications.NotificationWrapper;
import org.apache.syncope.client.console.panels.search.AbstractSearchPanel;
import org.apache.syncope.client.console.panels.search.AnyObjectSearchPanel;
import org.apache.syncope.client.console.panels.search.GroupSearchPanel;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.UserSearchPanel;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.rest.NotificationRestClient;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiPanel;
import org.apache.syncope.client.console.wizards.BaseAjaxWizardBuilder;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.to.MailTemplateTO;
import org.apache.syncope.common.lib.to.NotificationTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.common.lib.types.TraceLevel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.EmailAddressValidator;

public class NotificationWizardBuilder
extends BaseAjaxWizardBuilder<NotificationWrapper> {
    private static final long serialVersionUID = -1975312550059578553L;
    protected final NotificationRestClient notificationRestClient;
    protected final AnyTypeRestClient anyTypeRestClient;
    protected final ImplementationRestClient implementationRestClient;
    protected final SchemaRestClient schemaRestClient;
    protected final IModel<List<EventCategory>> eventCategories;

    public NotificationWizardBuilder(NotificationTO notificationTO, NotificationRestClient notificationRestClient, AnyTypeRestClient anyTypeRestClient, ImplementationRestClient implementationRestClient, SchemaRestClient schemaRestClient, IModel<List<EventCategory>> eventCategories, PageReference pageRef) {
        super(new NotificationWrapper(notificationTO), pageRef);
        this.notificationRestClient = notificationRestClient;
        this.anyTypeRestClient = anyTypeRestClient;
        this.implementationRestClient = implementationRestClient;
        this.schemaRestClient = schemaRestClient;
        this.eventCategories = eventCategories;
    }

    protected Serializable onApplyInternal(NotificationWrapper modelObject) {
        boolean createFlag;
        modelObject.fillRecipientConditions();
        modelObject.fillAboutConditions();
        boolean bl = createFlag = ((NotificationTO)modelObject.getInnerObject()).getKey() == null;
        if (createFlag) {
            this.notificationRestClient.create((NotificationTO)modelObject.getInnerObject());
        } else {
            this.notificationRestClient.update((NotificationTO)modelObject.getInnerObject());
        }
        return null;
    }

    protected WizardModel buildModelSteps(NotificationWrapper modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Details(modelObject));
        wizardModel.add((IWizardStep)new Recipients(modelObject));
        wizardModel.add((IWizardStep)new Events(modelObject));
        wizardModel.add((IWizardStep)new Abouts(modelObject));
        return wizardModel;
    }

    protected List<String> getSchemas() {
        AnyTypeTO type = null;
        try {
            type = this.anyTypeRestClient.read(AnyTypeKind.USER.name());
        }
        catch (SyncopeClientException e) {
            LOG.error("While reading all any types", (Throwable)e);
        }
        String[] anyTypeClasses = Optional.ofNullable(type).map(anyTypeTO -> (String[])anyTypeTO.getClasses().toArray(String[]::new)).orElseGet(() -> new String[0]);
        ArrayList<String> result = new ArrayList<String>();
        result.add("username");
        result.addAll(this.schemaRestClient.getSchemas(SchemaType.PLAIN, null, anyTypeClasses).stream().map(SchemaTO::getKey).collect(Collectors.toList()));
        result.addAll(this.schemaRestClient.getSchemas(SchemaType.DERIVED, null, anyTypeClasses).stream().map(SchemaTO::getKey).collect(Collectors.toList()));
        result.addAll(this.schemaRestClient.getSchemas(SchemaType.VIRTUAL, null, anyTypeClasses).stream().map(SchemaTO::getKey).collect(Collectors.toList()));
        Collections.sort(result);
        return result;
    }

    public class Details
    extends WizardStep {
        private static final long serialVersionUID = -7709805590497687958L;

        public Details(NotificationWrapper modelObject) {
            NotificationTO notificationTO = (NotificationTO)modelObject.getInnerObject();
            boolean createFlag = notificationTO.getKey() == null;
            AjaxTextFieldPanel sender = new AjaxTextFieldPanel("sender", this.getString("sender"), (IModel)new PropertyModel((Object)notificationTO, "sender"));
            sender.addRequiredLabel();
            sender.addValidator((IValidator)EmailAddressValidator.getInstance());
            this.add(new Component[]{sender});
            AjaxTextFieldPanel subject = new AjaxTextFieldPanel("subject", this.getString("subject"), (IModel)new PropertyModel((Object)notificationTO, "subject"));
            subject.addRequiredLabel();
            this.add(new Component[]{subject});
            AjaxDropDownChoicePanel template = new AjaxDropDownChoicePanel("template", this.getString("template"), (IModel)new PropertyModel((Object)notificationTO, "template"));
            template.setChoices(NotificationWizardBuilder.this.notificationRestClient.listTemplates().stream().map(MailTemplateTO::getKey).collect(Collectors.toList()));
            template.addRequiredLabel();
            this.add(new Component[]{template});
            AjaxDropDownChoicePanel traceLevel = new AjaxDropDownChoicePanel("traceLevel", this.getString("traceLevel"), (IModel)new PropertyModel((Object)notificationTO, "traceLevel"));
            traceLevel.setChoices(List.of(TraceLevel.values()));
            traceLevel.addRequiredLabel();
            this.add(new Component[]{traceLevel});
            AjaxCheckBoxPanel isActive = new AjaxCheckBoxPanel("isActive", this.getString("isActive"), (IModel)new PropertyModel((Object)notificationTO, "active"));
            if (createFlag) {
                isActive.getField().setDefaultModelObject((Object)Boolean.TRUE);
            }
            this.add(new Component[]{isActive});
        }
    }

    public class Recipients
    extends WizardStep {
        private static final long serialVersionUID = -7709805590497687958L;
        private final IModel<List<String>> recipientProviders = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157447L;

            protected List<String> load() {
                return NotificationWizardBuilder.this.implementationRestClient.list("RECIPIENTS_PROVIDER").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
            }
        };

        public Recipients(NotificationWrapper modelObject) {
            this.setTitleModel((IModel)new ResourceModel("recipients"));
            NotificationTO notificationTO = (NotificationTO)modelObject.getInnerObject();
            AjaxTextFieldPanel recipientAttrName = new AjaxTextFieldPanel("recipientAttrName", new ResourceModel("recipientAttrName", "recipientAttrName").getObject(), (IModel)new PropertyModel((Object)notificationTO, "recipientAttrName"));
            recipientAttrName.setChoices(NotificationWizardBuilder.this.getSchemas());
            recipientAttrName.addRequiredLabel();
            recipientAttrName.setTitle(this.getString("intAttrNameInfo.help") + "<code>groups[groupName].attribute</code>, <code>users[userName].attribute</code>, <code>anyObjects[anyObjectName].attribute</code>, <code>relationships[relationshipType][anyType].attribute</code> or <code>memberships[groupName].attribute</code> or <code>privileges[applicationKey]</code>", true);
            this.add(new Component[]{recipientAttrName});
            AjaxTextFieldPanel staticRecipientsFieldPanel = new AjaxTextFieldPanel("panel", "staticRecipients", (IModel)new Model());
            staticRecipientsFieldPanel.addValidator((IValidator)EmailAddressValidator.getInstance());
            this.add(new Component[]{new MultiFieldPanel.Builder(new PropertyModel((Object)notificationTO, "staticRecipients")).build("staticRecipients", "staticRecipients", staticRecipientsFieldPanel).hideLabel()});
            this.add(new Component[]{new UserSearchPanel.Builder((IModel<List<SearchClause>>)new PropertyModel((Object)modelObject, "recipientClauses"), NotificationWizardBuilder.this.pageRef).required(false).build("recipients")});
            AjaxDropDownChoicePanel recipientsProvider = new AjaxDropDownChoicePanel("recipientsProvider", "recipientsProvider", (IModel)new PropertyModel((Object)notificationTO, "recipientsProvider"), false);
            recipientsProvider.setChoices((List)this.recipientProviders.getObject());
            this.add(new Component[]{recipientsProvider});
            AjaxCheckBoxPanel selfAsRecipient = new AjaxCheckBoxPanel("selfAsRecipient", this.getString("selfAsRecipient"), (IModel)new PropertyModel((Object)notificationTO, "selfAsRecipient"));
            if (notificationTO.getKey() == null) {
                selfAsRecipient.getField().setDefaultModelObject((Object)Boolean.FALSE);
            }
            this.add(new Component[]{selfAsRecipient});
        }
    }

    public class Events
    extends WizardStep {
        private static final long serialVersionUID = -7709805590497687958L;

        public Events(NotificationWrapper modelObject) {
            this.setTitleModel((IModel)new ResourceModel("events"));
            this.add(new Component[]{new EventCategoryPanel("eventSelection", (List)NotificationWizardBuilder.this.eventCategories.getObject(), (IModel)new PropertyModel((Object)modelObject.getInnerObject(), "events")){
                private static final long serialVersionUID = 6429053774964787735L;

                @Override
                protected List<String> getListAuthRoles() {
                    return List.of();
                }

                @Override
                protected List<String> getChangeAuthRoles() {
                    return List.of();
                }
            }});
        }
    }

    public class Abouts
    extends WizardStep {
        private static final long serialVersionUID = -7709805590497687958L;

        public Abouts(NotificationWrapper modelObject) {
            this.setTitleModel((IModel)new ResourceModel("about"));
            WebMarkupContainer aboutContainer = new WebMarkupContainer("about");
            aboutContainer.setOutputMarkupId(true);
            this.add(new Component[]{aboutContainer});
            PropertyModel model = new PropertyModel((Object)modelObject, "aboutClauses");
            aboutContainer.add(new Component[]{new MultiPanel<Pair<String, List<SearchClause>>>("abouts", "abouts", (IModel)model){
                private static final long serialVersionUID = -2481579077338205547L;

                protected Pair<String, List<SearchClause>> newModelObject() {
                    return Pair.of((Object)AnyTypeKind.USER.name(), new ArrayList());
                }

                protected About getItemPanel(final ListItem<Pair<String, List<SearchClause>>> item) {
                    return new About("panel", (IModel<Pair<String, List<SearchClause>>>)new Model<Pair<String, List<SearchClause>>>(){
                        private static final long serialVersionUID = 6799404673615637845L;

                        public Pair<String, List<SearchClause>> getObject() {
                            return (Pair)item.getModelObject();
                        }

                        public void setObject(Pair<String, List<SearchClause>> object) {
                            item.setModelObject(object);
                        }

                        public void detach() {
                        }
                    });
                }

                protected void sendError(String message) {
                    SyncopeConsoleSession.get().error((Serializable)((Object)this.getString("operation_error")));
                }
            }.hideLabel()});
        }
    }

    public class About
    extends Panel {
        private static final long serialVersionUID = -9149543787708482882L;

        public About(String id, final IModel<Pair<String, List<SearchClause>>> model) {
            super(id, model);
            this.setOutputMarkupId(true);
            AjaxDropDownChoicePanel type = new AjaxDropDownChoicePanel("about", "anyType", (IModel)new Model<String>(){
                private static final long serialVersionUID = -2350296434572623272L;

                public String getObject() {
                    return (String)((Pair)model.getObject()).getLeft();
                }

                public void setObject(String object) {
                    model.setObject((Object)Pair.of((Object)object, (Object)((List)((Pair)model.getObject()).getRight())));
                }
            });
            type.setChoices(NotificationWizardBuilder.this.anyTypeRestClient.list());
            type.addRequiredLabel();
            this.add(new Component[]{type});
            ListModel<SearchClause> clauseModel = new ListModel<SearchClause>(){
                private static final long serialVersionUID = 3769540249683319782L;

                public List<SearchClause> getObject() {
                    return (List)((Pair)model.getObject()).getRight();
                }

                public void setObject(List<SearchClause> object) {
                    ((Pair)model.getObject()).setValue(object);
                }
            };
            WebMarkupContainer searchContainer = new WebMarkupContainer("search");
            this.add(new Component[]{searchContainer.setOutputMarkupId(true)});
            searchContainer.add(new Component[]{this.getClauseBuilder((String)((Pair)model.getObject()).getLeft(), clauseModel).build("clauses")});
            type.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change", (ListModel)clauseModel, searchContainer, type){
                private static final long serialVersionUID = -1107858522700306810L;
                final /* synthetic */ ListModel val$clauseModel;
                final /* synthetic */ WebMarkupContainer val$searchContainer;
                final /* synthetic */ AjaxDropDownChoicePanel val$type;
                {
                    this.val$clauseModel = listModel;
                    this.val$searchContainer = webMarkupContainer;
                    this.val$type = ajaxDropDownChoicePanel;
                    super(event);
                }

                protected void onUpdate(AjaxRequestTarget target) {
                    ((List)this.val$clauseModel.getObject()).clear();
                    this.val$searchContainer.addOrReplace(new Component[]{About.this.getClauseBuilder((String)((Object)this.val$type.getModelObject()), (ListModel<SearchClause>)this.val$clauseModel).build("clauses").setRenderBodyOnly(true)});
                    target.add(new Component[]{this.val$searchContainer});
                }
            }});
        }

        private AbstractSearchPanel.Builder<?> getClauseBuilder(String type, ListModel<SearchClause> clauseModel) {
            return switch (type) {
                case "USER" -> new UserSearchPanel.Builder((IModel<List<SearchClause>>)clauseModel, NotificationWizardBuilder.this.pageRef);
                case "GROUP" -> new GroupSearchPanel.Builder((IModel<List<SearchClause>>)clauseModel, NotificationWizardBuilder.this.pageRef);
                default -> new AnyObjectSearchPanel.Builder(type, (IModel<List<SearchClause>>)clauseModel, NotificationWizardBuilder.this.pageRef);
            };
        }
    }
}

