/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.okta;

import com.okta.authn.sdk.AuthenticationStateHandlerAdapter;
import com.okta.authn.sdk.resource.AuthenticationResponse;
import com.okta.authn.sdk.resource.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.AccountLockedException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationPasswordPolicyHandlingStrategy;
import org.apereo.cas.authentication.MessageDescriptor;
import org.apereo.cas.authentication.exceptions.AccountPasswordMustChangeException;
import org.apereo.cas.authentication.support.password.PasswordPolicyContext;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OktaAuthenticationStateHandlerAdapter
extends AuthenticationStateHandlerAdapter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OktaAuthenticationStateHandlerAdapter.class);
    private final AuthenticationPasswordPolicyHandlingStrategy passwordPolicyHandlingStrategy;
    private final PasswordPolicyContext passwordPolicyConfiguration;
    private final Map<String, List<Object>> userAttributes = new HashMap<String, List<Object>>(0);
    private String username;
    private Exception failureException;
    private List<MessageDescriptor> warnings = new ArrayList<MessageDescriptor>(0);

    public void handleUnknown(AuthenticationResponse authenticationResponse) {
        this.failureException = new AccountNotFoundException(authenticationResponse.getStatusString());
    }

    public void handleUnauthenticated(AuthenticationResponse unauthenticatedResponse) {
        this.failureException = new FailedLoginException(unauthenticatedResponse.getStatusString());
    }

    public void handleSuccess(AuthenticationResponse successResponse) {
        if (StringUtils.isNotBlank((CharSequence)successResponse.getSessionToken())) {
            User user = successResponse.getUser();
            this.username = user.getLogin();
            FunctionUtils.doIfNotNull((Object)successResponse.getSessionToken(), value -> this.userAttributes.put("oktaSessionToken", CollectionUtils.wrapList((Object[])new Object[]{value})));
            FunctionUtils.doIfNotNull((Object)successResponse.getStatusString(), value -> this.userAttributes.put("oktaStatus", CollectionUtils.wrapList((Object[])new Object[]{value})));
            FunctionUtils.doIfNotNull((Object)successResponse.getType(), value -> this.userAttributes.put("oktaType", CollectionUtils.wrapList((Object[])new Object[]{value})));
            FunctionUtils.doIfNotNull((Object)successResponse.getExpiresAt(), value -> this.userAttributes.put("oktaExpiration", CollectionUtils.wrapList((Object[])new Object[]{value})));
            FunctionUtils.doIfNotNull((Object)successResponse.getRecoveryType(), value -> this.userAttributes.put("oktaRecoveryType", CollectionUtils.wrapList((Object[])new Object[]{value})));
            user.getProfile().forEach((key, value) -> this.userAttributes.put((String)key, CollectionUtils.wrapList((Object[])new Object[]{value})));
        } else {
            this.handleUnauthenticated(successResponse);
        }
    }

    public void handlePasswordWarning(AuthenticationResponse passwordWarning) {
        try {
            if (this.passwordPolicyHandlingStrategy.supports((Object)passwordWarning)) {
                this.warnings = this.passwordPolicyHandlingStrategy.handle((Object)passwordWarning, (Object)this.passwordPolicyConfiguration);
            }
        }
        catch (Throwable e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        this.handleUnknown(passwordWarning);
    }

    public void handlePasswordExpired(AuthenticationResponse passwordExpired) {
        this.failureException = new AccountExpiredException(passwordExpired.getStatusString());
    }

    public void handlePasswordReset(AuthenticationResponse passwordReset) {
        this.failureException = new AccountPasswordMustChangeException(passwordReset.getStatusString());
    }

    public void handleLockedOut(AuthenticationResponse lockedOut) {
        this.failureException = new AccountLockedException(lockedOut.getStatusString());
    }

    public void throwExceptionIfNecessary() throws Exception {
        if (this.failureException != null) {
            throw this.failureException;
        }
    }

    @Generated
    public OktaAuthenticationStateHandlerAdapter(AuthenticationPasswordPolicyHandlingStrategy passwordPolicyHandlingStrategy, PasswordPolicyContext passwordPolicyConfiguration) {
        this.passwordPolicyHandlingStrategy = passwordPolicyHandlingStrategy;
        this.passwordPolicyConfiguration = passwordPolicyConfiguration;
    }

    @Generated
    public AuthenticationPasswordPolicyHandlingStrategy getPasswordPolicyHandlingStrategy() {
        return this.passwordPolicyHandlingStrategy;
    }

    @Generated
    public PasswordPolicyContext getPasswordPolicyConfiguration() {
        return this.passwordPolicyConfiguration;
    }

    @Generated
    public Map<String, List<Object>> getUserAttributes() {
        return this.userAttributes;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public Exception getFailureException() {
        return this.failureException;
    }

    @Generated
    public List<MessageDescriptor> getWarnings() {
        return this.warnings;
    }
}

