/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.web.flow;

import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.device.MultifactorAuthenticationRegisteredDevice;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecord;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.trusted.util.MultifactorAuthenticationTrustUtils;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.flow.actions.MultifactorAuthenticationTrustedDeviceProviderAction;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DefaultMultifactorAuthenticationTrustedDeviceProviderAction
extends BaseCasWebflowAction
implements MultifactorAuthenticationTrustedDeviceProviderAction {
    protected final ConfigurableApplicationContext applicationContext;
    protected final MultifactorAuthenticationTrustStorage mfaTrustEngine;

    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        Principal principal = authentication.getPrincipal();
        List<MultifactorAuthenticationRegisteredDevice> devices = this.mfaTrustEngine.get(principal.getId()).stream().map(this::mapMultifactorAuthenticationTrustRecord).toList();
        MultifactorAuthenticationTrustUtils.putMultifactorAuthenticationTrustedDevices(requestContext, devices);
        return null;
    }

    protected MultifactorAuthenticationRegisteredDevice mapMultifactorAuthenticationTrustRecord(MultifactorAuthenticationTrustRecord device) {
        String source = MultifactorAuthenticationUtils.getMultifactorAuthenticationProviderById((String)device.getMultifactorAuthenticationProvider(), (ApplicationContext)this.applicationContext).map(MultifactorAuthenticationProvider::getFriendlyName).orElse("Unknown");
        ZonedDateTime expirationDate = DateTimeUtils.zonedDateTimeOf((Date)device.getExpirationDate());
        return MultifactorAuthenticationRegisteredDevice.builder().id(String.valueOf(device.getId())).model(device.getRecordKey()).type(device.getDeviceFingerprint()).name(device.getName()).payload(device.toJson()).expirationDateTime(expirationDate != null ? expirationDate.toString() : null).lastUsedDateTime(device.getRecordDate().toString()).source(source).build();
    }

    @Generated
    public DefaultMultifactorAuthenticationTrustedDeviceProviderAction(ConfigurableApplicationContext applicationContext, MultifactorAuthenticationTrustStorage mfaTrustEngine) {
        this.applicationContext = applicationContext;
        this.mfaTrustEngine = mfaTrustEngine;
    }
}

