/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.web;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecord;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.util.CompressionUtils;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Endpoint(id="multifactorTrustedDevices", enableByDefault=false)
public class MultifactorAuthenticationTrustedDevicesReportEndpoint
extends BaseCasRestActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthenticationTrustedDevicesReportEndpoint.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private final ObjectProvider<MultifactorAuthenticationTrustStorage> mfaTrustEngine;

    public MultifactorAuthenticationTrustedDevicesReportEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, ObjectProvider<MultifactorAuthenticationTrustStorage> mfaTrustEngine) {
        super(casProperties, applicationContext);
        this.mfaTrustEngine = mfaTrustEngine;
    }

    @GetMapping(produces={"application/json"})
    @Operation(summary="Get collection of trusted devices")
    public Set<? extends MultifactorAuthenticationTrustRecord> devices() {
        this.cleanExpiredRecords();
        return ((MultifactorAuthenticationTrustStorage)this.mfaTrustEngine.getObject()).getAll();
    }

    @GetMapping(value={"/{username}"}, produces={"application/json"})
    @Operation(summary="Get collection of trusted devices for the user", parameters={@Parameter(name="username", required=true, in=ParameterIn.PATH, description="The username to look up")})
    public Set<? extends MultifactorAuthenticationTrustRecord> devicesForUser(@PathVariable(name="username") String username) {
        this.cleanExpiredRecords();
        return ((MultifactorAuthenticationTrustStorage)this.mfaTrustEngine.getObject()).get(username);
    }

    @Operation(summary="Remove trusted device using its key", parameters={@Parameter(name="key", required=true, in=ParameterIn.PATH, description="The key to look up")})
    @DeleteMapping(value={"/{key}"}, produces={"application/json"})
    public Integer revoke(@PathVariable(name="key") String key) {
        ((MultifactorAuthenticationTrustStorage)this.mfaTrustEngine.getObject()).remove(key);
        return HttpStatus.OK.value();
    }

    @Operation(summary="Remove all trusted devices that have expired")
    @DeleteMapping(value={"/clean"}, produces={"application/json"})
    public Integer clean() {
        this.cleanExpiredRecords();
        return HttpStatus.OK.value();
    }

    @Operation(summary="Remove expired trusted devices given an expiration date as a threshold", parameters={@Parameter(name="date", required=true, in=ParameterIn.QUERY, description="The expiration date to use")})
    @DeleteMapping(value={"/expire"}, produces={"application/json"})
    public Integer removeSince(@RequestParam(name="expiration") Date date) {
        ((MultifactorAuthenticationTrustStorage)this.mfaTrustEngine.getObject()).remove(DateTimeUtils.zonedDateTimeOf((Date)date));
        return HttpStatus.OK.value();
    }

    @PostMapping(path={"/import"}, consumes={"application/json"})
    @Operation(summary="Import a single trusted device record as a JSON document in the request body")
    public ResponseEntity importDevice(HttpServletRequest request) throws Exception {
        String requestBody = IOUtils.toString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
        LOGGER.trace("Submitted record: [{}]", (Object)requestBody);
        MultifactorAuthenticationTrustRecord deviceRec = (MultifactorAuthenticationTrustRecord)MAPPER.readValue(requestBody, (TypeReference)new TypeReference<MultifactorAuthenticationTrustRecord>(this){});
        LOGGER.trace("Storing device record: [{}]", (Object)deviceRec);
        MultifactorAuthenticationTrustRecord created = ((MultifactorAuthenticationTrustStorage)this.mfaTrustEngine.getObject()).save(deviceRec);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)created);
    }

    @GetMapping(path={"/export/{username}"}, produces={"application/octet-stream"})
    @ResponseBody
    @Operation(summary="Export all device records as a zip file for a given username", parameters={@Parameter(name="username", required=true, in=ParameterIn.PATH, description="The username to look up")})
    public ResponseEntity<Resource> exportUserDevices(@PathVariable(value="username") String username) {
        Set<? extends MultifactorAuthenticationTrustRecord> accounts = ((MultifactorAuthenticationTrustStorage)this.mfaTrustEngine.getObject()).get(username);
        WritableResource resource = CompressionUtils.toZipFile(accounts.stream(), (Function)Unchecked.function(entry -> {
            MultifactorAuthenticationTrustRecord acct = (MultifactorAuthenticationTrustRecord)entry;
            String fileName = String.format("%s-%s", acct.getPrincipal(), acct.getName());
            File sourceFile = Files.createTempFile(fileName, ".json", new FileAttribute[0]).toFile();
            MAPPER.writeValue(sourceFile, (Object)acct);
            return sourceFile;
        }), (String)("mfatrusteddevices-" + username));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentDisposition(ContentDisposition.attachment().filename(Objects.requireNonNull(resource.getFilename())).build());
        return new ResponseEntity((Object)resource, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(path={"/export"}, produces={"application/octet-stream"})
    @ResponseBody
    @Operation(summary="Export all device records as a zip file")
    public ResponseEntity<Resource> export() {
        Set<? extends MultifactorAuthenticationTrustRecord> accounts = ((MultifactorAuthenticationTrustStorage)this.mfaTrustEngine.getObject()).getAll();
        WritableResource resource = CompressionUtils.toZipFile(accounts.stream(), (Function)Unchecked.function(entry -> {
            MultifactorAuthenticationTrustRecord acct = (MultifactorAuthenticationTrustRecord)entry;
            String fileName = String.format("%s-%s", acct.getPrincipal(), acct.getName());
            File sourceFile = Files.createTempFile(fileName, ".json", new FileAttribute[0]).toFile();
            MAPPER.writeValue(sourceFile, (Object)acct);
            return sourceFile;
        }), (String)"mfatrusteddevices");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentDisposition(ContentDisposition.attachment().filename(Objects.requireNonNull(resource.getFilename())).build());
        return new ResponseEntity((Object)resource, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    private void cleanExpiredRecords() {
        ((MultifactorAuthenticationTrustStorage)this.mfaTrustEngine.getObject()).remove();
    }
}

